/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security;

import adsi.org.apache.xml.security.algorithms.JCEMapper;
import adsi.org.apache.xml.security.algorithms.SignatureAlgorithm;
import adsi.org.apache.xml.security.c14n.Canonicalizer;
import adsi.org.apache.xml.security.keys.KeyInfo;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolver;
import adsi.org.apache.xml.security.transforms.Transform;
import adsi.org.apache.xml.security.utils.ElementProxy;
import adsi.org.apache.xml.security.utils.I18n;
import adsi.org.apache.xml.security.utils.XMLUtils;
import adsi.org.apache.xml.security.utils.resolver.ResourceResolver;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Init {
    static Log log = LogFactory.getLog(Init.class.getName());
    private static boolean _alreadyInitialized = false;
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";

    public static final boolean isInitialized() {
        return _alreadyInitialized;
    }

    public static synchronized void init() {
        if (_alreadyInitialized) {
            return;
        }
        long XX_configure_i18n_end = 0L;
        long XX_configure_reg_c14n_start = 0L;
        long XX_configure_reg_c14n_end = 0L;
        long XX_configure_reg_jcemapper_end = 0L;
        long XX_configure_reg_keyInfo_start = 0L;
        long XX_configure_reg_keyResolver_end = 0L;
        long XX_configure_reg_prefixes_start = 0L;
        long XX_configure_reg_resourceresolver_start = 0L;
        long XX_configure_reg_sigalgos_end = 0L;
        long XX_configure_reg_transforms_end = 0L;
        long XX_configure_reg_keyInfo_end = 0L;
        long XX_configure_reg_keyResolver_start = 0L;
        _alreadyInitialized = true;
        try {
            long XX_init_start = System.currentTimeMillis();
            long XX_prng_start = System.currentTimeMillis();
            long XX_prng_end = System.currentTimeMillis();
            long XX_parsing_start = System.currentTimeMillis();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String cfile = System.getProperty("adsi.org.apache.xml.security.resource.config");
                    return this.getClass().getResourceAsStream(cfile != null ? cfile : "resource/config.xml");
                }
            });
            Document doc = db.parse(is);
            long XX_parsing_end = System.currentTimeMillis();
            long XX_configure_i18n_start = 0L;
            XX_configure_reg_keyInfo_start = System.currentTimeMillis();
            try {
                KeyInfo.init();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            XX_configure_reg_keyInfo_end = System.currentTimeMillis();
            long XX_configure_reg_transforms_start = 0L;
            long XX_configure_reg_jcemapper_start = 0L;
            long XX_configure_reg_sigalgos_start = 0L;
            long XX_configure_reg_resourceresolver_end = 0L;
            long XX_configure_reg_prefixes_end = 0L;
            Node config = doc.getFirstChild();
            while (config != null) {
                if ("Configuration".equals(config.getLocalName())) break;
                config = config.getNextSibling();
            }
            Node el = config.getFirstChild();
            while (el != null) {
                if (el instanceof Element) {
                    String Description2;
                    String JAVACLASS;
                    Element[] resolverElem;
                    Object[] exArgs;
                    String JAVACLASS2;
                    String URI2;
                    String tag = el.getLocalName();
                    if (tag.equals("ResourceBundles")) {
                        XX_configure_i18n_start = System.currentTimeMillis();
                        Element resource = (Element)el;
                        Attr langAttr = resource.getAttributeNode("defaultLanguageCode");
                        Attr countryAttr = resource.getAttributeNode("defaultCountryCode");
                        String languageCode = langAttr == null ? null : langAttr.getNodeValue();
                        String countryCode = countryAttr == null ? null : countryAttr.getNodeValue();
                        I18n.init(languageCode, countryCode);
                        XX_configure_i18n_end = System.currentTimeMillis();
                    }
                    if (tag.equals("CanonicalizationMethods")) {
                        XX_configure_reg_c14n_start = System.currentTimeMillis();
                        Canonicalizer.init();
                        Element[] list = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "CanonicalizationMethod");
                        int i = 0;
                        while (i < list.length) {
                            URI2 = list[i].getAttributeNS(null, "URI");
                            JAVACLASS2 = list[i].getAttributeNS(null, "JAVACLASS");
                            try {
                                Class.forName(JAVACLASS2);
                                if (log.isDebugEnabled()) {
                                    log.debug("Canonicalizer.register(" + URI2 + ", " + JAVACLASS2 + ")");
                                }
                                Canonicalizer.register(URI2, JAVACLASS2);
                            }
                            catch (ClassNotFoundException e) {
                                exArgs = new Object[]{URI2, JAVACLASS2};
                                log.fatal(I18n.translate("algorithm.classDoesNotExist", exArgs));
                            }
                            ++i;
                        }
                        XX_configure_reg_c14n_end = System.currentTimeMillis();
                    }
                    if (tag.equals("TransformAlgorithms")) {
                        XX_configure_reg_transforms_start = System.currentTimeMillis();
                        Transform.init();
                        Element[] tranElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "TransformAlgorithm");
                        int i = 0;
                        while (i < tranElem.length) {
                            URI2 = tranElem[i].getAttributeNS(null, "URI");
                            JAVACLASS2 = tranElem[i].getAttributeNS(null, "JAVACLASS");
                            try {
                                Class.forName(JAVACLASS2);
                                if (log.isDebugEnabled()) {
                                    log.debug("Transform.register(" + URI2 + ", " + JAVACLASS2 + ")");
                                }
                                Transform.register(URI2, JAVACLASS2);
                            }
                            catch (ClassNotFoundException e) {
                                exArgs = new Object[]{URI2, JAVACLASS2};
                                log.fatal(I18n.translate("algorithm.classDoesNotExist", exArgs));
                            }
                            catch (NoClassDefFoundError ex) {
                                log.warn("Not able to found dependecies for algorithm, I'm keep working.");
                            }
                            ++i;
                        }
                        XX_configure_reg_transforms_end = System.currentTimeMillis();
                    }
                    if ("JCEAlgorithmMappings".equals(tag)) {
                        XX_configure_reg_jcemapper_start = System.currentTimeMillis();
                        JCEMapper.init((Element)el);
                        XX_configure_reg_jcemapper_end = System.currentTimeMillis();
                    }
                    if (tag.equals("SignatureAlgorithms")) {
                        XX_configure_reg_sigalgos_start = System.currentTimeMillis();
                        SignatureAlgorithm.providerInit();
                        Element[] sigElems = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "SignatureAlgorithm");
                        int i = 0;
                        while (i < sigElems.length) {
                            URI2 = sigElems[i].getAttributeNS(null, "URI");
                            JAVACLASS2 = sigElems[i].getAttributeNS(null, "JAVACLASS");
                            try {
                                Class.forName(JAVACLASS2);
                                if (log.isDebugEnabled()) {
                                    log.debug("SignatureAlgorithm.register(" + URI2 + ", " + JAVACLASS2 + ")");
                                }
                                SignatureAlgorithm.register(URI2, JAVACLASS2);
                            }
                            catch (ClassNotFoundException e) {
                                exArgs = new Object[]{URI2, JAVACLASS2};
                                log.fatal(I18n.translate("algorithm.classDoesNotExist", exArgs));
                            }
                            ++i;
                        }
                        XX_configure_reg_sigalgos_end = System.currentTimeMillis();
                    }
                    if (tag.equals("ResourceResolvers")) {
                        XX_configure_reg_resourceresolver_start = System.currentTimeMillis();
                        ResourceResolver.init();
                        resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                        int i = 0;
                        while (i < resolverElem.length) {
                            JAVACLASS = resolverElem[i].getAttributeNS(null, "JAVACLASS");
                            Description2 = resolverElem[i].getAttributeNS(null, "DESCRIPTION");
                            if (Description2 != null && Description2.length() > 0) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Register Resolver: " + JAVACLASS + ": " + Description2);
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug("Register Resolver: " + JAVACLASS + ": For unknown purposes");
                            }
                            try {
                                ResourceResolver.register(JAVACLASS);
                            }
                            catch (Throwable e) {
                                log.warn("Cannot register:" + JAVACLASS + " perhaps some needed jars are not installed", e);
                            }
                            XX_configure_reg_resourceresolver_end = System.currentTimeMillis();
                            ++i;
                        }
                    }
                    if (tag.equals("KeyResolver")) {
                        XX_configure_reg_keyResolver_start = System.currentTimeMillis();
                        KeyResolver.init();
                        resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                        int i = 0;
                        while (i < resolverElem.length) {
                            JAVACLASS = resolverElem[i].getAttributeNS(null, "JAVACLASS");
                            Description2 = resolverElem[i].getAttributeNS(null, "DESCRIPTION");
                            if (Description2 != null && Description2.length() > 0) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Register Resolver: " + JAVACLASS + ": " + Description2);
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug("Register Resolver: " + JAVACLASS + ": For unknown purposes");
                            }
                            KeyResolver.register(JAVACLASS);
                            ++i;
                        }
                        XX_configure_reg_keyResolver_end = System.currentTimeMillis();
                    }
                    if (tag.equals("PrefixMappings")) {
                        XX_configure_reg_prefixes_start = System.currentTimeMillis();
                        if (log.isDebugEnabled()) {
                            log.debug("Now I try to bind prefixes:");
                        }
                        Element[] nl = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "PrefixMapping");
                        int i = 0;
                        while (i < nl.length) {
                            String namespace = nl[i].getAttributeNS(null, "namespace");
                            String prefix = nl[i].getAttributeNS(null, "prefix");
                            if (log.isDebugEnabled()) {
                                log.debug("Now I try to bind " + prefix + " to " + namespace);
                            }
                            ElementProxy.setDefaultPrefix(namespace, prefix);
                            ++i;
                        }
                        XX_configure_reg_prefixes_end = System.currentTimeMillis();
                    }
                }
                el = el.getNextSibling();
            }
            long XX_init_end = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("XX_init                             " + (int)(XX_init_end - XX_init_start) + " ms");
                log.debug("  XX_prng                           " + (int)(XX_prng_end - XX_prng_start) + " ms");
                log.debug("  XX_parsing                        " + (int)(XX_parsing_end - XX_parsing_start) + " ms");
                log.debug("  XX_configure_i18n                 " + (int)(XX_configure_i18n_end - XX_configure_i18n_start) + " ms");
                log.debug("  XX_configure_reg_c14n             " + (int)(XX_configure_reg_c14n_end - XX_configure_reg_c14n_start) + " ms");
                log.debug("  XX_configure_reg_jcemapper        " + (int)(XX_configure_reg_jcemapper_end - XX_configure_reg_jcemapper_start) + " ms");
                log.debug("  XX_configure_reg_keyInfo          " + (int)(XX_configure_reg_keyInfo_end - XX_configure_reg_keyInfo_start) + " ms");
                log.debug("  XX_configure_reg_keyResolver      " + (int)(XX_configure_reg_keyResolver_end - XX_configure_reg_keyResolver_start) + " ms");
                log.debug("  XX_configure_reg_prefixes         " + (int)(XX_configure_reg_prefixes_end - XX_configure_reg_prefixes_start) + " ms");
                log.debug("  XX_configure_reg_resourceresolver " + (int)(XX_configure_reg_resourceresolver_end - XX_configure_reg_resourceresolver_start) + " ms");
                log.debug("  XX_configure_reg_sigalgos         " + (int)(XX_configure_reg_sigalgos_end - XX_configure_reg_sigalgos_start) + " ms");
                log.debug("  XX_configure_reg_transforms       " + (int)(XX_configure_reg_transforms_end - XX_configure_reg_transforms_start) + " ms");
            }
        }
        catch (Exception e) {
            log.fatal("Bad: ", e);
            e.printStackTrace();
        }
    }
}

