/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.c14n.implementations;

import adsi.org.apache.xml.security.c14n.CanonicalizationException;
import adsi.org.apache.xml.security.c14n.helper.C14nHelper;
import adsi.org.apache.xml.security.c14n.implementations.CanonicalizerBase;
import adsi.org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.transforms.params.InclusiveNamespaces;
import adsi.org.apache.xml.security.utils.XMLUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Canonicalizer20010315Excl
extends CanonicalizerBase {
    TreeSet _inclusiveNSSet = new TreeSet();
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    final SortedSet result = new TreeSet(COMPARE);

    public Canonicalizer20010315Excl(boolean includeComments) {
        super(includeComments);
    }

    @Override
    public byte[] engineCanonicalizeSubTree(Node rootNode) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, "", null);
    }

    @Override
    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, inclusiveNamespaces, null);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces, Node excl) throws CanonicalizationException {
        this._inclusiveNSSet = (TreeSet)InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces);
        return super.engineCanonicalizeSubTree(rootNode, excl);
    }

    public byte[] engineCanonicalize(XMLSignatureInput rootNode, String inclusiveNamespaces) throws CanonicalizationException {
        this._inclusiveNSSet = (TreeSet)InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces);
        return super.engineCanonicalize(rootNode);
    }

    @Override
    Iterator handleAttributesSubtree(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        String prefix;
        SortedSet result = this.result;
        result.clear();
        NamedNodeMap attrs = null;
        int attrsLength = 0;
        if (E.hasAttributes()) {
            attrs = E.getAttributes();
            attrsLength = attrs.getLength();
        }
        SortedSet visiblyUtilized = (SortedSet)this._inclusiveNSSet.clone();
        int i = 0;
        while (i < attrsLength) {
            Attr N = (Attr)attrs.item(i);
            if (XMLNS_URI != N.getNamespaceURI()) {
                String prefix2 = N.getPrefix();
                if (prefix2 != null && !prefix2.equals("xml") && !prefix2.equals("xmlns")) {
                    visiblyUtilized.add(prefix2);
                }
                result.add(N);
            } else {
                String NNodeValue;
                String NName = N.getLocalName();
                if (ns.addMapping(NName, NNodeValue = N.getNodeValue(), N) && C14nHelper.namespaceIsRelative(NNodeValue)) {
                    Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
                    throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
                }
            }
            ++i;
        }
        if (E.getNamespaceURI() != null) {
            prefix = E.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                prefix = "xmlns";
            }
        } else {
            prefix = "xmlns";
        }
        visiblyUtilized.add(prefix);
        for (String s : visiblyUtilized) {
            Attr key = ns.getMapping(s);
            if (key == null) continue;
            result.add(key);
        }
        return result.iterator();
    }

    @Override
    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet, String inclusiveNamespaces) throws CanonicalizationException {
        this._inclusiveNSSet = (TreeSet)InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces);
        return super.engineCanonicalizeXPathNodeSet(xpathNodeSet);
    }

    @Override
    final Iterator handleAttributes(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        boolean isOutputElement;
        SortedSet result = this.result;
        result.clear();
        NamedNodeMap attrs = null;
        int attrsLength = 0;
        if (E.hasAttributes()) {
            attrs = E.getAttributes();
            attrsLength = attrs.getLength();
        }
        Set visiblyUtilized = null;
        boolean bl = isOutputElement = this.isVisibleDO(E, ns.getLevel()) == 1;
        if (isOutputElement) {
            visiblyUtilized = (Set)this._inclusiveNSSet.clone();
        }
        int i = 0;
        while (i < attrsLength) {
            Attr N = (Attr)attrs.item(i);
            if (XMLNS_URI != N.getNamespaceURI()) {
                if (this.isVisible(N) && isOutputElement) {
                    String prefix = N.getPrefix();
                    if (prefix != null && !prefix.equals("xml") && !prefix.equals("xmlns")) {
                        visiblyUtilized.add(prefix);
                    }
                    result.add(N);
                }
            } else {
                String NName = N.getLocalName();
                if (isOutputElement && !this.isVisible(N) && NName != "xmlns") {
                    ns.removeMappingIfNotRender(NName);
                } else {
                    Node n;
                    String NNodeValue = N.getNodeValue();
                    if (!isOutputElement && this.isVisible(N) && this._inclusiveNSSet.contains(NName) && !ns.removeMappingIfRender(NName) && (n = ns.addMappingAndRender(NName, NNodeValue, N)) != null) {
                        result.add(n);
                        if (C14nHelper.namespaceIsRelative(N)) {
                            Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
                            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
                        }
                    }
                    if (ns.addMapping(NName, NNodeValue, N) && C14nHelper.namespaceIsRelative(NNodeValue)) {
                        Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
                        throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
                    }
                }
            }
            ++i;
        }
        if (isOutputElement) {
            Attr xmlns = E.getAttributeNodeNS(XMLNS_URI, "xmlns");
            if (xmlns != null && !this.isVisible(xmlns)) {
                ns.addMapping("xmlns", "", nullNode);
            }
            if (E.getNamespaceURI() != null) {
                String prefix = E.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    visiblyUtilized.add("xmlns");
                } else {
                    visiblyUtilized.add(prefix);
                }
            } else {
                visiblyUtilized.add("xmlns");
            }
            for (String s : visiblyUtilized) {
                Attr key = ns.getMapping(s);
                if (key == null) continue;
                result.add(key);
            }
        }
        return result.iterator();
    }

    @Override
    void circumventBugIfNeeded(XMLSignatureInput input) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        if (!input.isNeedsToBeExpanded() || this._inclusiveNSSet.isEmpty()) {
            return;
        }
        Document doc = null;
        doc = input.getSubNode() != null ? XMLUtils.getOwnerDocument(input.getSubNode()) : XMLUtils.getOwnerDocument(input.getNodeSet());
        XMLUtils.circumventBug2650(doc);
    }
}

