/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.keys.keyresolver;

import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import adsi.org.apache.xml.security.keys.storage.StorageResolver;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public abstract class KeyResolverSpi {
    protected Map _properties = null;
    protected boolean globalResolver = false;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        KeyResolverSpi tmp = this.cloneIfNeeded();
        if (!tmp.engineCanResolve(element, BaseURI, storage)) {
            return null;
        }
        return tmp.engineResolvePublicKey(element, BaseURI, storage);
    }

    private KeyResolverSpi cloneIfNeeded() throws KeyResolverException {
        KeyResolverSpi tmp = this;
        if (this.globalResolver) {
            try {
                tmp = (KeyResolverSpi)this.getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new KeyResolverException("", e);
            }
            catch (IllegalAccessException e) {
                throw new KeyResolverException("", e);
            }
        }
        return tmp;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        KeyResolverSpi tmp = this.cloneIfNeeded();
        if (!tmp.engineCanResolve(element, BaseURI, storage)) {
            return null;
        }
        return tmp.engineResolveX509Certificate(element, BaseURI, storage);
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        KeyResolverSpi tmp = this.cloneIfNeeded();
        if (!tmp.engineCanResolve(element, BaseURI, storage)) {
            return null;
        }
        return tmp.engineResolveSecretKey(element, BaseURI, storage);
    }

    public void engineSetProperty(String key, String value) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(key, value);
    }

    public String engineGetProperty(String key) {
        if (this._properties == null) {
            return null;
        }
        return (String)this._properties.get(key);
    }

    public boolean understandsProperty(String propertyToTest) {
        if (this._properties == null) {
            return false;
        }
        return this._properties.get(propertyToTest) != null;
    }

    public void setGlobalResolver(boolean globalResolver) {
        this.globalResolver = globalResolver;
    }
}

