/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.keys.keyresolver.implementations;

import adsi.org.apache.xml.security.encryption.EncryptedKey;
import adsi.org.apache.xml.security.encryption.XMLCipher;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import adsi.org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import adsi.org.apache.xml.security.keys.storage.StorageResolver;
import adsi.org.apache.xml.security.utils.XMLUtils;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(RSAKeyValueResolver.class.getName());
    Key _kek;
    String _algorithm;

    public EncryptedKeyResolver(String algorithm) {
        this._kek = null;
        this._algorithm = algorithm;
    }

    public EncryptedKeyResolver(String algorithm, Key kek) {
        this._algorithm = algorithm;
        this._kek = kek;
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        SecretKey key = null;
        if (log.isDebugEnabled()) {
            log.debug("EncryptedKeyResolver - Can I resolve " + element.getTagName());
        }
        if (element == null) {
            return null;
        }
        boolean isEncryptedKey = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
        if (isEncryptedKey) {
            log.debug("Passed an Encrypted Key");
            try {
                XMLCipher cipher = XMLCipher.getInstance();
                cipher.init(4, this._kek);
                EncryptedKey ek = cipher.loadEncryptedKey(element);
                key = (SecretKey)cipher.decryptKey(ek, this._algorithm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return key;
    }
}

