/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.keys.storage;

import adsi.org.apache.xml.security.keys.storage.StorageResolverException;
import adsi.org.apache.xml.security.keys.storage.StorageResolverSpi;
import adsi.org.apache.xml.security.keys.storage.implementations.KeyStoreResolver;
import adsi.org.apache.xml.security.keys.storage.implementations.SingleCertificateResolver;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageResolver {
    static Log log = LogFactory.getLog(StorageResolver.class.getName());
    List _storageResolvers = null;
    Iterator _iterator = null;

    public StorageResolver() {
    }

    public StorageResolver(StorageResolverSpi resolver) {
        this.add(resolver);
    }

    public void add(StorageResolverSpi resolver) {
        if (this._storageResolvers == null) {
            this._storageResolvers = new ArrayList();
        }
        this._storageResolvers.add(resolver);
        this._iterator = null;
    }

    public StorageResolver(KeyStore keyStore) {
        this.add(keyStore);
    }

    public void add(KeyStore keyStore) {
        try {
            this.add(new KeyStoreResolver(keyStore));
        }
        catch (StorageResolverException ex) {
            log.error("Could not add KeyStore because of: ", ex);
        }
    }

    public StorageResolver(X509Certificate x509certificate) {
        this.add(x509certificate);
    }

    public void add(X509Certificate x509certificate) {
        this.add(new SingleCertificateResolver(x509certificate));
    }

    public Iterator getIterator() {
        if (this._iterator == null) {
            if (this._storageResolvers == null) {
                this._storageResolvers = new ArrayList();
            }
            this._iterator = new StorageResolverIterator(this._storageResolvers.iterator());
        }
        return this._iterator;
    }

    public boolean hasNext() {
        if (this._iterator == null) {
            if (this._storageResolvers == null) {
                this._storageResolvers = new ArrayList();
            }
            this._iterator = new StorageResolverIterator(this._storageResolvers.iterator());
        }
        return this._iterator.hasNext();
    }

    public X509Certificate next() {
        return (X509Certificate)this._iterator.next();
    }

    static class StorageResolverIterator
    implements Iterator {
        Iterator _resolvers = null;

        public StorageResolverIterator(Iterator resolvers) {
            this._resolvers = resolvers;
        }

        @Override
        public boolean hasNext() {
            return this._resolvers.hasNext();
        }

        public Object next() {
            return this._resolvers.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

