/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.KeyGenerators;

import es.mityc.javasign.utils.Utils;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class KeyAgreementManager {
    public static final int pValue = 47;
    public static final int gValue = 71;

    public static void basicDiffieHellmanExample() throws Exception {
        int bitLength = 512;
        SecureRandom rnd = new SecureRandom();
        BigInteger p = BigInteger.probablePrime(bitLength, rnd);
        BigInteger g = BigInteger.probablePrime(bitLength, rnd);
        DHParameterSpec dhParams = new DHParameterSpec(p, g);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH", "BC");
        keyGen.initialize(dhParams, new SecureRandom(rnd.generateSeed(8)));
        KeyPair aPair = keyGen.generateKeyPair();
        KeyPair bPair = keyGen.generateKeyPair();
        KeyAgreement aKeyAgree = KeyAgreement.getInstance("DH", "BC");
        aKeyAgree.init(aPair.getPrivate());
        KeyAgreement bKeyAgree = KeyAgreement.getInstance("DH", "BC");
        bKeyAgree.init(bPair.getPrivate());
        aKeyAgree.doPhase(bPair.getPublic(), true);
        bKeyAgree.doPhase(aPair.getPublic(), true);
        BigInteger k1 = new BigInteger(aKeyAgree.generateSecret());
        BigInteger k2 = new BigInteger(bKeyAgree.generateSecret());
        if (!k1.equals(k2)) {
            System.out.println("Las claves generadas no coinciden!");
        } else {
            System.out.println("El secreto compartido coincide");
        }
        MessageDigest hash = MessageDigest.getInstance("SHA1", "BC");
        System.out.println(new String(hash.digest(aKeyAgree.generateSecret())));
        System.out.println(new String(hash.digest(bKeyAgree.generateSecret())));
    }

    public static void ellipticCurveKeyExchangeExample() throws Exception {
        int bitLength = 512;
        SecureRandom rnd = new SecureRandom();
        BigInteger p = BigInteger.probablePrime(bitLength, rnd);
        BigInteger g = BigInteger.probablePrime(bitLength, rnd);
        KeyAgreementManager.createSpecificKey(p, g);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDH", "BC");
        EllipticCurve curve = new EllipticCurve(new ECFieldFp(new BigInteger("fffffffffffffffffffffffffffffffeffffffffffffffff", 16)), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16));
        ECParameterSpec ecSpec = new ECParameterSpec(curve, new ECPoint(new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16)), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), 1);
        keyGen.initialize(ecSpec, new SecureRandom());
        KeyPair aPair = keyGen.generateKeyPair();
        KeyPair bPair = keyGen.generateKeyPair();
        KeyAgreement aKeyAgree = KeyAgreement.getInstance("ECDH", "BC");
        aKeyAgree.init(aPair.getPrivate());
        KeyAgreement bKeyAgree = KeyAgreement.getInstance("ECDH", "BC");
        bKeyAgree.init(bPair.getPrivate());
        aKeyAgree.doPhase(bPair.getPublic(), true);
        bKeyAgree.doPhase(aPair.getPublic(), true);
        MessageDigest hash = MessageDigest.getInstance("SHA1", "BC");
        BigInteger k1 = new BigInteger(aKeyAgree.generateSecret());
        BigInteger k2 = new BigInteger(bKeyAgree.generateSecret());
        if (!k1.equals(k2)) {
            System.out.println("Las claves generadas no coinciden!");
        } else {
            System.out.println("El secreto compartido coincide");
        }
        System.out.println(new String(hash.digest(aKeyAgree.generateSecret())));
        System.out.println(new String(hash.digest(bKeyAgree.generateSecret())));
    }

    public static void threeActorsKeyExchange() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH", "BC");
        int bitLength = 512;
        SecureRandom rnd = new SecureRandom();
        BigInteger p = BigInteger.probablePrime(bitLength, rnd);
        BigInteger g = BigInteger.probablePrime(bitLength, rnd);
        DHParameterSpec spec = new DHParameterSpec(p, g);
        keyGen.initialize(spec);
        KeyPair aPair = keyGen.generateKeyPair();
        KeyPair bPair = keyGen.generateKeyPair();
        KeyPair cPair = keyGen.generateKeyPair();
        KeyAgreement aKeyAgree = KeyAgreement.getInstance("DH", "BC");
        aKeyAgree.init(aPair.getPrivate());
        KeyAgreement bKeyAgree = KeyAgreement.getInstance("DH", "BC");
        bKeyAgree.init(bPair.getPrivate());
        KeyAgreement cKeyAgree = KeyAgreement.getInstance("DH", "BC");
        cKeyAgree.init(cPair.getPrivate());
        Key ac = aKeyAgree.doPhase(cPair.getPublic(), false);
        Key ba = bKeyAgree.doPhase(aPair.getPublic(), false);
        Key cb = cKeyAgree.doPhase(bPair.getPublic(), false);
        aKeyAgree.doPhase(cb, true);
        bKeyAgree.doPhase(ac, true);
        cKeyAgree.doPhase(ba, true);
        BigInteger k1 = new BigInteger(aKeyAgree.generateSecret());
        BigInteger k2 = new BigInteger(bKeyAgree.generateSecret());
        BigInteger k3 = new BigInteger(cKeyAgree.generateSecret());
        if (!k1.equals(k2)) {
            System.out.println("Las claves a y b generadas no coinciden!");
        } else {
            System.out.println("El secreto compartido entre a y b coincide");
        }
        if (!k2.equals(k3)) {
            System.out.println("Las claves b y c generadas no coinciden!");
        } else {
            System.out.println("El secreto compartido entre b y c coincide");
        }
        MessageDigest hash = MessageDigest.getInstance("SHA1", "BC");
        System.out.println(new String(hash.digest(aKeyAgree.generateSecret())));
        System.out.println(new String(hash.digest(bKeyAgree.generateSecret())));
        System.out.println(new String(hash.digest(cKeyAgree.generateSecret())));
        String plain = "TextoEnClaro123456789";
        SecretKey key = aKeyAgree.generateSecret("DESede");
        Cipher tripleDesCipher = Cipher.getInstance("DESede");
        tripleDesCipher.init(1, key);
        byte[] ciphertext = tripleDesCipher.doFinal(plain.getBytes());
        key = cKeyAgree.generateSecret("DESede");
        tripleDesCipher.init(2, key);
        byte[] restored = tripleDesCipher.doFinal(ciphertext);
        System.out.println(new String(restored));
    }

    public static void main(String[] args) throws Exception {
        if (Security.getProvider("BC") == null) {
            Utils.addBCProvider();
        }
        KeyAgreementManager.basicDiffieHellmanExample();
        KeyAgreementManager.ellipticCurveKeyExchangeExample();
        KeyAgreementManager.threeActorsKeyExchange();
    }

    public static void createSpecificKey(BigInteger p, BigInteger g) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DiffieHellman");
        if (p != null && g != null) {
            DHParameterSpec param = new DHParameterSpec(p, g);
            kpg.initialize(param);
        } else {
            kpg.initialize(512);
        }
        KeyPair kp = kpg.generateKeyPair();
        KeyFactory kfactory = KeyFactory.getInstance("DiffieHellman");
        DHPublicKeySpec kspec = kfactory.getKeySpec(kp.getPublic(), DHPublicKeySpec.class);
    }
}

