/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.steganography;

import es.mityc.javasign.utils.Base64Coder;
import es.mityc.javasign.utils.Utils;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import sun.awt.image.ImageFormatException;

public class StegoUtils {
    private static Log logger = LogFactory.getLog(StegoUtils.class);
    private static final String RESTAURATION_NODE_NAME = "RestaurationData";
    private static final String REST_DIGEST_NODE_NAME = "RestDigestData";

    public static byte[] imageToByteArray(BufferedImage image, String formato) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Convirtiendo imagen");
            logger.debug("Formato: " + formato);
        }
        ByteArrayOutputStream barrOS = new ByteArrayOutputStream();
        if (formato != null) {
            String imageType = formato.toLowerCase();
            if (imageType.equals("jp2")) {
                imageType = "jpeg 2000";
            }
            ImageIO.write((RenderedImage)image, imageType, barrOS);
        } else {
            ImageIO.write((RenderedImage)image, "png", barrOS);
        }
        barrOS.close();
        return barrOS.toByteArray();
    }

    public static BufferedImage byteArrayToImage(byte[] imageData) throws Exception {
        BufferedImage image = null;
        if (imageData == null) {
            return null;
        }
        image = ImageIO.read(new ByteArrayInputStream(imageData));
        if (image == null) {
            throw new Exception("La imagen no se puede leer");
        }
        return image;
    }

    public static int byteToInt(int b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    public static void appendRestaurationDataToXML(char[] data, File xml) throws Exception {
        FileInputStream fis = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Escribiendo datos en el fichero XML: " + xml.getAbsolutePath());
                logger.debug("Longitud de datos: " + (data != null ? Integer.valueOf(data.length) : "Datos nulos"));
            }
            fis = new FileInputStream(xml);
            Document doc = StegoUtils.getDocument(fis);
            if (logger.isDebugEnabled()) {
                logger.debug("Calculando posici\u00f3n");
            }
            Element restaurationDataElement = doc.createElement(RESTAURATION_NODE_NAME);
            String text = null;
            if (data == null) {
                text = "000000";
            } else {
                text = String.valueOf(data.length);
                while (text.length() < 6) {
                    text = "0" + text;
                }
            }
            restaurationDataElement.appendChild(doc.createTextNode(text));
            NodeList prevData = doc.getDocumentElement().getElementsByTagName(RESTAURATION_NODE_NAME);
            if (prevData != null && prevData.getLength() > 0) {
                doc.getDocumentElement().removeChild(prevData.item(0));
            }
            doc.getDocumentElement().appendChild(restaurationDataElement);
            if (logger.isDebugEnabled()) {
                logger.debug("Calculando digest");
            }
            Element restDigestDataElement = doc.createElement(REST_DIGEST_NODE_NAME);
            if (data == null) {
                text = "00000000000000000000000000000000000000000000";
            } else {
                byte[] buffer = new byte[data.length];
                int i = 0;
                while (i < data.length) {
                    buffer[i] = (byte)data[i];
                    ++i;
                }
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(buffer);
                byte[] a = md.digest();
                char[] r = Base64Coder.encode(a);
                text = new String(r);
            }
            restDigestDataElement.appendChild(doc.createTextNode(text));
            prevData = doc.getDocumentElement().getElementsByTagName(REST_DIGEST_NODE_NAME);
            if (prevData != null && prevData.getLength() > 0) {
                doc.getDocumentElement().removeChild(prevData.item(0));
            }
            doc.getDocumentElement().appendChild(restDigestDataElement);
            if (logger.isDebugEnabled()) {
                logger.debug("Escribiendo el resultado");
            }
            FileOutputStream f = new FileOutputStream(xml);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)f, "UTF-8");
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            Properties props = new Properties();
            props.setProperty("method", "XML");
            props.setProperty("encoding", "UTF-8");
            props.setProperty("omit-xml-declaration", "no");
            xformer.setOutputProperties(props);
            StringWriter salida = new StringWriter();
            xformer.transform(new DOMSource(doc), new StreamResult(salida));
            out.write(salida.toString());
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void appendRestaurationDataToImage(char[] data, File image) throws Exception {
        OutputStreamWriter fw = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("A\u00f1adiendo datos en la imagen: " + image.getAbsolutePath());
                logger.debug("Datos: " + data.length);
            }
            fw = new FileWriter(image, true);
            fw.append(new String(data));
            fw.flush();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteRestaurationDataInImage(File image, int pos) throws Exception {
        FileInputStream fis = null;
        ByteArrayOutputStream baosLeido = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Borrando datos de la imagen: " + image.getAbsolutePath());
                logger.debug("Posici\u00f3n: " + pos);
            }
            fis = new FileInputStream(image);
            int imgLenght = fis.available();
            baosLeido = new ByteArrayOutputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = fis.read(buffer, 0, 1024)) >= 0) {
                baosLeido.write(buffer, 0, bytesRead);
            }
            fis.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Escribiendo imagen");
            }
            FileOutputStream fileOutput = new FileOutputStream(image);
            BufferedOutputStream bufferedOutput = new BufferedOutputStream(fileOutput);
            bufferedOutput.write(baosLeido.toByteArray(), 0, imgLenght - pos);
            bufferedOutput.close();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (baosLeido != null) {
                try {
                    baosLeido.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] readRestaurationDataFromImage(File img, int pos, byte[] digest) throws Exception {
        ByteArrayOutputStream baosLeido = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Extrayendo datos de la imagen: " + img.getAbsolutePath());
                logger.debug("Posici\u00f3n: " + pos);
            }
            baosLeido = new ByteArrayOutputStream();
            if (pos > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Leyendo imagen");
                }
                FileInputStream fisImg = new FileInputStream(img);
                int imgLenght = fisImg.available();
                int bytesRead = 0;
                byte[] buffer = new byte[1024];
                while ((bytesRead = fisImg.read(buffer, 0, 1024)) >= 0) {
                    baosLeido.write(buffer, 0, bytesRead);
                }
                int from = imgLenght - pos;
                byte[] data = Arrays.copyOfRange(baosLeido.toByteArray(), from, imgLenght);
                if (logger.isDebugEnabled()) {
                    logger.debug("Datos extra\u00eddos. Comprobando la integridad...");
                }
                if (digest != null) {
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    md.update(data);
                    byte[] a = md.digest();
                    if (Arrays.equals(digest, a)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("D\u00e1tos validos");
                        }
                        byte[] byArray = data;
                        return byArray;
                    }
                    logger.debug("Los datos no superaron la validaci\u00f3n de Digest");
                    return null;
                }
                logger.error("Digest indicado nulo");
                return null;
            }
            logger.error("Posici\u00f3n indicada nula");
            return null;
        }
        finally {
            if (baosLeido != null) {
                try {
                    baosLeido.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static ArrayList<Object> getRestaurationDataFromXML(File xml) throws Exception {
        ArrayList<Object> res = new ArrayList<Object>(3);
        FileInputStream fis = null;
        try {
            ArrayList<Element> nodosDigest;
            ArrayList<Element> nodosReference;
            NodeList prevData;
            if (logger.isDebugEnabled()) {
                logger.debug("Extrayendo datos del XML: " + xml.getAbsolutePath());
            }
            fis = new FileInputStream(xml);
            Document doc = StegoUtils.getDocument(fis);
            if (logger.isDebugEnabled()) {
                logger.debug("Leyendo posici\u00f3n de los datos");
            }
            if ((prevData = doc.getElementsByTagName(RESTAURATION_NODE_NAME)) != null && prevData.getLength() > 0) {
                res.add(Integer.parseInt(prevData.item(0).getTextContent()));
            } else {
                res.add(-1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Leyendo nombre del fichero");
            }
            if ((nodosReference = StegoUtils.getChildElementByTagName(doc.getDocumentElement(), "Reference")) != null && nodosReference.size() > 0) {
                String name = null;
                int i = 0;
                while (i < nodosReference.size()) {
                    NamedNodeMap att = nodosReference.get(i).getAttributes();
                    int j = 0;
                    while (j < att.getLength()) {
                        Node at = att.item(j);
                        String attVal = at.getTextContent();
                        if (attVal != null && attVal.startsWith("." + File.separator)) {
                            name = attVal;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                res.add(name);
            } else {
                res.add(null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Leyendo valor de Digest");
            }
            if ((nodosDigest = StegoUtils.getChildElementByTagName(doc.getDocumentElement(), REST_DIGEST_NODE_NAME)) != null && nodosDigest.size() == 1) {
                String b64Val = nodosDigest.get(0).getTextContent();
                byte[] digest = Base64Coder.decode(b64Val);
                res.add(digest);
            } else {
                res.add(null);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    public static byte[] zipData(byte[] msg) throws Exception {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Comprimiendo datos en ZIP: " + msg.length);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(bos);
            zos.write(msg);
            zos.finish();
            zos.close();
            bos.close();
            byte[] data = bos.toByteArray();
            if (logger.isDebugEnabled()) {
                logger.debug("Datos comprimidos: " + data.length);
            }
            return data;
        }
        catch (IOException ioEx) {
            logger.error("Error al inflar los datos");
            if (logger.isDebugEnabled()) {
                logger.debug(ioEx);
            }
            throw ioEx;
        }
    }

    public static byte[] unzipData(byte[] msg) throws Exception {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Descomprimiendo datos en ZIP: " + msg.length);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(msg);
            GZIPInputStream zis = new GZIPInputStream(bis);
            msg = Utils.getStreamBytes(zis);
            zis.close();
            bis.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Datos inflados: " + msg.length);
            }
            return msg;
        }
        catch (IOException ioEx) {
            logger.error("Error al inflar los datos");
            if (logger.isDebugEnabled()) {
                logger.debug(ioEx);
            }
            throw ioEx;
        }
    }

    public static byte[] hashPass(String pass) {
        logger.debug("Se emplea el valor SHA256 como contrase\u00f1a.");
        if (pass == null || pass.trim().equals("")) {
            logger.error("Contrase\u00f1a nula o vac\u00eda. Se utiliza por defecto");
            return "3141592654Pi".getBytes();
        }
        Utils.addBCProvider();
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA256", "BC");
            return hash.digest(pass.getBytes());
        }
        catch (Exception e) {
            logger.error("Error al calcular el Digest de la contrase\u00f1a", e);
            return "3141592654Pi".getBytes();
        }
    }

    public static long hashPassLong(String pass) {
        byte[] byteHash = StegoUtils.hashPass(pass);
        byte[] hex = new byte[2 * byteHash.length];
        int index = 0;
        byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        int i = 0;
        while (i < byteHash.length) {
            int byteVal = byteHash[i] & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[byteVal >>> 4];
            hex[index++] = HEX_CHAR_TABLE[byteVal & 0xF];
            ++i;
        }
        String hexString = new String(hex);
        hexString = hexString.substring(0, 15);
        return Long.parseLong(hexString, 16);
    }

    private static Document getDocument(FileInputStream fis) throws Exception {
        ByteArrayOutputStream baosLeido = null;
        try {
            baosLeido = new ByteArrayOutputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();
            int bytesRead = 0;
            byte[] data = new byte[1024];
            while ((bytesRead = fis.read(data, 0, 1024)) >= 0) {
                baosLeido.write(data, 0, bytesRead);
            }
            InputSource isour = new InputSource(new ByteArrayInputStream(baosLeido.toByteArray()));
            Document document = db.parse(isour);
            return document;
        }
        finally {
            if (baosLeido != null) {
                try {
                    baosLeido.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static ArrayList<Element> getChildElementByTagName(Element padre, String name) {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        int i = 0;
        while (i < nodesHijos.getLength()) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() == 1) {
                if (name.equals(nodo.getLocalName())) {
                    resultado.add((Element)nodo);
                }
                if (nodo.hasChildNodes()) {
                    resultado.addAll(StegoUtils.getChildElementByTagName((Element)nodo, name));
                }
            }
            ++i;
        }
        return resultado;
    }

    public static File prepareImage(File imagen, File destino) throws Exception {
        int BUF_SIZE = 512;
        byte[] res = null;
        BufferedOutputStream fos = null;
        FileInputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] data = new byte[BUF_SIZE];
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Leyendo imagen.");
            }
            is = new FileInputStream(imagen);
            while ((bytesRead = ((InputStream)is).read(data, 0, BUF_SIZE)) >= 0) {
                bos.write(data, 0, bytesRead);
            }
            bos.flush();
            bos.close();
            ((InputStream)is).close();
            if (logger.isDebugEnabled()) {
                logger.debug("Realizando la conversi\u00f3n");
            }
            BufferedImage image = null;
            if (imagen.getName().endsWith("bmp")) {
                image = StegoUtils.convertBitmap(imagen);
                if ((destino = new File(String.valueOf(destino.getAbsolutePath()) + ".png")).exists()) {
                    destino = new File(String.valueOf(destino.getAbsolutePath()) + new Random().nextInt(100) + ".png");
                }
            } else if (imagen.getName().endsWith("jpg")) {
                image = StegoUtils.byteArrayToImage(bos.toByteArray());
                if ((destino = new File(String.valueOf(destino.getAbsolutePath()) + ".png")).exists()) {
                    destino = new File(String.valueOf(destino.getAbsolutePath()) + new Random().nextInt(100) + ".png");
                }
            } else {
                image = StegoUtils.byteArrayToImage(bos.toByteArray());
            }
            if (image == null) {
                throw new ImageFormatException("Imagen no compatible");
            }
            if (image.getType() != 1) {
                int width = image.getWidth();
                int height = image.getHeight();
                BufferedImage imageConv = new BufferedImage(width, height, 1);
                int x = 0;
                while (x < width) {
                    int y = 0;
                    while (y < height) {
                        imageConv.setRGB(x, y, image.getRGB(x, y));
                        ++y;
                    }
                    ++x;
                }
                String formatoDestino = destino.getAbsolutePath();
                formatoDestino = formatoDestino.substring(formatoDestino.lastIndexOf(46) + 1);
                res = StegoUtils.imageToByteArray(imageConv, formatoDestino);
            } else {
                String formatoDestino = destino.getAbsolutePath();
                formatoDestino = formatoDestino.substring(formatoDestino.lastIndexOf(46) + 1);
                res = StegoUtils.imageToByteArray(image, formatoDestino);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Escribiendo el resultado");
            }
            fos = new BufferedOutputStream(new FileOutputStream(destino));
            fos.write(res);
            File file = destino;
            return file;
        }
        catch (Exception e) {
            logger.error(e);
            throw e;
        }
        finally {
            block25: {
                if (fos != null) {
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (Throwable e) {
                        if (!logger.isDebugEnabled()) break block25;
                        logger.debug(e);
                    }
                }
            }
        }
    }

    public static BufferedImage convertBitmap(File imagen) {
        if (logger.isDebugEnabled()) {
            logger.debug("Convirtiendo el mapa de bits: " + imagen.getAbsolutePath());
        }
        Image image = null;
        FileInputStream fs = null;
        try {
            BufferedImage img;
            fs = new FileInputStream(imagen);
            int bflen = 14;
            byte[] bf = new byte[bflen];
            fs.read(bf, 0, bflen);
            int bilen = 40;
            byte[] bi = new byte[bilen];
            fs.read(bi, 0, bilen);
            if (logger.isDebugEnabled()) {
                logger.debug("Tipo de mapa de bits: " + (char)bf[0] + (char)bf[1]);
            }
            int nbisize = (bi[3] & 0xFF) << 24 | (bi[2] & 0xFF) << 16 | (bi[1] & 0xFF) << 8 | bi[0] & 0xFF;
            if (logger.isDebugEnabled()) {
                logger.debug("Tama\u00f1o de la cabecera: " + nbisize);
            }
            int nwidth = (bi[7] & 0xFF) << 24 | (bi[6] & 0xFF) << 16 | (bi[5] & 0xFF) << 8 | bi[4] & 0xFF;
            int nheight = (bi[11] & 0xFF) << 24 | (bi[10] & 0xFF) << 16 | (bi[9] & 0xFF) << 8 | bi[8] & 0xFF;
            if (logger.isDebugEnabled()) {
                logger.debug("Tama\u00f1o de la imagen: " + nwidth + ", " + nheight);
            }
            int nbitcount = (bi[15] & 0xFF) << 8 | bi[14] & 0xFF;
            int ncompression = bi[19] << 24 | bi[18] << 16 | bi[17] << 8 | bi[16];
            if (logger.isDebugEnabled()) {
                logger.debug("Compresi\u00f3n de imagen: " + ncompression);
            }
            int nsizeimage = (bi[23] & 0xFF) << 24 | (bi[22] & 0xFF) << 16 | (bi[21] & 0xFF) << 8 | bi[20] & 0xFF;
            int nclrused = (bi[35] & 0xFF) << 24 | (bi[34] & 0xFF) << 16 | (bi[33] & 0xFF) << 8 | bi[32] & 0xFF;
            if (logger.isDebugEnabled()) {
                logger.debug("Colores: " + nclrused);
            }
            if (nbitcount == 24) {
                int npad = nsizeimage / nheight - nwidth * 3;
                if (npad == 4) {
                    npad = 0;
                }
                int[] ndata = new int[nheight * nwidth];
                byte[] brgb = new byte[(nwidth + npad) * 3 * nheight];
                fs.read(brgb, 0, (nwidth + npad) * 3 * nheight);
                int nindex = 0;
                int j = 0;
                while (j < nheight) {
                    int i = 0;
                    while (i < nwidth) {
                        ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                        nindex += 3;
                        ++i;
                    }
                    nindex += npad;
                    ++j;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
            } else if (nbitcount == 8) {
                int nNumColors = 0;
                nNumColors = nclrused > 0 ? nclrused : 1 << nbitcount;
                if (logger.isDebugEnabled()) {
                    logger.debug("Colores: " + nNumColors);
                }
                if (nsizeimage == 0) {
                    nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                    nsizeimage *= nheight;
                }
                int[] npalette = new int[nNumColors];
                byte[] bpalette = new byte[nNumColors * 4];
                fs.read(bpalette, 0, nNumColors * 4);
                int nindex8 = 0;
                int n = 0;
                while (n < nNumColors) {
                    npalette[n] = 0xFF000000 | (bpalette[nindex8 + 2] & 0xFF) << 16 | (bpalette[nindex8 + 1] & 0xFF) << 8 | bpalette[nindex8] & 0xFF;
                    nindex8 += 4;
                    ++n;
                }
                int npad8 = nsizeimage / nheight - nwidth;
                int[] ndata8 = new int[nwidth * nheight];
                byte[] bdata = new byte[(nwidth + npad8) * nheight];
                fs.read(bdata, 0, (nwidth + npad8) * nheight);
                nindex8 = 0;
                int j8 = 0;
                while (j8 < nheight) {
                    int i8 = 0;
                    while (i8 < nwidth) {
                        ndata8[nwidth * (nheight - j8 - 1) + i8] = npalette[bdata[nindex8] & 0xFF];
                        ++nindex8;
                        ++i8;
                    }
                    nindex8 += npad8;
                    ++j8;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata8, 0, nwidth));
            } else if (nbitcount == 1) {
                int npad1 = nsizeimage / nheight - nwidth / 8;
                byte[] bdata = new byte[(nwidth + npad1) * nheight];
                fs.read(bdata, 0, 8);
                fs.read(bdata, 0, (nwidth + npad1) * nheight);
                int[] ndata1 = new int[nwidth * nheight];
                int nindex1 = 0;
                int j1 = 0;
                while (j1 < nheight) {
                    int iindex = nindex1;
                    int i1 = 0;
                    while (i1 <= nwidth / 8) {
                        int ib1 = 0;
                        if (i1 * 8 < nwidth) {
                            int b1 = 128;
                            while (b1 > 0) {
                                int n = ndata1[nwidth * (nheight - j1 - 1) + i1 * 8 + ib1] = (b1 & bdata[iindex]) > 0 ? 0xFFFFFF : 0;
                                if (i1 * 8 + ++ib1 >= nwidth) {
                                    b1 = 0;
                                }
                                b1 /= 2;
                            }
                        }
                        ++iindex;
                        ++i1;
                    }
                    nindex1 += nsizeimage / nheight;
                    ++j1;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata1, 0, nwidth));
            } else {
                logger.error("Formato incompatible. No pertenece a un formato v\u00e1lido de 24, 8 o 1 bit.");
                image = null;
            }
            BufferedImage bufferedImage = img = StegoUtils.toBufferedImage(image);
            return bufferedImage;
        }
        catch (Exception e) {
            logger.error("No se pudo convertir la imagen", e);
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception e) {
                logger.debug(e);
            }
        }
        return null;
    }

    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = StegoUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            logger.error("No se pudo recuperar los datos de cabacera de la imagen", e);
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics g = bimage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            logger.error("No se pudo leer los pixels de la imagen", e);
            return false;
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }
}

