/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.symetric;

import es.mityc.crypto.CryptoManager;
import es.mityc.crypto.Utils;
import es.mityc.crypto.symetric.DESCipherManager;
import es.mityc.javasign.utils.Base64Coder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlowFishManager
implements CryptoManager {
    static Log logger = LogFactory.getLog(DESCipherManager.class);
    private byte[] salt = null;
    private int iter = 64;
    private Cipher desCipher = null;
    private SecretKeyFactory skfDes = null;

    public BlowFishManager() {
        this.init(null, 0);
    }

    public BlowFishManager(byte[] salt, int iter) {
        this.init(salt, iter);
    }

    @Override
    public void feedSeed(byte[] seed) {
        if (seed == null) {
            seed = SecureRandom.getSeed(8);
        }
        int i = 0;
        while (i < this.salt.length && i < seed.length) {
            this.salt[i] = (byte)(this.salt[i] & seed[i]);
            ++i;
        }
    }

    private void init(byte[] salt, int iter) {
        this.salt = salt != null ? salt : SecureRandom.getSeed(8);
        if (iter != 0) {
            this.iter = iter;
        }
        if (Security.getProvider("BC") == null) {
            es.mityc.javasign.utils.Utils.addBCProvider();
        }
        try {
            this.desCipher = Cipher.getInstance("Blowfish");
            this.skfDes = SecretKeyFactory.getInstance("Blowfish/CFB64/NoPadding");
        }
        catch (NoSuchPaddingException ex) {
            throw new SecurityException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex);
        }
    }

    public char[] protectPBEandDES(String plain, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (password.length() < 8) {
            logger.warn("La clave debe tener al menos 8 bytes. Se emplea su valor SHA1 como contrase\u00f1a.");
            try {
                MessageDigest hash = MessageDigest.getInstance("SHA1", "BC");
                password = new String(hash.digest(password.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
            catch (NoSuchProviderException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
        }
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(this.salt, this.iter);
            SecretKey pbeKey = this.skfDes.generateSecret(new PBEKeySpec(password.toCharArray()));
            this.desCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] plainProps = plain.getBytes();
            byte[] ciphertext = this.desCipher.doFinal(plainProps);
            return Base64Coder.encode(ciphertext);
        }
        catch (InvalidKeySpecException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException(ex);
        }
    }

    public byte[] recoverPBEandDES(char[] cryptedText, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || cryptedText == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (password.length() < 8) {
            logger.warn("La clave debe tener al menos 8 bytes. Se emplea su valor SHA1 como contrase\u00f1a.");
            try {
                MessageDigest hash = MessageDigest.getInstance("SHA1", "BC");
                password = new String(hash.digest(password.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
            catch (NoSuchProviderException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
        }
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(this.salt, this.iter);
            SecretKey pbeKey = this.skfDes.generateSecret(new PBEKeySpec(password.toCharArray()));
            this.desCipher.init(2, (Key)pbeKey, pbeParamSpec);
            byte[] ciphertext = this.desCipher.doFinal(Base64Coder.decode(cryptedText));
            return ciphertext;
        }
        catch (InvalidKeySpecException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException("Contrase\u00f1a incorrecta", ex);
        }
    }

    @Override
    public String getUsedAlgorithmURI() {
        return this.desCipher.getAlgorithm();
    }

    public static void main(String[] args) {
        String plain = "TextoEnClaro012456789";
        String pass = "1234567890123456789012345678901234567890";
        DESCipherManager p = new DESCipherManager();
        System.out.println("Texto en claro: " + plain);
        String buffer = Utils.obfuscate(plain);
        System.out.println("Texto ofuscado: " + buffer);
        buffer = Utils.undoObfuscate(buffer.getBytes());
        System.out.println("Texto recuperado: " + buffer);
        char[] bufferChar = p.protectPBEandDES(buffer, pass);
        buffer = new String(bufferChar);
        System.out.println("Texto encriptado PBEandDES: " + buffer);
        buffer = new String(p.recoverPBEandDES(bufferChar, pass));
        System.out.println("Texto desencriptado PBEandDES: " + buffer);
        Long start = System.currentTimeMillis();
        buffer = Utils.obfuscate(new String(p.protectPBEandDES(buffer, pass)));
        System.out.println("Encriptado PBEandDES y ofuscado: " + buffer);
        buffer = new String(p.recoverPBEandDES(Utils.undoObfuscate(buffer.getBytes()).toCharArray(), pass));
        Long time = System.currentTimeMillis() - start;
        System.out.println("Texto recuperado: " + buffer + "\nTiempo consumido (ms): " + time);
    }
}

