/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import adsi.org.apache.xml.security.Init;
import adsi.org.apache.xml.security.algorithms.JCEMapper;
import adsi.org.apache.xml.security.signature.ObjectContainer;
import adsi.org.apache.xml.security.signature.XMLSignature;
import adsi.org.apache.xml.security.transforms.Transforms;
import adsi.org.apache.xml.security.utils.IgnoreAllErrorHandler;
import adsi.org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import es.mityc.firmaJava.libreria.errores.ClienteChainNotFoundError;
import es.mityc.firmaJava.libreria.errores.ClienteError;
import es.mityc.firmaJava.libreria.excepciones.AddXadesException;
import es.mityc.firmaJava.libreria.utilidades.Base64;
import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadCertificados;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFechas;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFicheros;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFirmaElectronica;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.DataToSign;
import es.mityc.firmaJava.libreria.xades.NombreElementos;
import es.mityc.firmaJava.libreria.xades.RespYCerts;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.UtilidadXadesX;
import es.mityc.firmaJava.libreria.xades.ValidarFirmaXML;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLRef;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLRefs;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLValues;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CertificateValues;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DataObjectFormat;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedX509Certificate;
import es.mityc.firmaJava.libreria.xades.elementos.xades.ObjectIdentifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignatureProductionPlace;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigningTime;
import es.mityc.firmaJava.libreria.xades.errores.BadFormedSignatureException;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.firmaJava.role.IClaimedRole;
import es.mityc.javasign.EnumFormatoFirma;
import es.mityc.javasign.asn1.ASN1Utils;
import es.mityc.javasign.certificate.CertStatusException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.certificate.IX509CRLCertStatus;
import es.mityc.javasign.certificate.ocsp.OCSPLiveConsultant;
import es.mityc.javasign.exception.SignMITyCException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustFactory;
import es.mityc.javasign.ts.HTTPTimeStampGenerator;
import es.mityc.javasign.tsa.ITimeStampGenerator;
import es.mityc.javasign.tsa.TimeStampException;
import es.mityc.javasign.utils.Utils;
import es.mityc.javasign.xml.refs.AbstractObjectToSign;
import es.mityc.javasign.xml.refs.InternObjectToSign;
import es.mityc.javasign.xml.refs.ObjectToSign;
import es.mityc.javasign.xml.refs.SignObjectToSign;
import es.mityc.javasign.xml.resolvers.IPrivateData;
import es.mityc.javasign.xml.resolvers.IResourceData;
import es.mityc.javasign.xml.resolvers.MITyCResourceResolver;
import es.mityc.javasign.xml.resolvers.ResolverPrivateData;
import es.mityc.javasign.xml.resolvers.XAdESResourceResolverSpi;
import es.mityc.javasign.xml.transform.Transform;
import es.mityc.javasign.xml.transform.TransformEnveloped;
import es.mityc.javasign.xml.xades.IStoreElements;
import es.mityc.javasign.xml.xades.LocalFileStoreElements;
import es.mityc.javasign.xml.xades.policy.IFirmaPolicy;
import es.mityc.javasign.xml.xades.policy.PoliciesManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FirmaXML {
    private static Log log = LogFactory.getLog(FirmaXML.class);
    private static II18nManager i18n = I18nFactory.getI18nManager("MITyCLibXAdES");
    private static final boolean ADD_VALIDATION_OCSP = true;
    String profileDirectory = "";
    private String xadesNS = "etsi";
    private String xadesSchema = null;
    private String xmldsigNS = "ds";
    private ArrayList<String> idNodoSelloTiempo = new ArrayList();
    private String idNodoCertificateRefs = null;
    private String idNodoRevocationRefs = null;
    private String idSigProperties = null;
    private String idSignatureValue = null;
    private ArrayList<ResourceResolverSpi> resolvers;

    public void setDefaultNSXmlSig(String namespace) {
        this.xmldsigNS = namespace;
    }

    public void setLocale(String locale) {
        I18n.setLocale(locale, locale.toUpperCase());
    }

    public void addResolver(IPrivateData resolver) {
        this.addResolver(new ResolverPrivateData(resolver));
    }

    public void addResolver(MITyCResourceResolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new ArrayList();
        }
        this.resolvers.add(resolver);
    }

    public void addResolver(IResourceData resolver) {
        this.addResolver(new XAdESResourceResolverSpi(resolver));
    }

    public String sign2Stream(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, OutputStream salida) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        return this.signFile(firmaCertificado, xml, pk, salida, storeManager.getProvider(firmaCertificado));
    }

    public boolean signFile(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, String destino, String nombreArchivo) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        return this.signFile(firmaCertificado, xml, pk, destino, nombreArchivo, storeManager.getProvider(firmaCertificado));
    }

    private String signFile(X509Certificate certificadoFirma, DataToSign xml, PrivateKey pk, OutputStream salida, Provider provider) throws Exception {
        Object[] res = this.signFile(certificadoFirma, xml, pk, provider);
        if (res[1] != null) {
            throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error43"));
        }
        try {
            UtilidadFicheros.writeXML((Document)res[0], salida);
            return (String)res[2];
        }
        catch (Throwable t) {
            if (t.getMessage() != null && t.getMessage().startsWith("Java heap space")) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
            }
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
        }
    }

    private boolean signFile(X509Certificate certificadoFirma, DataToSign xml, PrivateKey pk, String destino, String nombreArchivo, Provider provider) throws Exception {
        if (destino == null || nombreArchivo == null) {
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error31"));
        }
        Object[] res = this.signFile(certificadoFirma, xml, pk, provider);
        Document doc = (Document)res[0];
        File fichero = new File(destino, nombreArchivo);
        FileOutputStream f = new FileOutputStream(fichero);
        try {
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)f, "UTF-8");
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.setProperty("method", "XML");
                props.setProperty("encoding", "UTF-8");
                props.setProperty("omit-xml-declaration", "no");
                xformer.setOutputProperties(props);
                StringWriter salida = new StringWriter();
                xformer.transform(new DOMSource(doc), new StreamResult(salida));
                out.write(salida.toString());
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Throwable t) {
                if (t.getMessage() != null && t.getMessage().startsWith("Java heap space")) {
                    throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
                }
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
            }
        }
        finally {
            f.flush();
            f.close();
        }
        return true;
    }

    public Object[] signFile(X509Certificate certificadoFirma, DataToSign dataToSign, PrivateKey pk, Provider provider) throws Exception {
        boolean xadesC;
        boolean xadesT;
        XAdESSchemas schema;
        EnumFormatoFirma tipoFirma;
        XMLSignature firma;
        Document doc;
        ArrayList<RespYCerts> respuestas;
        block106: {
            boolean xadesActivo;
            String algDigestXML;
            XAdESSchemas esquemaTemp;
            respuestas = new ArrayList<RespYCerts>();
            ArrayList<X509Certificate> certificadosConOCSP = new ArrayList<X509Certificate>();
            Init.init();
            doc = dataToSign.getDocument();
            if (doc == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                db.setErrorHandler(new IgnoreAllErrorHandler());
                try {
                    InputStream is = dataToSign.getInputStream();
                    if (is != null) {
                        InputSource isour = new InputSource(is);
                        String encoding = dataToSign.getXMLEncoding();
                        isour.setEncoding(encoding);
                        doc = db.parse(isour);
                    } else {
                        doc = db.newDocument();
                    }
                }
                catch (IOException ex) {
                    throw new Exception(I18n.getResource("libreriaxades.firmaxml.error50"), ex);
                }
            }
            this.xadesSchema = (esquemaTemp = dataToSign.getEsquema()) != null ? esquemaTemp.getSchemaUri() : XAdESSchemas.XAdES_132.getSchemaUri();
            String string = algDigestXML = dataToSign.getAlgDigestXmlDSig() != null ? dataToSign.getAlgDigestXmlDSig() : "http://www.w3.org/2000/09/xmldsig#sha1";
            if (JCEMapper.translateURItoJCEID(algDigestXML) == null) {
                throw new SignMITyCException(i18n.getLocalMessage("i18n.mityc.xades.sign.1", algDigestXML));
            }
            XMLSignature.setDefaultPrefix("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS);
            firma = new XMLSignature(doc, dataToSign.getBaseURI(), "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            firma.setId(UtilidadTratarNodo.newID(doc, "Signature"));
            firma.getSignedInfo().setId(UtilidadTratarNodo.newID(doc, "Signature-SignedInfo"));
            if (this.resolvers != null) {
                Iterator<ResourceResolverSpi> it = this.resolvers.iterator();
                while (it.hasNext()) {
                    firma.addResourceResolver(it.next());
                }
            }
            firma.setXPathNamespaceContext(this.xmldsigNS, "http://www.w3.org/2000/09/xmldsig#");
            tipoFirma = dataToSign.getXadesFormat();
            boolean bl = xadesActivo = tipoFirma.compareTo(EnumFormatoFirma.XAdES_BES) >= 0;
            if (xadesActivo) {
                firma.setXPathNamespaceContext(this.xadesNS, this.xadesSchema);
            }
            Element elementoPrincipal = null;
            if (!dataToSign.isEnveloped()) {
                doc.appendChild(firma.getElement());
            } else {
                String nodoRaizXml = dataToSign.getParentSignNode();
                if (nodoRaizXml == null) {
                    elementoPrincipal = doc.getDocumentElement();
                } else {
                    NodeList nodos = doc.getElementsByTagName(nodoRaizXml);
                    if (nodos.getLength() != 0) {
                        elementoPrincipal = (Element)nodos.item(0);
                    } else {
                        Element nodo = UtilidadTratarNodo.getElementById(doc, nodoRaizXml);
                        if (nodo != null) {
                            elementoPrincipal = nodo;
                        } else {
                            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error2"));
                        }
                    }
                }
                elementoPrincipal.appendChild(firma.getElement());
            }
            this.idSigProperties = UtilidadTratarNodo.newID(doc, "-SignedProperties");
            if (xadesActivo) {
                String tipoEsquema = UtilidadFirmaElectronica.obtenerTipoReference(this.xadesSchema);
                firma.addDocument("#" + firma.getId() + this.idSigProperties, null, algDigestXML, UtilidadTratarNodo.newID(doc, "SignedPropertiesID"), tipoEsquema);
            }
            firma.addKeyInfo(certificadoFirma);
            firma.addKeyInfo(certificadoFirma.getPublicKey());
            String idCert = UtilidadTratarNodo.newID(doc, "Certificate1");
            firma.getKeyInfo().setId(idCert);
            firma.addDocument("#" + idCert, null, algDigestXML, null, null);
            ArrayList<ObjectToSign> objects = dataToSign.getObjects();
            if (objects != null) {
                for (ObjectToSign obj : objects) {
                    MITyCResourceResolver resolver;
                    AbstractObjectToSign objToSign = obj.getObjectToSign();
                    String refId = UtilidadTratarNodo.newID(doc, "Reference-ID-");
                    List<ObjectContainer> containers = objToSign.getObjects(doc);
                    if (containers != null) {
                        for (ObjectContainer objectContainer : containers) {
                            firma.appendObject(objectContainer);
                        }
                    }
                    String objId = objToSign.getReferenceURI();
                    Transforms trans = null;
                    List<Transform> list = objToSign.getTransforms();
                    if (dataToSign.isEnveloped() && objId != null) {
                        Element aFirmar = UtilidadTratarNodo.getElementById(doc, objId);
                        if (UtilidadTratarNodo.isChildNode(firma.getElement(), aFirmar)) {
                            list.add(new TransformEnveloped());
                        }
                    }
                    if (list.size() > 0) {
                        trans = new Transforms(doc);
                        for (Transform transform : list) {
                            trans.addTransform(transform.getAlgorithm(), transform.getExtraData(doc));
                        }
                    }
                    if ((resolver = objToSign.getResolver()) != null) {
                        firma.addResourceResolver(resolver);
                    }
                    String typeInfo = objToSign.getType();
                    firma.addDocument(objId, trans, algDigestXML, refId, typeInfo);
                    obj.setId("#" + refId);
                }
            }
            schema = null;
            if (xadesActivo) {
                schema = XAdESSchemas.getXAdESSchema(this.xadesSchema);
                if (schema == null) {
                    log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error44")) + " " + this.xadesSchema);
                    throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error45"));
                }
                this.addXades(doc, firma.getId(), certificadoFirma, firma.getElement(), schema, dataToSign, algDigestXML);
                if (dataToSign.hasPolicy()) {
                    this.addXadesEPES(firma.getElement(), dataToSign.getPolicyKey());
                } else if (XAdESSchemas.XAdES_111.equals(schema)) {
                    this.addXadesEPES(firma.getElement(), "implied");
                }
            }
            try {
                try {
                    if (provider != null && Security.getProvider(provider.getName()) == null) {
                        JCEMapper.setProviderSignatureThread(provider);
                    }
                    firma.sign(pk);
                }
                catch (Exception ex) {
                    log.error(I18n.getResource("libreriaxades.firmaxml.error4"), ex);
                    throw ex;
                }
            }
            finally {
                JCEMapper.removeProviderSignatureThread();
            }
            Element elementoValorFirma = null;
            NodeList nodoValorFirma = firma.getElement().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            if (nodoValorFirma.getLength() == 0) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error5"));
            }
            elementoValorFirma = (Element)nodoValorFirma.item(0);
            Attr idValorFirma = doc.createAttributeNS(null, "Id");
            this.idSignatureValue = UtilidadTratarNodo.newID(doc, "SignatureValue");
            idValorFirma.setValue(this.idSignatureValue);
            NamedNodeMap elementoIdAtributosValorFirma = elementoValorFirma.getAttributes();
            elementoIdAtributosValorFirma.setNamedItem(idValorFirma);
            xadesT = tipoFirma.compareTo(EnumFormatoFirma.XAdES_T) >= 0;
            log.debug(String.valueOf(I18n.getResource("libreriaxades.firmaxml.debug1")) + xadesT);
            byte[] selloTiempo = null;
            if (xadesT) {
                try {
                    ITimeStampGenerator timeStampGenerator = dataToSign.getTimeStampGenerator();
                    if (timeStampGenerator == null) {
                        throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error6"));
                    }
                    byte[] byteSignature = UtilidadTratarNodo.obtenerByteNodo(firma.getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue", CanonicalizationEnum.C14N_OMIT_COMMENTS, 5);
                    selloTiempo = timeStampGenerator.generateTimeStamp(byteSignature);
                    this.addXadesT(firma.getElement(), firma.getId(), selloTiempo);
                }
                catch (AddXadesException e) {
                    throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error7")) + e.getMessage());
                }
            }
            xadesC = tipoFirma.compareTo(EnumFormatoFirma.XAdES_C) >= 0;
            log.debug(String.valueOf(I18n.getResource("libreriaxades.firmaxml.debug2")) + xadesC);
            if (xadesC) {
                try {
                    if (xadesT) {
                        block105: {
                            if (dataToSign.getCertStatusManager() == null) {
                                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error53"));
                            }
                            log.info(i18n.getLocalMessage("i18n.mityc.xades.validate.18"));
                            this.convertICertStatus2RespYCerts(dataToSign.getCertStatusManager().getCertChainStatus(certificadoFirma), certificadosConOCSP, respuestas);
                            if (log.isDebugEnabled()) {
                                log.debug("Se incluyen las referencias OCSP de la propia VA");
                            }
                            X509Certificate ocspCert = null;
                            try {
                                X509Certificate[] ocspCerts;
                                IOCSPCertStatus respOcsp = (IOCSPCertStatus)respuestas.get(0).getCertstatus();
                                OCSPResp resp = new OCSPResp(respOcsp.getEncoded());
                                BasicOCSPResp respuestaBasica = (BasicOCSPResp)resp.getResponseObject();
                                if (log.isDebugEnabled()) {
                                    ResponderID respID = respuestaBasica.getResponderId().toASN1Object();
                                    log.debug("Extracci\u00f3n del certificado OCSP: " + ASN1Utils.getResponderID(respID).toString());
                                }
                                if ((ocspCerts = respuestaBasica.getCerts("SUN")) != null && ocspCerts.length > 0) {
                                    CertPath cpOcsp;
                                    if (log.isDebugEnabled()) {
                                        log.debug("Se regenera la cadena y se lanza la validaci\u00f3n");
                                    }
                                    if (!(ocspCert = (X509Certificate)(cpOcsp = UtilidadCertificados.orderCertPath(Arrays.asList(ocspCerts))).getCertificates().get(0)).getIssuerX500Principal().equals(certificadoFirma.getIssuerX500Principal())) {
                                        List<ICertStatus> re = dataToSign.getCertStatusManager().getCertChainStatus(ocspCert);
                                        this.convertICertStatus2RespYCerts(re, certificadosConOCSP, respuestas);
                                    } else {
                                        ICertStatus respOCSP = dataToSign.getCertStatusManager().getCertStatus(ocspCert);
                                        ArrayList<ICertStatus> re = new ArrayList<ICertStatus>(1);
                                        re.add(respOCSP);
                                        this.convertICertStatus2RespYCerts(re, certificadosConOCSP, respuestas);
                                    }
                                } else {
                                    log.error("No se pudo recuperar el certificado de la VA");
                                }
                            }
                            catch (Exception e1) {
                                log.error(e1);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Se incluyen las referencias OCSP del sello de tiempo");
                            }
                            TimeStampToken tst = null;
                            try {
                                tst = new TimeStampToken(new CMSSignedData(selloTiempo));
                            }
                            catch (CMSException e) {
                                try {
                                    TimeStampResponse tsr = new TimeStampResponse(selloTiempo);
                                    tst = tsr.getTimeStampToken();
                                }
                                catch (Exception ex) {
                                    log.error(ex);
                                }
                            }
                            catch (Exception e) {
                                log.error(e);
                            }
                            X509Certificate certTSA = null;
                            try {
                                CertStore cs = tst.getCertificatesAndCRLs("Collection", null);
                                Collection<? extends Certificate> certs = cs.getCertificates(null);
                                if (certs != null && certs.size() > 0) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Se regenera la cadena de certificados firmante del sello de tiempo y se lanza su validaci\u00f3n");
                                    }
                                    try {
                                        Collection<? extends Certificate> iterableCerts = null;
                                        if (!(certs instanceof Iterable)) {
                                            throw new Exception("El certificado no es del tipo esperado: " + certs.getClass());
                                        }
                                        iterableCerts = certs;
                                        CertPath cpTsa = UtilidadCertificados.orderCertPath(iterableCerts);
                                        certTSA = (X509Certificate)cpTsa.getCertificates().get(0);
                                    }
                                    catch (Exception e) {
                                        Certificate cert = certs.iterator().next();
                                        if (cert instanceof X509Certificate) {
                                            certTSA = (X509Certificate)cert;
                                        }
                                    }
                                } else {
                                    log.error("No se pudo recuperar el certificado del sello de tiempo");
                                }
                            }
                            catch (Exception e) {
                                log.error(e);
                            }
                            if (certTSA != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Certificado de TSA obtenido " + certTSA.getSubjectX500Principal());
                                }
                                ArrayList<RespYCerts> respuestasTSA = new ArrayList<RespYCerts>();
                                if (certTSA.getIssuerX500Principal().equals(certificadoFirma.getIssuerX500Principal()) || ocspCert != null && certTSA.getIssuerX500Principal().equals(ocspCert.getIssuerX500Principal())) {
                                    ICertStatus respTSA = dataToSign.getCertStatusManager().getCertStatus(certTSA);
                                    ArrayList<ICertStatus> re = new ArrayList<ICertStatus>(1);
                                    re.add(respTSA);
                                    this.convertICertStatus2RespYCerts(re, certificadosConOCSP, respuestasTSA);
                                } else {
                                    this.convertICertStatus2RespYCerts(dataToSign.getCertStatusManager().getCertChainStatus(certTSA), certificadosConOCSP, respuestasTSA);
                                }
                                respuestas.addAll(respuestasTSA);
                                if (log.isDebugEnabled()) {
                                    log.debug("TSA Validada. Se valida la VA del propio sello");
                                }
                                try {
                                    X509Certificate[] ocspTsaCerts;
                                    IOCSPCertStatus respOcspTsa = (IOCSPCertStatus)respuestasTSA.get(0).getCertstatus();
                                    OCSPResp resp = new OCSPResp(respOcspTsa.getEncoded());
                                    BasicOCSPResp respuestaBasica = (BasicOCSPResp)resp.getResponseObject();
                                    if (log.isDebugEnabled()) {
                                        ResponderID respID = respuestaBasica.getResponderId().toASN1Object();
                                        log.debug("Extracci\u00f3n del certificado OCSP para el sello de tiempo: " + ASN1Utils.getResponderID(respID).toString());
                                    }
                                    if ((ocspTsaCerts = respuestaBasica.getCerts("SUN")) != null && ocspTsaCerts.length > 0) {
                                        X509Certificate tsaOCSPCert;
                                        block104: {
                                            tsaOCSPCert = null;
                                            CertPath cpTsa = UtilidadCertificados.orderCertPath(Arrays.asList(ocspTsaCerts));
                                            try {
                                                tsaOCSPCert = (X509Certificate)cpTsa.getCertificates().get(0);
                                            }
                                            catch (Exception e) {
                                                Certificate cert = cpTsa.getCertificates().get(0);
                                                if (!(cert instanceof X509Certificate)) break block104;
                                                tsaOCSPCert = (X509Certificate)cert;
                                            }
                                        }
                                        if (log.isDebugEnabled()) {
                                            log.debug("Certificado VA del sello de tiempo obtenido: " + tsaOCSPCert.getSubjectX500Principal());
                                        }
                                        if (tsaOCSPCert.getIssuerX500Principal().equals(certificadoFirma.getIssuerX500Principal()) || ocspCert != null && tsaOCSPCert.getIssuerX500Principal().equals(ocspCert.getIssuerX500Principal()) || certTSA != null && tsaOCSPCert.getIssuerX500Principal().equals(certTSA.getIssuerX500Principal())) {
                                            ICertStatus respOCSP = dataToSign.getCertStatusManager().getCertStatus(tsaOCSPCert);
                                            ArrayList<ICertStatus> re = new ArrayList<ICertStatus>(1);
                                            re.add(respOCSP);
                                            this.convertICertStatus2RespYCerts(re, certificadosConOCSP, respuestas);
                                        } else {
                                            this.convertICertStatus2RespYCerts(dataToSign.getCertStatusManager().getCertChainStatus(tsaOCSPCert), certificadosConOCSP, respuestas);
                                        }
                                        break block105;
                                    }
                                    log.error("No se pudo recuperar el certificado de la VA del sello de tiempo");
                                }
                                catch (Exception e1) {
                                    log.error(e1);
                                }
                            }
                        }
                        this.addXadesC(firma.getElement(), respuestas, schema, algDigestXML);
                        break block106;
                    }
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error24"));
                }
                catch (CertStatusException e) {
                    throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error56")) + "\n" + e.getMessage());
                }
                catch (AddXadesException e) {
                    throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error10")) + ":" + "\n" + e.getMessage());
                }
            }
        }
        boolean xadesX = tipoFirma.compareTo(EnumFormatoFirma.XAdES_X) >= 0;
        log.debug(String.valueOf(I18n.getResource("libreriaxades.firmaxml.debug3")) + xadesX);
        boolean xadesXL = tipoFirma.compareTo(EnumFormatoFirma.XAdES_XL) == 0;
        log.debug(String.valueOf(I18n.getResource("libreriaxades.firmaxml.debug4")) + xadesXL);
        if (xadesC && !xadesXL) {
            try {
                doc = this.addURIXadesC(firma.getElement(), this.saveOCSPFiles(respuestas, dataToSign.getElementsStorer()), dataToSign.getBaseURI());
            }
            catch (FirmaXMLError ex) {
                throw new ClienteError("Error al guardar ficheros de estados de certificados", ex);
            }
        }
        if (xadesX) {
            if (xadesT && xadesC) {
                Element signatureElement = firma.getElement();
                if (!new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Signature").equals(new NombreNodo(signatureElement.getNamespaceURI(), signatureElement.getLocalName()))) {
                    throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + "Signature");
                }
                Element unsignedSignaturePropertiesElement = null;
                NodeList unsignedSignaturePropertiesNodes = signatureElement.getElementsByTagNameNS(this.xadesSchema, "UnsignedSignatureProperties");
                if (unsignedSignaturePropertiesNodes.getLength() != 1) {
                    log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "UnsignedSignatureProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + unsignedSignaturePropertiesNodes.getLength());
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error41"));
                }
                unsignedSignaturePropertiesElement = (Element)unsignedSignaturePropertiesNodes.item(0);
                switch (dataToSign.getXAdESXType()) {
                    case TYPE_2: {
                        this.addXadesX2(unsignedSignaturePropertiesElement, dataToSign.getTimeStampGenerator());
                        break;
                    }
                    default: {
                        this.addXadesX(unsignedSignaturePropertiesElement, dataToSign.getTimeStampGenerator());
                        break;
                    }
                }
            } else {
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error25"));
            }
        }
        if (xadesXL) {
            if (xadesT && xadesC && xadesX) {
                try {
                    this.addXadesXL(firma.getElement(), respuestas, schema);
                }
                catch (Exception e) {
                    throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error12")) + e.getMessage(), e);
                }
            } else {
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error13"));
            }
        }
        Object[] res = new Object[]{doc, xadesC && !xadesXL ? respuestas : null, this.idSignatureValue};
        return res;
    }

    private void convertICertStatus2RespYCerts(List<ICertStatus> status, ArrayList<X509Certificate> certificadosConOCSP, ArrayList<RespYCerts> resps) {
        if (status != null) {
            Iterator<ICertStatus> itStatus = status.iterator();
            while (itStatus.hasNext()) {
                RespYCerts resp = new RespYCerts();
                resp.setCertstatus(itStatus.next());
                if (certificadosConOCSP.contains(resp.getCertstatus().getCertificate())) continue;
                certificadosConOCSP.add(resp.getCertstatus().getCertificate());
                resps.add(resp);
            }
        }
    }

    private Document addXades(Document doc, String firmaID, X509Certificate firmaCertificado, Element elementoPrincipalFirma, XAdESSchemas schemaXades, DataToSign dataToSign, String algDigestXML) throws AddXadesException {
        ArrayList<ObjectToSign> objects;
        Iterator<Object> it;
        Element elementoObjeto = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "Object");
        elementoObjeto.setAttributeNS(null, "Id", UtilidadTratarNodo.newID(doc, String.valueOf(firmaID) + "-Object"));
        elementoPrincipalFirma.appendChild(elementoObjeto);
        Element elemntQualifyingProperties = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "QualifyingProperties");
        elementoObjeto.appendChild(elemntQualifyingProperties);
        elemntQualifyingProperties.setAttributeNS(null, "Target", "#" + firmaID);
        Element propiedadesFirmadasElemento = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "SignedProperties");
        elemntQualifyingProperties.appendChild(propiedadesFirmadasElemento);
        propiedadesFirmadasElemento.setAttributeNS(null, "Id", String.valueOf(firmaID) + this.idSigProperties);
        Element propiedadesFirmadasElementoFirma = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "SignedSignatureProperties");
        propiedadesFirmadasElemento.appendChild(propiedadesFirmadasElementoFirma);
        Date signingDate = dataToSign.getSignDate();
        if (signingDate == null && schemaXades.equals(XAdESSchemas.XAdES_111)) {
            throw new AddXadesException("SigningTime es requerido");
        }
        if (signingDate != null) {
            SigningTime tiempoFirma = new SigningTime(schemaXades, signingDate);
            Element tiempoFirmaElemento = null;
            try {
                tiempoFirmaElemento = tiempoFirma.createElement(doc, this.xadesNS);
            }
            catch (InvalidInfoNodeException e) {
                throw new AddXadesException(e.getMessage(), e);
            }
            propiedadesFirmadasElementoFirma.appendChild(tiempoFirmaElemento);
        }
        Element certificadoFirmaElemento = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "SigningCertificate");
        propiedadesFirmadasElementoFirma.appendChild(certificadoFirmaElemento);
        Element certificadoElemento = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "Cert");
        File signCertFile = dataToSign.getSigningCert();
        if (signCertFile != null) {
            String uri = UtilidadFicheros.relativizeRute(dataToSign.getBaseURI(), signCertFile);
            certificadoElemento.setAttributeNS(null, "URI", uri);
        }
        Element resumenCertificadoElemento = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "CertDigest");
        Element metodoResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "DigestMethod");
        metodoResumenElemento.setAttributeNS(null, "Algorithm", algDigestXML);
        String resumenCertificado = "";
        try {
            MessageDigest resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest(algDigestXML);
            if (resumenCertificadoTemp == null) {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error16"));
            }
            byte[] byteMessageDigest = resumenCertificadoTemp.digest(firmaCertificado.getEncoded());
            resumenCertificado = new String(Base64Coder.encode(byteMessageDigest));
        }
        catch (CertificateEncodingException cee) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error17"));
        }
        Element elementDigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "DigestValue");
        elementDigestValue.appendChild(doc.createTextNode(resumenCertificado));
        Element elementoEmisorSerial = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "IssuerSerial");
        Element elementoX509EmisorNombre = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "X509IssuerName");
        String issuerName = null;
        try {
            issuerName = firmaCertificado.getIssuerX500Principal().getName();
            if (log.isTraceEnabled()) {
                log.trace("Certificado emisor obtenido del X500: " + issuerName);
            }
            Charset charsetUtf = Charset.forName("UTF-8");
            issuerName = charsetUtf.decode(ByteBuffer.wrap(issuerName.getBytes())).toString();
            if (log.isTraceEnabled()) {
                log.trace("Emisor decodificado en UTF8:" + issuerName);
            }
        }
        catch (Exception e1) {
            if (log.isDebugEnabled()) {
                log.error("Error al codificar el emisor en UTF-8. Se toma su valor con el charset original.", e1);
            }
            issuerName = firmaCertificado.getIssuerDN().getName();
        }
        if (log.isTraceEnabled()) {
            log.debug("Certificado emisor: " + issuerName);
            Charset charset = null;
            Iterator<Map.Entry<String, Charset>> charsets = Charset.availableCharsets().entrySet().iterator();
            log.debug("Charsets disponibles encontrados: " + Charset.availableCharsets().size());
            while (charsets.hasNext()) {
                charset = charsets.next().getValue();
                byte[] data1 = null;
                byte[] data2 = null;
                try {
                    data1 = issuerName.getBytes(charset);
                    data2 = firmaCertificado.getIssuerX500Principal().getName().getBytes(charset);
                }
                catch (Exception e) {
                    log.error("No se puede codificar la cadena en " + charset.displayName(), e);
                    continue;
                }
                if (data1.length == data2.length) {
                    int i = 0;
                    while (i < data1.length) {
                        if (data1[i] != data2[i]) {
                            log.debug("El nombre del Issuer le\u00eddo y el X500 original no coinciden en formato " + charset.displayName() + ": " + data1[i] + " - " + data2[i]);
                        }
                        ++i;
                    }
                    continue;
                }
                log.debug("No coincide el tama\u00f1o en " + charset);
            }
        }
        elementoX509EmisorNombre.appendChild(doc.createTextNode(issuerName));
        Element elementoX509NumeroSerial = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "X509SerialNumber");
        elementoX509NumeroSerial.appendChild(doc.createTextNode(firmaCertificado.getSerialNumber().toString()));
        String[] produc = dataToSign.getProductionPlace();
        if (produc != null) {
            SignatureProductionPlace spp = new SignatureProductionPlace(schemaXades, produc[0], produc[1], produc[2], produc[3]);
            Element productionPlaceElemento = null;
            try {
                productionPlaceElemento = spp.createElement(doc, this.xadesNS);
            }
            catch (InvalidInfoNodeException e) {
                throw new AddXadesException(e.getMessage(), e);
            }
            propiedadesFirmadasElementoFirma.appendChild(productionPlaceElemento);
        }
        resumenCertificadoElemento.appendChild(metodoResumenElemento);
        resumenCertificadoElemento.appendChild(elementDigestValue);
        certificadoElemento.appendChild(resumenCertificadoElemento);
        elementoEmisorSerial.appendChild(elementoX509EmisorNombre);
        elementoEmisorSerial.appendChild(elementoX509NumeroSerial);
        certificadoElemento.appendChild(elementoEmisorSerial);
        certificadoFirmaElemento.appendChild(certificadoElemento);
        ArrayList<IClaimedRole> rolesFirmante = dataToSign.getClaimedRoles();
        if (rolesFirmante != null) {
            Element elementoRoleFirmanteElemento = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "SignerRole");
            propiedadesFirmadasElementoFirma.appendChild(elementoRoleFirmanteElemento);
            Element elementoRolesDemandadosElementos = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "ClaimedRoles");
            elementoRoleFirmanteElemento.appendChild(elementoRolesDemandadosElementos);
            it = rolesFirmante.iterator();
            while (it.hasNext()) {
                Element elementClaimedRoleElement = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "ClaimedRole");
                elementClaimedRoleElement.appendChild(((IClaimedRole)it.next()).createClaimedRoleContent(doc));
                elementoRolesDemandadosElementos.appendChild(elementClaimedRoleElement);
            }
        }
        if ((objects = dataToSign.getObjects()) != null && objects.size() > 0) {
            Element signedDataObjectProperties = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "SignedDataObjectProperties");
            it = objects.iterator();
            DataObjectFormat dof = null;
            ObjectIdentifier oi = null;
            ObjectToSign obj = null;
            String id = null;
            String desc = null;
            String tipoMIME = null;
            URI encoding = null;
            URI referenceId = null;
            while (it.hasNext()) {
                obj = (ObjectToSign)it.next();
                if (obj != null) {
                    id = obj.getId();
                    desc = obj.getDescription();
                    tipoMIME = obj.getMimeType();
                    encoding = obj.getEncoding();
                    oi = obj.getObjectIdentifier();
                }
                if (desc == null && tipoMIME == null && oi == null) continue;
                try {
                    desc = new String(desc.getBytes(), "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    if (log.isDebugEnabled()) {
                        log.debug(e1);
                    }
                    try {
                        desc = URLEncoder.encode(desc, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(e.getMessage(), e);
                        desc = "Unknown";
                    }
                }
                if (id != null) {
                    try {
                        referenceId = new URI(id);
                    }
                    catch (URISyntaxException e) {
                        log.error(e.getMessage(), e);
                    }
                }
                if (referenceId == null || schemaXades == null) {
                    log.error("No se puede incluir el objeto DataObjectFormat porque faltan datos");
                    throw new AddXadesException(i18n.getLocalMessage("i18n.mityc.xades.sign.2"));
                }
                dof = new DataObjectFormat(schemaXades, referenceId, desc, tipoMIME);
                if (encoding != null) {
                    dof.setEncoding(encoding);
                }
                if (oi != null) {
                    dof.setObjectIdentifier(oi);
                }
                try {
                    signedDataObjectProperties.appendChild(dof.createElement(doc, this.xadesNS));
                }
                catch (DOMException e) {
                    throw new AddXadesException(e.getMessage(), e);
                }
                catch (InvalidInfoNodeException e) {
                    log.error(e.getMessage(), e);
                    throw new AddXadesException(i18n.getLocalMessage("i18n.mityc.xades.sign.2"));
                }
            }
            if (signedDataObjectProperties.getChildNodes().getLength() > 0) {
                propiedadesFirmadasElemento.appendChild(signedDataObjectProperties);
            }
        }
        return null;
    }

    private void addXadesEPES(Element elementoPrincipalFirma, String confPolicyManager) throws AddXadesException {
        IFirmaPolicy policyManager;
        if (confPolicyManager == null) {
            confPolicyManager = "implied";
        }
        if ((policyManager = PoliciesManager.getInstance().getEscritorPolicy(confPolicyManager)) == null) {
            log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error46")) + " " + confPolicyManager);
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error47"));
        }
        XAdESSchemas schema = XAdESSchemas.getXAdESSchema(this.xadesSchema);
        if (schema == null) {
            log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error44")) + " " + this.xadesSchema);
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error45"));
        }
        try {
            policyManager.writePolicyNode(elementoPrincipalFirma, this.xmldsigNS, this.xadesNS, schema);
        }
        catch (PolicyException ex) {
            log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error48")) + " " + ex.getMessage(), ex);
            throw new AddXadesException(ex.getMessage(), ex);
        }
    }

    private Document addXadesT(Element firma, String firmaID, byte[] selloTiempo) throws AddXadesException {
        Document doc = firma.getOwnerDocument();
        Element elementoPrincipal = null;
        NodeList nodos = firma.getElementsByTagNameNS(this.xadesSchema, "QualifyingProperties");
        if (nodos.getLength() == 0) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error18"));
        }
        elementoPrincipal = (Element)nodos.item(0);
        Element propiedadesElementosNoFirmados = null;
        ArrayList<Element> nodosUnsigendProp = null;
        try {
            nodosUnsigendProp = UtilidadTratarNodo.obtenerNodos(elementoPrincipal, 1, new NombreNodo(this.xadesSchema, "UnsignedProperties"));
        }
        catch (FirmaXMLError firmaXMLError) {
            // empty catch block
        }
        if (nodosUnsigendProp != null && nodosUnsigendProp.size() == 1) {
            propiedadesElementosNoFirmados = nodosUnsigendProp.get(0);
        } else {
            propiedadesElementosNoFirmados = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "UnsignedProperties");
            Attr propiedadesNoFirmadasId = doc.createAttributeNS(null, "Id");
            propiedadesNoFirmadasId.setValue(UtilidadTratarNodo.newID(doc, String.valueOf(firmaID) + "-UnsignedProperties"));
            NamedNodeMap atributosSinFirmarPropiedadesElemento = propiedadesElementosNoFirmados.getAttributes();
            atributosSinFirmarPropiedadesElemento.setNamedItem(propiedadesNoFirmadasId);
        }
        Element propiedadesSinFirmarFirmaElementos = null;
        ArrayList<Element> nodosUnsigendSigProp = null;
        try {
            nodosUnsigendSigProp = UtilidadTratarNodo.obtenerNodos(elementoPrincipal, 2, new NombreNodo(this.xadesSchema, "UnsignedSignatureProperties"));
        }
        catch (FirmaXMLError firmaXMLError) {
            // empty catch block
        }
        propiedadesSinFirmarFirmaElementos = nodosUnsigendSigProp != null && nodosUnsigendSigProp.size() == 1 ? nodosUnsigendSigProp.get(0) : doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "UnsignedSignatureProperties");
        NodeList sellosPreexistentes = doc.getElementsByTagNameNS(this.xadesSchema, "SignatureTimeStamp");
        int numSellos = sellosPreexistentes.getLength();
        int i = 0;
        while (i < numSellos) {
            Element sello = (Element)sellosPreexistentes.item(i);
            String selloId = sello.getAttribute("Id");
            if (selloId == null) {
                Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
                selloId = UtilidadTratarNodo.newID(doc, "SelloTiempo");
                informacionElementoSigTimeStamp.setValue(selloId);
                sello.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
            }
            this.idNodoSelloTiempo.add(selloId);
            ++i;
        }
        Element tiempoSelloElementoFirma = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "SignatureTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        tiempoSelloElementoFirma.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) || "http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
            String nombreNodoUri = null;
            String tipoUri = null;
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
                nombreNodoUri = "HashDataInfo";
                tipoUri = "uri";
            } else {
                nombreNodoUri = "Include";
                tipoUri = "URI";
            }
            Element informacionElementoHashDatos = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + nombreNodoUri);
            ArrayList<Object> listElements = new ArrayList();
            try {
                listElements = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
            }
            catch (FirmaXMLError e) {
                log.error(I18n.getResource("libreriaxades.firmaxml.error5"), e);
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error5"));
            }
            if (listElements.size() != 1) {
                log.error(I18n.getResource("libreriaxades.firmaxml.error5"));
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error5"));
            }
            this.idSignatureValue = ((Element)listElements.get(0)).getAttribute("Id");
            if (this.idSignatureValue == null) {
                log.error(I18n.getResource("libreriaxades.firmaxml.error5"));
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error5"));
            }
            Attr informacionElementoHashDatosUri = doc.createAttributeNS(null, tipoUri);
            informacionElementoHashDatosUri.setValue("#" + this.idSignatureValue);
            NamedNodeMap informacionAtributosElementoHashDatos = informacionElementoHashDatos.getAttributes();
            informacionAtributosElementoHashDatos.setNamedItem(informacionElementoHashDatosUri);
            tiempoSelloElementoFirma.appendChild(informacionElementoHashDatos);
        }
        if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "CanonicalizationMethod");
            Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
            canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
            tiempoSelloElementoFirma.appendChild(canonicalizationElemento);
        }
        Element tiempoSelloEncapsulado = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "EncapsulatedTimeStamp");
        tiempoSelloEncapsulado.appendChild(doc.createTextNode(new String(Base64Coder.encode(selloTiempo))));
        Attr tiempoSelloEncapsuladoId = doc.createAttributeNS(null, "Id");
        String idEncapsulated = UtilidadTratarNodo.newID(doc, "SelloTiempo-Token");
        tiempoSelloEncapsuladoId.setValue(idEncapsulated);
        tiempoSelloEncapsulado.getAttributes().setNamedItem(tiempoSelloEncapsuladoId);
        tiempoSelloElementoFirma.appendChild(tiempoSelloEncapsulado);
        propiedadesSinFirmarFirmaElementos.appendChild(tiempoSelloElementoFirma);
        propiedadesElementosNoFirmados.appendChild(propiedadesSinFirmarFirmaElementos);
        elementoPrincipal.appendChild(propiedadesElementosNoFirmados);
        return doc;
    }

    private Document addXadesC(Element firma, ArrayList<RespYCerts> respuestas, XAdESSchemas schema, String algDigestXML) throws AddXadesException {
        Document doc = firma.getOwnerDocument();
        Element elementoPrincipal = null;
        ArrayList<X509Certificate> certRefs = null;
        String tipoUri = null;
        tipoUri = "http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) ? "uri" : "URI";
        NodeList nodos = firma.getElementsByTagNameNS(this.xadesSchema, "UnsignedSignatureProperties");
        if (nodos.getLength() == 0) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error19"));
        }
        elementoPrincipal = (Element)nodos.item(0);
        Element certificadosElementosFirma = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "CompleteCertificateRefs");
        Element revocacionesElementoFirma = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "CompleteRevocationRefs");
        int size = respuestas.size();
        if (size > 0) {
            certRefs = new ArrayList<X509Certificate>(size);
            int x = 0;
            while (x < size) {
                if (!respuestas.get(x).getCertstatus().getStatus().equals((Object)ICertStatus.CERT_STATUS.valid)) {
                    throw new AddXadesException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error56")) + " " + respuestas.get(x).getCertstatus().getCertificate().getSubjectDN() + " " + respuestas.get(x).getCertstatus().getCertificate().getSerialNumber());
                }
                certRefs.add(respuestas.get(x).getCertstatus().getCertificate());
                ++x;
            }
        } else {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error56"));
        }
        if (certRefs != null) {
            Attr informacionElementoCertRef = doc.createAttributeNS(null, "Id");
            this.idNodoCertificateRefs = UtilidadTratarNodo.newID(doc, "CompleteCertificateRefs");
            informacionElementoCertRef.setValue(this.idNodoCertificateRefs);
            certificadosElementosFirma.getAttributes().setNamedItem(informacionElementoCertRef);
            Element elementoCertRefs = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "CertRefs");
            certificadosElementosFirma.appendChild(elementoCertRefs);
            int longitud = certRefs.size();
            String idNueva = UtilidadTratarNodo.newID(doc, "CertPath");
            respuestas.get(0).setIdCertificado(idNueva);
            int i = 1;
            while (i < longitud) {
                X509Certificate firmaCertificado = (X509Certificate)certRefs.get(i);
                Element elementCertRef = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "Cert");
                Attr uris = doc.createAttributeNS(null, tipoUri);
                idNueva = UtilidadTratarNodo.newID(doc, "CertPath");
                uris.setValue("#" + idNueva);
                respuestas.get(i).setIdCertificado(idNueva);
                NamedNodeMap atributosURI = elementCertRef.getAttributes();
                atributosURI.setNamedItem(uris);
                Element resumenElementoCert = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "CertDigest");
                Element metodoResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "DigestMethod");
                Attr propiedadesFirmaAlgoritmo = doc.createAttributeNS(null, "Algorithm");
                propiedadesFirmaAlgoritmo.setValue(algDigestXML);
                NamedNodeMap cualidadesMetodoResumenElemento = metodoResumenElemento.getAttributes();
                cualidadesMetodoResumenElemento.setNamedItem(propiedadesFirmaAlgoritmo);
                String resumenCertificado = "";
                try {
                    MessageDigest resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest(algDigestXML);
                    if (resumenCertificadoTemp == null) {
                        throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error16"));
                    }
                    byte[] resumenMensajeByte = resumenCertificadoTemp.digest(firmaCertificado.getEncoded());
                    resumenCertificado = new String(Base64Coder.encode(resumenMensajeByte));
                }
                catch (CertificateEncodingException e) {
                    log.error(e);
                    throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error23"));
                }
                Element elementDigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "DigestValue");
                elementDigestValue.appendChild(doc.createTextNode(resumenCertificado));
                Element elementoEmisorSerial = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "IssuerSerial");
                Element elementoX509EmisorNombre = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "X509IssuerName");
                String issuerName = null;
                try {
                    issuerName = firmaCertificado.getIssuerX500Principal().getName();
                    if (log.isTraceEnabled()) {
                        log.trace("Certificado emisor obtenido del Issuer X500: " + issuerName);
                    }
                    Charset charsetUtf = Charset.forName("UTF-8");
                    issuerName = charsetUtf.decode(ByteBuffer.wrap(issuerName.getBytes())).toString();
                    if (log.isTraceEnabled()) {
                        log.trace("Emisor decodificado en UTF8:" + issuerName);
                    }
                }
                catch (Exception e1) {
                    if (log.isDebugEnabled()) {
                        log.error("Error al codificar el emisor en UTF-8. Se toma su valor con el charset original.", e1);
                    }
                    issuerName = firmaCertificado.getIssuerDN().getName();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Certificado emisor: " + issuerName);
                }
                elementoX509EmisorNombre.appendChild(doc.createTextNode(issuerName));
                Element elementoX509NumeroSerial = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "X509SerialNumber");
                elementoX509NumeroSerial.appendChild(doc.createTextNode(firmaCertificado.getSerialNumber().toString()));
                elementoEmisorSerial.appendChild(elementoX509EmisorNombre);
                elementoEmisorSerial.appendChild(elementoX509NumeroSerial);
                resumenElementoCert.appendChild(metodoResumenElemento);
                resumenElementoCert.appendChild(elementDigestValue);
                elementCertRef.appendChild(resumenElementoCert);
                elementCertRef.appendChild(elementoEmisorSerial);
                elementoCertRefs.appendChild(elementCertRef);
                ++i;
            }
        }
        Element elementOCSPRef = null;
        String tiempoRespuesta = null;
        byte[] mensajeRespuesta = null;
        if (size > 0) {
            Attr informacionElementoCertRef = doc.createAttributeNS(null, "Id");
            this.idNodoRevocationRefs = UtilidadTratarNodo.newID(doc, "CompleteRevocationRefs");
            informacionElementoCertRef.setValue(this.idNodoRevocationRefs);
            revocacionesElementoFirma.getAttributes().setNamedItem(informacionElementoCertRef);
            int nOCSPRefs = 0;
            int nCRLRefs = 0;
            Element elementOCSPRefs = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "OCSPRefs");
            CRLRefs elementCRLRefs = new CRLRefs(schema);
            int x = 0;
            while (x < size) {
                RespYCerts respYCert = respuestas.get(x);
                ICertStatus certStatus = respYCert.getCertstatus();
                if (certStatus instanceof IOCSPCertStatus) {
                    Element elementoRespondedorId;
                    ++nOCSPRefs;
                    IOCSPCertStatus respOcsp = (IOCSPCertStatus)certStatus;
                    tiempoRespuesta = UtilidadFechas.formatFechaXML(respOcsp.getResponseDate());
                    IOCSPCertStatus.TYPE_RESPONDER tipoResponder = respOcsp.getResponderType();
                    String valorResponder = respOcsp.getResponderID();
                    mensajeRespuesta = respOcsp.getEncoded();
                    elementOCSPRef = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "OCSPRef");
                    String idNueva = UtilidadTratarNodo.newID(doc, "OCSP");
                    respYCert.setIdRespStatus(idNueva);
                    Element identificadorElementoOCSP = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "OCSPIdentifier");
                    Attr uris = doc.createAttributeNS(null, tipoUri);
                    uris.setValue("#" + idNueva);
                    NamedNodeMap atributosURI = identificadorElementoOCSP.getAttributes();
                    atributosURI.setNamedItem(uris);
                    Element responderFinal = elementoRespondedorId = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "ResponderID");
                    if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) && !"http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
                        Element hijo = null;
                        hijo = tipoResponder.equals((Object)IOCSPCertStatus.TYPE_RESPONDER.BY_NAME) ? doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "ByName") : doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "ByKey");
                        elementoRespondedorId.appendChild(hijo);
                        responderFinal = hijo;
                    }
                    try {
                        valorResponder = new String(valorResponder.getBytes(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e1) {
                        if (log.isDebugEnabled()) {
                            log.debug(e1);
                        }
                        try {
                            valorResponder = URLEncoder.encode(valorResponder, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new AddXadesException("No se pudo construir las referencias OCSP", e);
                        }
                    }
                    responderFinal.appendChild(doc.createTextNode(valorResponder));
                    Element elementoProdujoEn = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "ProducedAt");
                    elementoProdujoEn.appendChild(doc.createTextNode(tiempoRespuesta));
                    identificadorElementoOCSP.appendChild(elementoRespondedorId);
                    identificadorElementoOCSP.appendChild(elementoProdujoEn);
                    Element valorYResumenElemento = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "DigestAlgAndValue");
                    Element metodoResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "DigestMethod");
                    Attr propiedadesAlgoritmoFirmado = doc.createAttributeNS(null, "Algorithm");
                    propiedadesAlgoritmoFirmado.setValue(algDigestXML);
                    NamedNodeMap atributosMetodoResumenElemento = metodoResumenElemento.getAttributes();
                    atributosMetodoResumenElemento.setNamedItem(propiedadesAlgoritmoFirmado);
                    String digestCertificado = "";
                    MessageDigest resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest(algDigestXML);
                    if (resumenCertificadoTemp == null) {
                        throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error20"));
                    }
                    byte[] resumenMensajeByte = resumenCertificadoTemp.digest(mensajeRespuesta);
                    digestCertificado = new String(Base64Coder.encode(resumenMensajeByte));
                    Element valorResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "DigestValue");
                    valorResumenElemento.appendChild(doc.createTextNode(digestCertificado));
                    valorYResumenElemento.appendChild(metodoResumenElemento);
                    valorYResumenElemento.appendChild(valorResumenElemento);
                    elementOCSPRef.appendChild(identificadorElementoOCSP);
                    elementOCSPRef.appendChild(valorYResumenElemento);
                    elementOCSPRefs.appendChild(elementOCSPRef);
                } else if (certStatus instanceof IX509CRLCertStatus) {
                    ++nCRLRefs;
                    IX509CRLCertStatus respCRL = (IX509CRLCertStatus)certStatus;
                    try {
                        CRLRef crlRef = new CRLRef(schema, algDigestXML, respCRL.getX509CRL());
                        String idNueva = UtilidadTratarNodo.newID(doc, "CRL");
                        crlRef.getCrlIdentifier().setUri("#" + idNueva);
                        respYCert.setIdRespStatus(idNueva);
                        elementCRLRefs.addCRLRef(crlRef);
                    }
                    catch (InvalidInfoNodeException ex) {
                        throw new AddXadesException("No se pudo construir las referencias a CRLs", ex);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Se salta el elemento n\u00famero " + x);
                }
                ++x;
            }
            if (nCRLRefs > 0) {
                try {
                    Element el = elementCRLRefs.createElement(doc, this.xmldsigNS, this.xadesNS);
                    revocacionesElementoFirma.appendChild(el);
                }
                catch (InvalidInfoNodeException ex) {
                    throw new AddXadesException("No se pudo construir las referencias a CRLs", ex);
                }
            }
            if (nOCSPRefs > 0) {
                revocacionesElementoFirma.appendChild(elementOCSPRefs);
            }
        }
        elementoPrincipal.appendChild(certificadosElementosFirma);
        elementoPrincipal.appendChild(revocacionesElementoFirma);
        return doc;
    }

    private Document addXadesX(Element UnsignedSignatureProperties, ITimeStampGenerator timeStampGenerator) throws AddXadesException {
        String tipoUri = null;
        String nombreNodoUri = null;
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            nombreNodoUri = "HashDataInfo";
            tipoUri = "uri";
        } else {
            nombreNodoUri = "Include";
            tipoUri = "URI";
        }
        Document doc = UnsignedSignatureProperties.getOwnerDocument();
        Node padre = UnsignedSignatureProperties.getParentNode();
        int i = 0;
        while (i < 3) {
            if (padre == null) {
                throw new AddXadesException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + "Signature");
            }
            padre = padre.getParentNode();
            ++i;
        }
        Element signatureElement = null;
        if (padre == null || !"Signature".equals(padre.getLocalName())) {
            throw new AddXadesException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + "Signature");
        }
        signatureElement = (Element)padre;
        Element sigAndRefsTimeStampElement = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "SigAndRefsTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        sigAndRefsTimeStampElement.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        UnsignedSignatureProperties.appendChild(sigAndRefsTimeStampElement);
        ArrayList<Element> elementosSelloX = null;
        try {
            elementosSelloX = UtilidadXadesX.obtenerListadoXADESX1imp(this.xadesSchema, signatureElement, sigAndRefsTimeStampElement);
        }
        catch (BadFormedSignatureException e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) || "http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
            ArrayList<String> elementosIdSelloX = UtilidadTratarNodo.obtenerIDs(elementosSelloX);
            ArrayList<Element> nodosUriReferencia = new ArrayList<Element>(elementosIdSelloX.size());
            for (String id : elementosIdSelloX) {
                Element uriNode = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + nombreNodoUri);
                Attr includeNodeUri = doc.createAttributeNS(null, tipoUri);
                includeNodeUri.setValue("#" + id);
                NamedNodeMap atributosNodo = uriNode.getAttributes();
                atributosNodo.setNamedItem(includeNodeUri);
                nodosUriReferencia.add(uriNode);
            }
            for (Element includeNode : nodosUriReferencia) {
                sigAndRefsTimeStampElement.appendChild(includeNode);
            }
        }
        byte[] byteData = null;
        try {
            byteData = UtilidadTratarNodo.obtenerByte(elementosSelloX, CanonicalizationEnum.C14N_OMIT_COMMENTS);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        if (timeStampGenerator == null) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error14"));
        }
        try {
            byteData = timeStampGenerator.generateTimeStamp(byteData);
        }
        catch (TimeStampException e) {
            throw new AddXadesException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error11")) + e.getMessage());
        }
        String hashSelloX = new String(Base64Coder.encode(byteData));
        if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "CanonicalizationMethod");
            Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
            canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
            sigAndRefsTimeStampElement.appendChild(canonicalizationElemento);
        }
        Element encapsulatedTimeStampNode = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "EncapsulatedTimeStamp");
        encapsulatedTimeStampNode.appendChild(doc.createTextNode(hashSelloX));
        sigAndRefsTimeStampElement.appendChild(encapsulatedTimeStampNode);
        return doc;
    }

    private Document addXadesX2(Element UnsignedSignatureProperties, ITimeStampGenerator timeStampGenerator) throws AddXadesException {
        String tipoUri = null;
        String nombreNodoUri = null;
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            nombreNodoUri = "HashDataInfo";
            tipoUri = "uri";
        } else {
            nombreNodoUri = "Include";
            tipoUri = "URI";
        }
        Document doc = UnsignedSignatureProperties.getOwnerDocument();
        Node padre = UnsignedSignatureProperties.getParentNode();
        int i = 0;
        while (i < 3) {
            if (padre == null) {
                throw new AddXadesException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + "Signature");
            }
            padre = padre.getParentNode();
            ++i;
        }
        Element signatureElement = null;
        if (padre == null || !"Signature".equals(padre.getLocalName())) {
            throw new AddXadesException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + "Signature");
        }
        signatureElement = (Element)padre;
        Element refsOnlyTimeStampElement = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "RefsOnlyTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        refsOnlyTimeStampElement.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        UnsignedSignatureProperties.appendChild(refsOnlyTimeStampElement);
        ArrayList<Element> elementosSelloX = null;
        try {
            elementosSelloX = UtilidadXadesX.obtenerListadoXADESX2exp(this.xadesSchema, signatureElement, refsOnlyTimeStampElement);
        }
        catch (BadFormedSignatureException e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) || "http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
            ArrayList<String> elementosIdSelloX = UtilidadTratarNodo.obtenerIDs(elementosSelloX);
            ArrayList<Element> nodosUriReferencia = new ArrayList<Element>(elementosIdSelloX.size());
            for (String id : elementosIdSelloX) {
                Element uriNode = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + nombreNodoUri);
                Attr includeNodeUri = doc.createAttributeNS(null, tipoUri);
                includeNodeUri.setValue("#" + id);
                NamedNodeMap atributosNodo = uriNode.getAttributes();
                atributosNodo.setNamedItem(includeNodeUri);
                nodosUriReferencia.add(uriNode);
            }
            for (Element includeNode : nodosUriReferencia) {
                refsOnlyTimeStampElement.appendChild(includeNode);
            }
        }
        byte[] byteData = null;
        try {
            byteData = UtilidadTratarNodo.obtenerByte(elementosSelloX, CanonicalizationEnum.C14N_OMIT_COMMENTS);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        if (timeStampGenerator == null) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error14"));
        }
        try {
            byteData = timeStampGenerator.generateTimeStamp(byteData);
        }
        catch (TimeStampException e) {
            throw new AddXadesException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error11")) + e.getMessage());
        }
        String hashSelloX = new String(Base64Coder.encode(byteData));
        if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "CanonicalizationMethod");
            Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
            canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
            refsOnlyTimeStampElement.appendChild(canonicalizationElemento);
        }
        Element encapsulatedTimeStampNode = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "EncapsulatedTimeStamp");
        encapsulatedTimeStampNode.appendChild(doc.createTextNode(hashSelloX));
        refsOnlyTimeStampElement.appendChild(encapsulatedTimeStampNode);
        return doc;
    }

    private Document addXadesXL(Element firma, ArrayList<RespYCerts> respuestas, XAdESSchemas schema) throws AddXadesException {
        Document doc = firma.getOwnerDocument();
        Element elementoPrincipal = null;
        NodeList nodosUnsignedSignatureProperties = firma.getElementsByTagNameNS(schema.getSchemaUri(), "UnsignedSignatureProperties");
        if (nodosUnsignedSignatureProperties.getLength() == 0) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error19"));
        }
        elementoPrincipal = (Element)nodosUnsignedSignatureProperties.item(0);
        if (respuestas != null) {
            EncapsulatedX509Certificate encapsulatedX509certificate = null;
            ArrayList<EncapsulatedX509Certificate> certs = new ArrayList<EncapsulatedX509Certificate>();
            Iterator<RespYCerts> itResp = respuestas.iterator();
            boolean hasNext = itResp.hasNext();
            if (hasNext) {
                itResp.next();
                hasNext = itResp.hasNext();
            }
            while (hasNext) {
                RespYCerts resp = itResp.next();
                hasNext = itResp.hasNext();
                encapsulatedX509certificate = new EncapsulatedX509Certificate(schema, resp.getIdCertificado());
                try {
                    encapsulatedX509certificate.setX509Certificate(resp.getCertstatus().getCertificate());
                }
                catch (CertificateException e) {
                    log.error(e.getMessage(), e);
                    throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error23"));
                }
                certs.add(encapsulatedX509certificate);
            }
            CertificateValues certificateValues = new CertificateValues(schema, certs);
            Element certificateValuesElement = null;
            try {
                certificateValuesElement = certificateValues.createElement(doc, this.xadesNS);
            }
            catch (InvalidInfoNodeException e) {
                log.error(e.getMessage(), e);
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error23"));
            }
            Attr atributoCertVal = doc.createAttributeNS(null, "Id");
            String idCertVal = UtilidadTratarNodo.newID(doc, "CertificateValues");
            atributoCertVal.setValue(idCertVal);
            certificateValuesElement.getAttributes().setNamedItem(atributoCertVal);
            elementoPrincipal.appendChild(certificateValuesElement);
            Element valoresElementosRevocados = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "RevocationValues");
            Element valorElementOCSP = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "OCSPValues");
            CRLValues valorElementoCRL = new CRLValues(schema);
            int nOcspResps = 0;
            int nCRLSResps = 0;
            itResp = respuestas.iterator();
            hasNext = itResp.hasNext();
            while (hasNext) {
                RespYCerts resp = itResp.next();
                hasNext = itResp.hasNext();
                ICertStatus respStatus = resp.getCertstatus();
                if (respStatus instanceof IOCSPCertStatus) {
                    ++nOcspResps;
                    IOCSPCertStatus respOCSP = (IOCSPCertStatus)respStatus;
                    Element valorElementoEncapsuladoOCSP = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "EncapsulatedOCSPValue");
                    valorElementoEncapsuladoOCSP.appendChild(doc.createTextNode(new String(Base64Coder.encode(respOCSP.getEncoded()))));
                    valorElementoEncapsuladoOCSP.setAttributeNS(null, "Id", resp.getIdRespStatus());
                    valorElementOCSP.appendChild(valorElementoEncapsuladoOCSP);
                    continue;
                }
                if (!(respStatus instanceof IX509CRLCertStatus)) continue;
                ++nCRLSResps;
                IX509CRLCertStatus respCRL = (IX509CRLCertStatus)respStatus;
                try {
                    valorElementoCRL.addCRL(respCRL.getX509CRL(), resp.getIdRespStatus());
                }
                catch (InvalidInfoNodeException ex) {
                    throw new AddXadesException("No se pudo generar nodo EncapsulatedCRLValue", ex);
                }
            }
            if (nCRLSResps > 0) {
                try {
                    Element el = valorElementoCRL.createElement(doc, this.xadesNS);
                    valoresElementosRevocados.appendChild(el);
                }
                catch (InvalidInfoNodeException ex) {
                    throw new AddXadesException("No se pudo generar nodo CRLValues", ex);
                }
            }
            if (nOcspResps > 0) {
                valoresElementosRevocados.appendChild(valorElementOCSP);
            }
            Attr atributoRevVal = doc.createAttributeNS(null, "Id");
            String idRevVal = UtilidadTratarNodo.newID(doc, "RevocationValues");
            atributoRevVal.setValue(idRevVal);
            valoresElementosRevocados.getAttributes().setNamedItem(atributoRevVal);
            elementoPrincipal.appendChild(valoresElementosRevocados);
        }
        return doc;
    }

    private Document addXadesA(Element firma, byte[] selloTiempo, ArrayList<String> inc) throws Exception {
        Document doc = firma.getOwnerDocument();
        ArrayList<Element> unsignedSignaturePropertiesNodes = UtilidadTratarNodo.obtenerNodos(firma, 4, new NombreNodo(this.xadesSchema, "UnsignedSignatureProperties"));
        Element unsignedSignaturePropertiesNode = null;
        if (unsignedSignaturePropertiesNodes.size() != 1) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error19"));
        }
        unsignedSignaturePropertiesNode = unsignedSignaturePropertiesNodes.get(0);
        Element archiveTimeStamp = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "ArchiveTimeStamp");
        Attr archiveTimeStampId = doc.createAttributeNS(null, "Id");
        archiveTimeStampId.setValue(UtilidadTratarNodo.newID(doc, "ArchiveTimeStamp-"));
        NamedNodeMap archiveTimeStampAttributesElement = archiveTimeStamp.getAttributes();
        archiveTimeStampAttributesElement.setNamedItem(archiveTimeStampId);
        Element encapsulatedTimeStamp = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "EncapsulatedTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo-Token");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        encapsulatedTimeStamp.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", String.valueOf(this.xmldsigNS) + ":" + "CanonicalizationMethod");
        Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
        canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
        archiveTimeStamp.appendChild(canonicalizationElemento);
        encapsulatedTimeStamp.appendChild(doc.createTextNode(new String(Base64Coder.encode(selloTiempo))));
        if (inc != null) {
            Element includeNode = null;
            int i = 0;
            while (i < inc.size()) {
                includeNode = doc.createElementNS(this.xadesSchema, String.valueOf(this.xadesNS) + ":" + "Include");
                includeNode.setAttributeNS(null, "URI", inc.get(i));
                archiveTimeStamp.appendChild(includeNode);
                ++i;
            }
        }
        archiveTimeStamp.appendChild(encapsulatedTimeStamp);
        unsignedSignaturePropertiesNode.appendChild(archiveTimeStamp);
        return doc;
    }

    public String countersignFile(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, String nodoAFirmarId, String destino, String nombreArchivo) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        Object[] res = this.countersign(firmaCertificado, xml, nodoAFirmarId, pk, storeManager.getProvider(firmaCertificado));
        File fichero = new File(destino, nombreArchivo);
        FileOutputStream f2 = new FileOutputStream(fichero);
        try {
            UtilidadFicheros.writeXML((Document)res[0], f2);
            String string = (String)res[2];
            return string;
        }
        catch (Throwable t) {
            if (t.getMessage() != null && t.getMessage().startsWith("Java heap space")) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
            }
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
        }
        finally {
            f2.close();
        }
    }

    public String countersign2Stream(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, String nodoAFirmarId, OutputStream salida) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        Object[] res = this.countersign(firmaCertificado, xml, nodoAFirmarId, pk, storeManager.getProvider(firmaCertificado));
        try {
            UtilidadFicheros.writeXML((Document)res[0], salida);
            return (String)res[2];
        }
        catch (Throwable t) {
            if (t.getMessage() != null && t.getMessage().startsWith("Java heap space")) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
            }
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] countersign(X509Certificate certificadoFirma, DataToSign xml, String nodoAFirmarId, PrivateKey pk, Provider provider) throws Exception {
        void var18_22;
        ArrayList<Element> listElements;
        Utils.addBCProvider();
        Document doc = xml.getDocument();
        if (doc == null) {
            try {
                InputStream is = xml.getInputStream();
                if (is != null) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    db.setErrorHandler(new IgnoreAllErrorHandler());
                    InputSource isour = new InputSource(is);
                    doc = db.parse(isour);
                }
            }
            catch (IOException ex) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error50"));
            }
        }
        xml.setXMLEncoding(doc.getXmlEncoding());
        Node nodePadreNodoFirmar = null;
        if (nodoAFirmarId != null) {
            Element nodoAFirmar = UtilidadTratarNodo.getElementById(doc, nodoAFirmarId);
            if (nodoAFirmar == null) {
                log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + nodoAFirmarId);
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
            if ("SignatureValue".equals(nodoAFirmar.getLocalName())) {
                this.idSignatureValue = nodoAFirmarId;
                nodePadreNodoFirmar = nodoAFirmar.getParentNode();
            } else {
                if (!"Signature".equals(nodoAFirmar.getLocalName())) {
                    log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + nodoAFirmarId);
                    throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
                }
                nodePadreNodoFirmar = nodoAFirmar;
            }
        } else {
            NodeList list = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (list.getLength() < 1) {
                log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + nodoAFirmarId);
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
            nodePadreNodoFirmar = list.item(list.getLength() - 1);
        }
        String idSignatureValue = null;
        Element padreNodoFirmar = null;
        if (nodePadreNodoFirmar != null && nodePadreNodoFirmar.getNodeType() == 1) {
            padreNodoFirmar = (Element)nodePadreNodoFirmar;
            listElements = UtilidadTratarNodo.obtenerNodos(padreNodoFirmar, 2, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
            if (listElements.size() != 1) {
                log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + nodoAFirmarId);
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
            idSignatureValue = listElements.get(0).getAttribute("Id");
            if (idSignatureValue == null) {
                log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + nodoAFirmarId);
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
        }
        if ((listElements = UtilidadTratarNodo.obtenerNodos(padreNodoFirmar, 2, "QualifyingProperties")).size() != 1) {
            log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + nodoAFirmarId);
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
        }
        String esquemaOrigen = listElements.get(0).getNamespaceURI();
        NodeList nodosUnsigSigProp = padreNodoFirmar.getElementsByTagNameNS(esquemaOrigen, "UnsignedSignatureProperties");
        Element nodoRaiz = null;
        if (nodosUnsigSigProp != null && nodosUnsigSigProp.getLength() != 0) {
            nodoRaiz = (Element)nodosUnsigSigProp.item(0);
        } else {
            NodeList nodosQualifying = padreNodoFirmar.getElementsByTagNameNS(esquemaOrigen, "QualifyingProperties");
            if (nodosQualifying != null && nodosQualifying.getLength() != 0) {
                Element nodoQualifying = (Element)nodosQualifying.item(0);
                Element unsignedProperties = null;
                if (nodoQualifying.getPrefix() != null) {
                    unsignedProperties = doc.createElementNS(esquemaOrigen, String.valueOf(nodoQualifying.getPrefix()) + ":" + "UnsignedProperties");
                    nodoRaiz = doc.createElementNS(esquemaOrigen, String.valueOf(nodoQualifying.getPrefix()) + ":" + "UnsignedSignatureProperties");
                } else {
                    unsignedProperties = doc.createElementNS(esquemaOrigen, "UnsignedProperties");
                    nodoRaiz = doc.createElementNS(esquemaOrigen, "UnsignedSignatureProperties");
                }
                unsignedProperties.appendChild(nodoRaiz);
                nodosQualifying.item(0).appendChild(unsignedProperties);
            } else {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error52"));
            }
        }
        Element counterSignature = null;
        counterSignature = nodoRaiz.getPrefix() != null ? doc.createElementNS(esquemaOrigen, String.valueOf(nodoRaiz.getPrefix()) + ":" + "CounterSignature") : doc.createElementNS(esquemaOrigen, "CounterSignature");
        nodoRaiz.appendChild(counterSignature);
        XAdESSchemas esquemaTemp = xml.getEsquema();
        this.xadesSchema = esquemaTemp != null ? esquemaTemp.getSchemaUri() : XAdESSchemas.XAdES_132.getSchemaUri();
        Attr counterSignatureAttrib = doc.createAttributeNS(null, "Id");
        String counterSignatureId = UtilidadTratarNodo.newID(doc, "CounterSignature-");
        counterSignatureAttrib.setValue(counterSignatureId);
        counterSignature.getAttributes().setNamedItem(counterSignatureAttrib);
        xml.setDocument(doc);
        Object var18_19 = null;
        if (XAdESSchemas.XAdES_132.getSchemaUri().equals(this.xadesSchema)) {
            SignObjectToSign signObjectToSign = new SignObjectToSign(idSignatureValue);
        } else {
            InternObjectToSign internObjectToSign = new InternObjectToSign(idSignatureValue);
        }
        xml.addObject(new ObjectToSign((AbstractObjectToSign)var18_22, null, null, null, null));
        xml.setParentSignNode(counterSignatureId);
        Object[] res = this.signFile(certificadoFirma, xml, pk, provider);
        counterSignature = UtilidadTratarNodo.getElementById(doc, counterSignatureId);
        counterSignature.removeAttribute("Id");
        return res;
    }

    public long getMilisDiffSigningTime(Element padre, String idNode) {
        try {
            return this.getMilisDiffSigningTime(UtilidadTratarNodo.getElementById(padre, idNode));
        }
        catch (Exception e) {
            log.warn("No se pudo obtener la fecha de la firma: " + e.getMessage(), e);
            return 0L;
        }
    }

    public long getMilisDiffSigningTime(Element node) {
        Date fechaFirma;
        block5: {
            if (node == null) {
                log.debug("No se recibi\u00f3 ningun par\u00e1metro");
                return 0L;
            }
            fechaFirma = null;
            try {
                ArrayList<Element> nodos = UtilidadTratarNodo.obtenerNodos(node, 5, "SigningTime");
                if (nodos == null || nodos.size() != 1) break block5;
                String fecha = nodos.get(0).getFirstChild().getNodeValue();
                if (fecha != null) {
                    fechaFirma = UtilidadFechas.parseaFechaXML(fecha);
                    break block5;
                }
                log.warn("No se pudo obtener la fecha del nodo");
                return 0L;
            }
            catch (Exception e) {
                log.warn("No se pudo obtener la fecha de la firma: " + e.getMessage(), e);
                return 0L;
            }
        }
        long now = System.currentTimeMillis();
        return now - fechaFirma.getTime();
    }

    public boolean raiseLevel(InputStream firma, EnumFormatoFirma nivelDeseado, String path, String nombreArchivo, String id, String ocspUrl, String tsaUrl, String trusterId) throws Exception {
        if (firma == null || nivelDeseado == null || path == null || nombreArchivo == null || id == null || ocspUrl == null || tsaUrl == null) {
            throw new Exception(i18n.getLocalMessage("i18n.mityc.xades.sign.11"));
        }
        DataToSign data2Sign = new DataToSign();
        data2Sign.setXadesFormat(nivelDeseado);
        data2Sign.setXAdESXType(DataToSign.XADES_X_TYPES.TYPE_1);
        data2Sign.setBaseURI(path);
        data2Sign.setXMLEncoding("UTF-8");
        data2Sign.setEsquema(XAdESSchemas.XAdES_132);
        data2Sign.setAlgDigestXmlDSig("http://www.w3.org/2001/04/xmldsig-more#sha256");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document docToRaise = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new IgnoreAllErrorHandler());
            if (firma != null) {
                InputSource isour = new InputSource(firma);
                isour.setEncoding("UTF-8");
                docToRaise = db.parse(isour);
            }
        }
        catch (IOException e) {
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error50"), e);
        }
        catch (ParserConfigurationException e) {
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error50"), e);
        }
        catch (SAXException e) {
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error50"), e);
        }
        data2Sign.setDocument(docToRaise);
        data2Sign.setTimeStampGenerator(new HTTPTimeStampGenerator(tsaUrl, "SHA-1"));
        TrustAbstract truster = TrustFactory.getInstance().getTruster(trusterId);
        if (truster == null) {
            System.out.println("No se ha encontrado el validador de confianza");
        }
        data2Sign.setCertStatusManager(new OCSPLiveConsultant(ocspUrl, truster));
        data2Sign.setElementsStorer(new LocalFileStoreElements());
        data2Sign.setXadesFormat(nivelDeseado);
        Document doc = this.raiseLevel(data2Sign, id);
        File fichero = null;
        FileOutputStream f = null;
        try {
            try {
                fichero = new File(String.valueOf(path) + nombreArchivo);
                f = new FileOutputStream(fichero);
                UtilidadFicheros.writeXML(doc, f);
            }
            catch (Throwable t) {
                if (t.getMessage() != null && t.getMessage().startsWith("Java heap space")) {
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error3"));
                }
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error4"));
            }
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
        return true;
    }

    public Document raiseLevel(DataToSign signData, String signatureID) throws ClienteError {
        ArrayList<RespYCerts> respuestas = new ArrayList<RespYCerts>();
        ArrayList<X509Certificate> certificadosConOCSP = new ArrayList<X509Certificate>();
        if (signatureID == null || signData == null) {
            throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error31"));
        }
        Document doc = signData.getDocument();
        EnumFormatoFirma nivelDeseado = signData.getXadesFormat();
        NodeList listaFirmas = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int listaFirmasLength = listaFirmas.getLength();
        if (listaFirmasLength < 1) {
            log.error(I18n.getResource("libreriaxades.validarfirmaxml.error2"));
            throw new ClienteError(I18n.getResource("libreriaxades.validarfirmaxml.error2"));
        }
        Element signature = null;
        signature = signatureID.equals("") ? (Element)listaFirmas.item(listaFirmasLength - 1) : UtilidadTratarNodo.getElementById(doc, signatureID);
        if (signature == null) {
            log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error49")) + " " + listaFirmasLength);
            throw new ClienteError(I18n.getResource("libreriaxades.validarfirmaxml.error2"));
        }
        if (!new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Signature").equals(new NombreNodo(signature.getNamespaceURI(), signature.getLocalName()))) {
            throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + "Signature");
        }
        Element certificateNode = (Element)signature.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0);
        byte[] certificateContent = Base64Coder.decode(certificateNode.getFirstChild().getNodeValue());
        X509Certificate certificate = null;
        try {
            certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificateContent));
        }
        catch (CertificateException e) {
            log.error(e.getMessage(), e);
            throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error6"), e);
        }
        ResultadoValidacion resultado = null;
        try {
            ValidarFirmaXML validacion = new ValidarFirmaXML();
            resultado = validacion.validar(signature, signature.getBaseURI(), null);
            this.xadesSchema = resultado.getDatosFirma().getEsquema().getSchemaUri();
        }
        catch (Exception e) {
            throw new ClienteError(e.getMessage(), e);
        }
        if (resultado != null && resultado.getDatosFirma() != null && (resultado.isValidate() || resultado.getDatosFirma().getDatosNodosNoSignFirmados().size() > 0)) {
            ArrayList<EnumFormatoFirma> mejora = new ArrayList<EnumFormatoFirma>();
            EnumFormatoFirma nivel = resultado.getEnumNivel();
            if (nivel == null && resultado.getDatosFirma().getDatosNodosNoSignFirmados().size() > 0) {
                nivel = EnumFormatoFirma.XAdES_BES;
            }
            while (!nivelDeseado.equals((Object)nivel)) {
                if (EnumFormatoFirma.XAdES_BES.equals((Object)nivel)) {
                    nivel = EnumFormatoFirma.XAdES_T;
                } else if (EnumFormatoFirma.XAdES_T.equals((Object)nivel)) {
                    nivel = EnumFormatoFirma.XAdES_C;
                } else if (EnumFormatoFirma.XAdES_C.equals((Object)nivel)) {
                    nivel = EnumFormatoFirma.XAdES_X;
                } else {
                    if (!EnumFormatoFirma.XAdES_X.equals((Object)nivel)) break;
                    nivel = EnumFormatoFirma.XAdES_XL;
                }
                mejora.add(nivel);
            }
            boolean isXadesXL = mejora.contains((Object)EnumFormatoFirma.XAdES_XL);
            Iterator niveles = mejora.iterator();
            boolean hasNext = niveles.hasNext();
            byte[] selloTiempo = null;
            while (hasNext) {
                nivel = (EnumFormatoFirma)((Object)niveles.next());
                hasNext = niveles.hasNext();
                if (EnumFormatoFirma.XAdES_T.equals((Object)nivel)) {
                    try {
                        ITimeStampGenerator timeStampGenerator = signData.getTimeStampGenerator();
                        if (timeStampGenerator == null) {
                            throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error6"));
                        }
                        try {
                            byte[] byteSignature = UtilidadTratarNodo.obtenerByteNodo(signature, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue", CanonicalizationEnum.C14N_OMIT_COMMENTS, 5);
                            selloTiempo = timeStampGenerator.generateTimeStamp(byteSignature);
                            this.addXadesT(signature, signatureID, selloTiempo);
                            continue;
                        }
                        catch (FirmaXMLError e) {
                            log.error(e.getMessage(), e);
                            throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error6"), e);
                        }
                        catch (TimeStampException e) {
                            log.error(e.getMessage(), e);
                            throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error6"), e);
                        }
                    }
                    catch (AddXadesException e) {
                        log.error(e.getMessage(), e);
                        throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error7")) + e.getMessage(), e);
                    }
                }
                if (EnumFormatoFirma.XAdES_C.equals((Object)nivel)) {
                    block68: {
                        try {
                            X509Certificate certTSA;
                            block67: {
                                log.info(i18n.getLocalMessage("i18n.mityc.xades.validate.18"));
                                this.convertICertStatus2RespYCerts(signData.getCertStatusManager().getCertChainStatus(certificate), certificadosConOCSP, respuestas);
                                if (log.isDebugEnabled()) {
                                    log.debug("Se incluyen las referencias OCSP de la propia VA");
                                }
                                try {
                                    IOCSPCertStatus respOcsp = (IOCSPCertStatus)respuestas.get(0).getCertstatus();
                                    OCSPResp resp = new OCSPResp(respOcsp.getEncoded());
                                    BasicOCSPResp respuestaBasica = (BasicOCSPResp)resp.getResponseObject();
                                    this.convertICertStatus2RespYCerts(this.getOCSPfromOCSP(respuestaBasica, certificadosConOCSP, null, signData), certificadosConOCSP, respuestas);
                                }
                                catch (CertStatusException ec) {
                                    log.error(ec);
                                    throw new ClienteChainNotFoundError(ec, "OCSP");
                                }
                                catch (Exception e1) {
                                    log.error(e1);
                                    throw new ClienteError(e1);
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("Se incluyen las referencias OCSP del sello de tiempo");
                                }
                                TimeStampToken tst = null;
                                try {
                                    if (selloTiempo == null) {
                                        ArrayList<Element> nodosSignatureTimeStamp = UtilidadTratarNodo.obtenerNodos(signature, 6, new NombreNodo(signData.getEsquema().getSchemaUri(), "SignatureTimeStamp"));
                                        Element nodoSigTimeStamp = nodosSignatureTimeStamp.get(0);
                                        NodeList nodesEncapsulatedTimeStamp = nodoSigTimeStamp.getElementsByTagNameNS(signData.getEsquema().getSchemaUri(), "EncapsulatedTimeStamp");
                                        Element encapsulatedTimeStampElement = (Element)nodesEncapsulatedTimeStamp.item(0);
                                        String encapsulatedTS = encapsulatedTimeStampElement.getFirstChild().getNodeValue();
                                        selloTiempo = Base64.decode(encapsulatedTS);
                                    }
                                    tst = new TimeStampToken(new CMSSignedData(selloTiempo));
                                }
                                catch (CMSException e) {
                                    try {
                                        TimeStampResponse tsr = new TimeStampResponse(selloTiempo);
                                        tst = tsr.getTimeStampToken();
                                    }
                                    catch (Exception ex) {
                                        log.error(ex);
                                        throw new ClienteError(ex);
                                    }
                                }
                                catch (Exception e) {
                                    log.error(e);
                                    throw new ClienteError(e);
                                }
                                certTSA = null;
                                try {
                                    CertStore cs = tst.getCertificatesAndCRLs("Collection", null);
                                    Collection<? extends Certificate> certs = cs.getCertificates(null);
                                    if (certs != null && certs.size() > 0) {
                                        if (log.isDebugEnabled()) {
                                            log.debug("Se regenera la cadena de certificados firmante del sello de tiempo y se lanza su validaci\u00f3n");
                                        }
                                        try {
                                            Collection<? extends Certificate> iterableCerts = null;
                                            if (!(certs instanceof Iterable)) {
                                                throw new Exception("El certificado no es del tipo esperado: " + certs.getClass());
                                            }
                                            iterableCerts = certs;
                                            CertPath cpTsa = UtilidadCertificados.orderCertPath(iterableCerts);
                                            certTSA = (X509Certificate)cpTsa.getCertificates().get(0);
                                        }
                                        catch (Exception e) {
                                            Certificate cert = certs.iterator().next();
                                            if (cert instanceof X509Certificate) {
                                                certTSA = (X509Certificate)cert;
                                            }
                                            break block67;
                                        }
                                    }
                                    log.error("No se pudo recuperar el certificado del sello de tiempo");
                                    throw new ClienteError("No se pudo recuperar el certificado del sello de tiempo");
                                }
                                catch (Exception e) {
                                    log.error(e);
                                    throw new ClienteError(e);
                                }
                            }
                            if (certTSA == null) break block68;
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug("Certificado de TSA obtenido " + certTSA.getSubjectX500Principal());
                                }
                                ArrayList<RespYCerts> respuestasTSA = new ArrayList<RespYCerts>();
                                if (certificadosConOCSP.contains(certTSA.getIssuerX500Principal())) {
                                    ICertStatus respTSA = signData.getCertStatusManager().getCertStatus(certTSA);
                                    ArrayList<ICertStatus> re = new ArrayList<ICertStatus>(1);
                                    re.add(respTSA);
                                    this.convertICertStatus2RespYCerts(re, certificadosConOCSP, respuestasTSA);
                                } else {
                                    this.convertICertStatus2RespYCerts(signData.getCertStatusManager().getCertChainStatus(certTSA), certificadosConOCSP, respuestasTSA);
                                }
                                respuestas.addAll(respuestasTSA);
                                if (log.isDebugEnabled()) {
                                    log.debug("TSA Validada. Se valida la VA del propio sello");
                                }
                                try {
                                    if (respuestasTSA.size() > 0) {
                                        IOCSPCertStatus respOcspTsa = (IOCSPCertStatus)respuestasTSA.get(0).getCertstatus();
                                        OCSPResp resp = new OCSPResp(respOcspTsa.getEncoded());
                                        BasicOCSPResp respuestaBasica = (BasicOCSPResp)resp.getResponseObject();
                                        this.convertICertStatus2RespYCerts(this.getOCSPfromOCSP(respuestaBasica, certificadosConOCSP, null, signData), certificadosConOCSP, respuestas);
                                        break block68;
                                    }
                                    log.error("No se ha podido obtener informaci\u00f3n de revocaci\u00f3n de la cadena del sello de tiempo.");
                                    throw new ClienteError("No se ha podido obtener informaci\u00f3n de revocaci\u00f3n de la cadena del sello de tiempo.");
                                }
                                catch (CertStatusException ec) {
                                    log.error(ec);
                                    throw new ClienteChainNotFoundError(ec, "OCSP");
                                }
                                catch (Exception e1) {
                                    log.error(e1);
                                    throw new ClienteError(e1);
                                }
                            }
                            catch (CertStatusException e) {
                                log.error(e.getMessage(), e);
                                throw new ClienteChainNotFoundError(I18n.getResource("libreriaxades.firmaxml.error10"), e, "TSA");
                            }
                        }
                        catch (CertStatusException e) {
                            log.error(e.getMessage(), e);
                            throw new ClienteChainNotFoundError(I18n.getResource("libreriaxades.firmaxml.error10"), e, "FIRMANTE");
                        }
                    }
                    String algDigestXML = signData.getAlgDigestXmlDSig() != null ? signData.getAlgDigestXmlDSig() : "http://www.w3.org/2000/09/xmldsig#sha1";
                    try {
                        this.addXadesC(signature, respuestas, XAdESSchemas.getXAdESSchema(this.xadesSchema), algDigestXML);
                    }
                    catch (AddXadesException e) {
                        log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error10")) + e.getMessage(), e);
                        throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error10")) + e.getMessage(), e);
                    }
                    if (isXadesXL) continue;
                    try {
                        doc = this.addURIXadesC(signature, this.saveOCSPFiles(respuestas, signData.getElementsStorer()), signData.getBaseURI());
                        continue;
                    }
                    catch (FirmaXMLError ex) {
                        log.error("Error al guardar ficheros de estados de certificados", ex);
                        throw new ClienteError("Error al guardar ficheros de estados de certificados", ex);
                    }
                }
                if (EnumFormatoFirma.XAdES_X.equals((Object)nivel)) {
                    Element unsignedSignaturePropertiesElement = null;
                    NodeList unsignedSignaturePropertiesNodes = signature.getElementsByTagNameNS(this.xadesSchema, "UnsignedSignatureProperties");
                    if (unsignedSignaturePropertiesNodes.getLength() < 1) {
                        log.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "UnsignedSignatureProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + unsignedSignaturePropertiesNodes.getLength());
                        throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error41"));
                    }
                    unsignedSignaturePropertiesElement = (Element)unsignedSignaturePropertiesNodes.item(0);
                    try {
                        this.addXadesX(unsignedSignaturePropertiesElement, signData.getTimeStampGenerator());
                        continue;
                    }
                    catch (AddXadesException e) {
                        log.error(e.getMessage(), e);
                        throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error12")) + e.getMessage());
                    }
                }
                if (!EnumFormatoFirma.XAdES_XL.equals((Object)nivel)) continue;
                try {
                    this.addXadesXL(signature, respuestas, XAdESSchemas.getXAdESSchema(this.xadesSchema));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    throw new ClienteError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error12")) + e.getMessage());
                }
            }
        }
        return doc;
    }

    private List<ICertStatus> getOCSPfromOCSP(BasicOCSPResp respuestaBasica, List<X509Certificate> certificadosConOCSP, List<X500Principal> certificadosAnteriores, DataToSign signData) throws CertStatusException, NoSuchProviderException, OCSPException {
        if (log.isDebugEnabled()) {
            ResponderID respID = respuestaBasica.getResponderId().toASN1Object();
            log.debug("Extracci\u00f3n del certificado OCSP: " + ASN1Utils.getResponderID(respID).toString());
        }
        if (certificadosAnteriores == null) {
            certificadosAnteriores = new ArrayList<X500Principal>();
            for (X509Certificate currentCert : certificadosConOCSP) {
                certificadosAnteriores.add(currentCert.getSubjectX500Principal());
            }
        }
        List<ICertStatus> re = new ArrayList<ICertStatus>();
        X509Certificate[] ocspCerts = respuestaBasica.getCerts("SUN");
        if (ocspCerts != null && ocspCerts.length > 0) {
            CertPath cpOcsp;
            X509Certificate ocspCert;
            if (log.isDebugEnabled()) {
                log.debug("Se regenera la cadena y se lanza la validaci\u00f3n");
            }
            if (!certificadosConOCSP.contains(ocspCert = (X509Certificate)(cpOcsp = UtilidadCertificados.orderCertPath(Arrays.asList(ocspCerts))).getCertificates().get(0)) && !certificadosAnteriores.contains(ocspCert.getSubjectX500Principal())) {
                if (!certificadosAnteriores.contains(ocspCert.getIssuerX500Principal())) {
                    re = signData.getCertStatusManager().getCertChainStatus(ocspCert);
                } else {
                    ICertStatus respOCSP = signData.getCertStatusManager().getCertStatus(ocspCert);
                    re = new ArrayList(1);
                    re.add(respOCSP);
                }
                if (re == null || re.size() == 0 || re.get(0) == null) {
                    log.error("No se ha podido obtener respuestas de validaci\u00f3n para la cadena de certificaci\u00f3n de: " + ocspCert.getSubjectX500Principal() + ". La cadena tiene: " + (cpOcsp.getCertificates() != null ? cpOcsp.getCertificates().size() : 0));
                    throw new CertStatusException("No se ha podido obtener respuestas de validaci\u00f3n para la cadena de certificaci\u00f3n de: " + ocspCert.getSubjectX500Principal() + ". La cadena tiene: " + (cpOcsp.getCertificates() != null ? cpOcsp.getCertificates().size() : 0));
                }
                certificadosAnteriores.add(ocspCert.getSubjectX500Principal());
                X509Certificate newOCSPCert = re.get(0).getCertificate();
                if (!certificadosConOCSP.contains(newOCSPCert) && !certificadosAnteriores.contains(newOCSPCert.getSubjectX500Principal())) {
                    re.addAll(this.getOCSPfromOCSP(respuestaBasica, certificadosConOCSP, certificadosAnteriores, signData));
                }
            }
        } else {
            log.error("No se pudo recuperar el certificado de la VA del OCSP");
            throw new CertStatusException("No se pudo recuperar el certificado de la VA del OCSP");
        }
        return re;
    }

    public Document addURIXadesC(Element firma, ArrayList<NombreElementos> listaArchivos, String baseUri) throws FirmaXMLError {
        Document doc = firma.getOwnerDocument();
        NodeList completeCertificateRefs = null;
        NodeList completeRevocationRefs = null;
        completeCertificateRefs = firma.getElementsByTagNameNS(this.xadesSchema, "CompleteCertificateRefs");
        completeRevocationRefs = firma.getElementsByTagNameNS(this.xadesSchema, "CompleteRevocationRefs");
        if (completeCertificateRefs.getLength() == 0 || completeRevocationRefs.getLength() == 0) {
            log.error(I18n.getResource("libreriaxades.firmaxml.error29"));
            return doc;
        }
        String tipoUri = null;
        tipoUri = "http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) ? "uri" : "URI";
        NodeList ocspRefs = null;
        NodeList crlRefs = null;
        try {
            ArrayList<Element> listOcspRefs = UtilidadTratarNodo.obtenerNodos((Element)completeRevocationRefs.item(0), null, new NombreNodo(this.xadesSchema, "OCSPRefs"));
            ArrayList<Element> listCRLRefs = UtilidadTratarNodo.obtenerNodos((Element)completeRevocationRefs.item(0), null, new NombreNodo(this.xadesSchema, "CRLRefs"));
            if (listOcspRefs.size() > 1) {
                throw new FirmaXMLError("hay demasiados elementos ocsprefs");
            }
            if (listCRLRefs.size() > 1) {
                throw new FirmaXMLError("hay demasiados elementos crlrefs");
            }
            if (listOcspRefs.size() > 0) {
                ocspRefs = listOcspRefs.get(0).getChildNodes();
            }
            if (listCRLRefs.size() > 0) {
                crlRefs = listCRLRefs.get(0).getChildNodes();
            }
        }
        catch (FirmaXMLError ex) {
            throw new FirmaXMLError("error obteniendo elementos ocsprefs y crlrefs");
        }
        Iterator<NombreElementos> it = listaArchivos.iterator();
        int indexOCSP = 0;
        int indexCRL = 0;
        while (it.hasNext()) {
            Node el;
            NombreElementos nf = it.next();
            if (!it.hasNext()) continue;
            String nameFile = nf.getNameFileCRLResp();
            if (nameFile == null) {
                nameFile = nf.getNameFileOCSPResp();
                if (nameFile == null) {
                    throw new FirmaXMLError("Fichero de status (OCSP o CRL) sin nombre");
                }
                if (ocspRefs == null || ocspRefs.getLength() <= indexOCSP) {
                    throw new FirmaXMLError("Fichero de status no relacionable con crlref");
                }
                el = ((Element)ocspRefs.item(indexOCSP++)).getElementsByTagNameNS(this.xadesSchema, "OCSPIdentifier").item(0);
            } else {
                if (crlRefs == null || crlRefs.getLength() <= indexCRL) {
                    throw new FirmaXMLError("Fichero de status no relacionable con crlref");
                }
                el = ((Element)crlRefs.item(indexCRL++)).getElementsByTagNameNS(this.xadesSchema, "CRLIdentifier").item(0);
            }
            Attr uri = doc.createAttributeNS(null, tipoUri);
            uri.setValue(nameFile);
            NamedNodeMap nodo = el.getAttributes();
            nodo.setNamedItem(uri);
        }
        Node certRefs = completeCertificateRefs.item(0).getFirstChild();
        if (certRefs != null) {
            NodeList certs = certRefs.getChildNodes();
            int l = certs.getLength();
            if (l != listaArchivos.size() - 1) {
                log.error(I18n.getResource("libreriaxades.firmaxml.error30"));
            }
            int i = 0;
            while (i < l) {
                Node certificado = certs.item(i);
                if (certificado != null) {
                    Attr uri = doc.createAttributeNS(null, tipoUri);
                    uri.setValue(listaArchivos.get(i + 1).getNameFileX509Cert());
                    NamedNodeMap nodoCertificado = certificado.getAttributes();
                    nodoCertificado.setNamedItem(uri);
                }
                ++i;
            }
        }
        return doc;
    }

    public ArrayList<NombreElementos> saveOCSPFiles(ArrayList<RespYCerts> respuesta, IStoreElements storer) {
        ArrayList<NombreElementos> listaArchivos = new ArrayList<NombreElementos>();
        if (respuesta != null && respuesta.size() > 0) {
            int i = 0;
            for (RespYCerts respAndCert : respuesta) {
                X509Certificate certificate = null;
                String certFile = null;
                if (i > 0 && ((certFile = respAndCert.getX509CertFile()) == null || certFile.trim().length() == 0)) {
                    certificate = respAndCert.getCertstatus().getCertificate();
                }
                ICertStatus respCert = null;
                if (i < respuesta.size() - 1) {
                    respCert = respAndCert.getCertstatus();
                }
                String[] names = storer.storeCertAndStatus(certificate, respCert);
                NombreElementos nombreElemento = new NombreElementos();
                if (certFile != null && certFile.trim().length() > 0) {
                    nombreElemento.setNameFileX509Cert(certFile);
                } else {
                    nombreElemento.setNameFileX509Cert(names[0]);
                }
                if (respCert instanceof IOCSPCertStatus) {
                    nombreElemento.setNameFileOCSPResp(names[1]);
                } else if (respCert instanceof IX509CRLCertStatus) {
                    nombreElemento.setNameFileCRLResp(names[1]);
                }
                listaArchivos.add(nombreElemento);
                ++i;
            }
        } else {
            log.error(I18n.getResource("libreriaxades.firmaxml.error27"));
            return null;
        }
        return listaArchivos;
    }
}

