/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.IssueTime;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Issuer;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Number;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.math.BigInteger;
import java.util.Date;
import org.w3c.dom.Element;

public class CRLIdentifierType
extends AbstractXADESElement {
    private Issuer issuer;
    private IssueTime issueTime;
    private Number number;
    private String uri;

    public CRLIdentifierType(XAdESSchemas schema, String issuer, Date issueTime, BigInteger number, String URI2) {
        super(schema);
        if (issuer != null) {
            this.issuer = new Issuer(schema, issuer);
        }
        if (issueTime != null) {
            this.issueTime = new IssueTime(schema, issueTime);
        }
        if (number != null) {
            this.number = new Number(schema, number);
        }
        if (URI2 != null) {
            this.uri = URI2;
        }
    }

    public CRLIdentifierType(XAdESSchemas schema) {
        super(schema);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public IssueTime getIssueTime() {
        return this.issueTime;
    }

    public void setIssueTime(IssueTime issueTime) {
        this.issueTime = issueTime;
    }

    public Number getNumber() {
        return this.number;
    }

    public void setNumber(Number number) {
        this.number = number;
    }

    @Override
    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.issuer == null || this.issueTime == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo CRLIdentifierType");
        }
        element.appendChild(this.issuer.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        element.appendChild(this.issueTime.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        if (this.number != null) {
            element.appendChild(this.number.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
        if (this.uri != null) {
            element.setAttributeNS(null, "URI", this.uri);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CRLIdentifierType) {
            CRLIdentifierType crl = (CRLIdentifierType)obj;
            if (this.issuer == null || this.issueTime == null) {
                return false;
            }
            if (!this.issuer.equals(crl.getIssuer())) {
                return false;
            }
            if (this.issueTime.equals(crl.getIssueTime())) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        Element node;
        if (element.hasAttribute("URI")) {
            this.uri = element.getAttribute("URI");
        }
        if ((node = UtilidadTratarNodo.getFirstElementChild(element, true)) == null || node.getNodeType() != 1) {
            throw new InvalidInfoNodeException("Se esperaba elemento como hijo de CRLIdentifierType");
        }
        Element child = node;
        this.issuer = new Issuer(this.schema);
        this.issuer.load(child);
        node = UtilidadTratarNodo.getNextElementSibling(child, true);
        if (node == null || node.getNodeType() != 1) {
            throw new InvalidInfoNodeException("Se esperaba elemento como hijo de CRLIdentifierType");
        }
        child = node;
        this.issueTime = new IssueTime(this.schema);
        this.issueTime.load(child);
        node = UtilidadTratarNodo.getNextElementSibling(child, true);
        if (node != null) {
            if (node.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Se esperaba elemento como hijo de CRLIdentifierType");
            }
            child = node;
            this.number = new Number(this.schema);
            this.number.load(child);
        }
    }
}

