/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLIdentifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DigestAlgAndValue;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CRLRefType
extends AbstractXADESElement {
    private DigestAlgAndValue digest;
    private CRLIdentifier crlIdentifier;

    public CRLRefType(XAdESSchemas schema) {
        super(schema);
    }

    public CRLRefType(XAdESSchemas schema, String method, X509CRL crl) throws InvalidInfoNodeException {
        super(schema);
        this.loadCRL(method, crl);
    }

    public CRLRefType(XAdESSchemas schema, String method, File crlFile) throws InvalidInfoNodeException {
        super(schema);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(new FileInputStream(crlFile));
            this.loadCRL(method, crl);
        }
        catch (CertificateException ex) {
            throw new InvalidInfoNodeException("Error generando digest de CRL", ex);
        }
        catch (CRLException ex) {
            throw new InvalidInfoNodeException("Error generando digest de CRL", ex);
        }
        catch (FileNotFoundException ex) {
            throw new InvalidInfoNodeException("Error generando digest de CRL", ex);
        }
    }

    private void loadCRL(String method, X509CRL crl) throws InvalidInfoNodeException {
        try {
            this.digest = new DigestAlgAndValue(this.schema, method, crl.getEncoded());
        }
        catch (CRLException ex) {
            throw new InvalidInfoNodeException("Error generando digest de CRL", ex);
        }
        BigInteger numeroRecuperado = null;
        byte[] extension = crl.getExtensionValue("2.5.29.20");
        if (extension != null) {
            try {
                ASN1InputStream ais = new ASN1InputStream(extension);
                ais = new ASN1InputStream(((DEROctetString)ais.readObject()).getOctets());
                DERInteger derInt = (DERInteger)ais.readObject();
                numeroRecuperado = derInt.getValue();
            }
            catch (IOException ex) {
                throw new InvalidInfoNodeException("Error generando digest de CRL", ex);
            }
        }
        this.crlIdentifier = new CRLIdentifier(this.schema, crl.getIssuerX500Principal().getName(), crl.getThisUpdate(), numeroRecuperado, null);
    }

    public DigestAlgAndValue getDigest() {
        return this.digest;
    }

    public void setDigest(DigestAlgAndValue digest) {
        this.digest = digest;
    }

    public CRLIdentifier getCrlIdentifier() {
        return this.crlIdentifier;
    }

    public void setCrlIdentifier(CRLIdentifier crlIdentifier) {
        this.crlIdentifier = crlIdentifier;
    }

    @Override
    public void addContent(Element element, String namespaceXAdES, String namespaceXDsig) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES, namespaceXDsig);
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.digest == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo CRLRefType");
        }
        element.appendChild(this.digest.createElement(element.getOwnerDocument(), this.namespaceXDsig, this.namespaceXAdES));
        if (this.crlIdentifier != null) {
            element.appendChild(this.crlIdentifier.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CRLRefType) {
            CRLRefType crl = (CRLRefType)obj;
            if (this.digest == null || crl.digest == null) {
                return false;
            }
            if (this.digest.equals(crl.digest)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        DigestAlgAndValue digest = new DigestAlgAndValue(this.schema);
        Node node = element.getFirstChild();
        if (!digest.isThisNode(node)) {
            throw new InvalidInfoNodeException("Nodo CRLRefType no tiene hijo DigestAlgAndValue");
        }
        digest.load((Element)node);
        node = node.getNextSibling();
        CRLIdentifier crlIdentifier = null;
        if (node != null) {
            crlIdentifier = new CRLIdentifier(this.schema);
            if (!crlIdentifier.isThisNode(node)) {
                throw new InvalidInfoNodeException("Se esperaba hijo CRLIdentifier en nodo CRLRefType");
            }
            crlIdentifier.load((Element)node);
        }
        this.digest = digest;
        this.crlIdentifier = crlIdentifier;
    }
}

