/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp;

import es.mityc.firmaJava.ocsp.exception.OCSPException;
import es.mityc.firmaJava.ocsp.exception.OCSPSignatureException;
import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.utils.Base64Coder;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.OCSPResp;

public class RespuestaOCSP {
    private static final String PROVEEDOR_SUN = "SUN";
    private int nroRespuesta = 9;
    private String mensajeRespuesta = "Consulta OCSP interrumpida";
    private OCSPResp respuesta;
    private Date tiempoRespuesta;
    private IOCSPCertStatus.TYPE_RESPONDER tipoResponder;
    private String valorResponder;
    private Date fechaRevocacion;
    private ArrayList<X509Certificate> ocspSignerCerts;

    public RespuestaOCSP(int nroRespuesta, String mensajeRespuesta) {
        this.nroRespuesta = nroRespuesta;
        this.mensajeRespuesta = mensajeRespuesta;
    }

    public RespuestaOCSP() {
    }

    public byte[] getRespuestaEncoded() {
        if (this.respuesta != null) {
            try {
                return this.respuesta.getEncoded();
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public OCSPResp getRespuesta() {
        return this.respuesta;
    }

    public X509Certificate[] getCertificates() throws OCSPException {
        X509Certificate[] certs = null;
        byte[] resp = this.getRespuestaEncoded();
        if (resp != null) {
            try {
                OCSPResp respuestaOCSP = new OCSPResp(resp);
                BasicOCSPResp basicOcsp = (BasicOCSPResp)respuestaOCSP.getResponseObject();
                if (basicOcsp != null) {
                    certs = basicOcsp.getCerts(PROVEEDOR_SUN);
                }
            }
            catch (IOException ex) {
                throw new OCSPException(ex);
            }
            catch (NoSuchProviderException ex) {
                throw new OCSPException(ex);
            }
            catch (org.bouncycastle.ocsp.OCSPException ex) {
                throw new OCSPException(ex);
            }
        }
        return certs;
    }

    public void setRespuesta(OCSPResp respuesta) {
        this.respuesta = respuesta;
    }

    public void setRespuesta(byte[] data) {
        try {
            this.respuesta = new OCSPResp(data);
        }
        catch (IOException ex) {
            this.respuesta = null;
        }
    }

    public String getMensajeRespuesta() {
        return this.mensajeRespuesta;
    }

    public void setMensajeRespuesta(String mensajeRespuesta) {
        this.mensajeRespuesta = mensajeRespuesta;
    }

    public int getNroRespuesta() {
        return this.nroRespuesta;
    }

    public void setNroRespuesta(int nroRespuesta) {
        this.nroRespuesta = nroRespuesta;
    }

    public Date getTiempoRespuesta() {
        Date resp = null;
        if (this.tiempoRespuesta != null) {
            resp = new Date(this.tiempoRespuesta.getTime());
        }
        return resp;
    }

    public void setTiempoRespuesta(Date tiempoRespuesta) {
        this.tiempoRespuesta = new Date(tiempoRespuesta.getTime());
    }

    public IOCSPCertStatus.TYPE_RESPONDER getTipoResponder() {
        return this.tipoResponder;
    }

    public void setResponder(ResponderID responder) {
        ASN1TaggedObject tagged = (ASN1TaggedObject)responder.toASN1Object();
        switch (tagged.getTagNo()) {
            case 1: {
                this.valorResponder = X509Name.getInstance(tagged.getObject()).toString();
                X509Principal certX509Principal = new X509Principal(this.valorResponder);
                X500Principal cerX500Principal = new X500Principal(certX509Principal.getDEREncoded());
                this.valorResponder = cerX500Principal.getName();
                this.tipoResponder = IOCSPCertStatus.TYPE_RESPONDER.BY_NAME;
                break;
            }
            case 2: {
                ASN1OctetString octect = (ASN1OctetString)tagged.getObject();
                this.valorResponder = new String(Base64Coder.encode(octect.getOctets()));
                this.tipoResponder = IOCSPCertStatus.TYPE_RESPONDER.BY_KEY;
            }
        }
    }

    public String getValorResponder() {
        return this.valorResponder;
    }

    public Date getFechaRevocacion() {
        return this.fechaRevocacion;
    }

    public void setFechaRevocacion(Date fecha) {
        if (fecha != null) {
            this.fechaRevocacion = new Date(fecha.getTime());
        }
    }

    public void setOCSPSigner(ArrayList<X509Certificate> certs) {
        this.ocspSignerCerts = certs;
    }

    public ArrayList<X509Certificate> getOCSPSigner() {
        return this.ocspSignerCerts;
    }

    public void checkSign(PublicKey pk) throws OCSPException {
        if (this.respuesta == null) {
            throw new OCSPException();
        }
        try {
            BasicOCSPResp respuestaBasica = (BasicOCSPResp)this.respuesta.getResponseObject();
            if (!respuestaBasica.verify(pk, "SunRsaSign")) {
                throw new OCSPSignatureException();
            }
        }
        catch (org.bouncycastle.ocsp.OCSPException ex) {
            throw new OCSPException(ex.getMessage(), ex);
        }
        catch (NoSuchProviderException ex) {
            throw new OCSPSignatureException(ex.getMessage(), ex);
        }
    }

    public static enum ESTADOS_RESPUESTA {
        SUCCESFULL,
        MALFORMED_REQ,
        INTERNAL_ERROR,
        TRY_LATER,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

