/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp.config;

import es.mityc.firmaJava.ocsp.config.ConfigProveedoresHandler;
import es.mityc.firmaJava.ocsp.config.ConstantesProveedores;
import es.mityc.firmaJava.ocsp.config.ProveedorInfo;
import es.mityc.firmaJava.ocsp.config.ServidorOcsp;
import es.mityc.firmaJava.ocsp.config.UtilidadesX509;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1OctetString;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigProveedores
implements ConstantesProveedores,
Cloneable {
    private static Log logger = LogFactory.getLog(ConfigProveedores.class);
    private Vector<ProveedorInfo> proveedores = new Vector();
    private String version = "";
    private String fecha = "";
    private static ConfigProveedores configCacheado = null;

    protected Object clone() throws CloneNotSupportedException {
        ConfigProveedores copy = (ConfigProveedores)super.clone();
        copy.version = this.version;
        copy.fecha = this.fecha;
        int totalProveedores = this.proveedores.size();
        int i = 0;
        while (i < totalProveedores) {
            copy.proveedores.add((ProveedorInfo)this.proveedores.get(i).clone());
            ++i;
        }
        return copy;
    }

    private InputSource getConfigFile() throws FileNotFoundException {
        InputSource sourceXml = null;
        File XmlUpdated = new File(String.valueOf(System.getProperty("user.dir")) + "/" + "OCSPServersInfo.xml");
        InputStream sXml = null;
        sXml = XmlUpdated.exists() ? new FileInputStream(XmlUpdated) : this.getClass().getResourceAsStream("/OCSPServersInfo.xml");
        sourceXml = new InputSource(sXml);
        return sourceXml;
    }

    public boolean read() throws SAXException {
        boolean ok;
        block9: {
            ok = false;
            ConfigProveedoresHandler reader = new ConfigProveedoresHandler();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            spf.setSchema(sf.newSchema(new StreamSource(this.getClass().getResourceAsStream("/OCSPServersInfo.xsd"))));
            spf.setNamespaceAware(true);
            try {
                SAXParser parser = spf.newSAXParser();
                parser.parse(this.getConfigFile(), (DefaultHandler)reader);
                this.proveedores = reader.getProveedores();
                this.version = reader.getVersion();
                this.fecha = reader.getFecha();
                ok = true;
            }
            catch (FileNotFoundException e) {
                logger.error("IOException " + e.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(e);
                }
            }
            catch (SAXNotRecognizedException ex) {
                logger.error(ex.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(ex);
                }
            }
            catch (SAXNotSupportedException ex) {
                logger.error(ex.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(ex);
                }
            }
            catch (IOException e) {
                logger.error("IOException " + e.getMessage());
            }
            catch (ParserConfigurationException ex) {
                logger.error("IOException " + ex.getMessage());
                if (!logger.isDebugEnabled()) break block9;
                logger.debug(ex);
            }
        }
        return ok;
    }

    public ProveedorInfo buscarProveedor(Object certObj) {
        X509Certificate cert;
        block8: {
            cert = null;
            if (certObj == null) {
                logger.error("Illegal argument type. Can be a String, byte[] or X509Certificate.");
                return null;
            }
            try {
                if (certObj instanceof byte[]) {
                    cert = UtilidadesX509.getCertificate((byte[])certObj);
                    break block8;
                }
                if (certObj instanceof String) {
                    cert = UtilidadesX509.getCertificate((String)certObj);
                    break block8;
                }
                if (certObj instanceof X509Certificate) {
                    cert = (X509Certificate)certObj;
                    break block8;
                }
                logger.error("Illegal argument type. Can be a String, byte[] or X509Certificate.");
                return null;
            }
            catch (CertificateException e) {
                logger.error("IOException ", e);
            }
        }
        ProveedorInfo buscado = null;
        String nameHash = "";
        String pkHash = "";
        try {
            ASN1OctetString issuerNameHash = UtilidadesX509.getIssuerNameHash(cert);
            ASN1OctetString issuerKeyHash = UtilidadesX509.getIssuerKeyHash(cert);
            nameHash = issuerNameHash.toString().replace("#", "");
            pkHash = issuerKeyHash.toString().replace("#", "");
            buscado = this.buscarProveedor(nameHash, pkHash);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        return buscado;
    }

    protected ProveedorInfo buscarProveedor(String nameHash, String pkHash) {
        if (this.proveedores == null) {
            return null;
        }
        int totalProveedores = this.proveedores.size();
        ProveedorInfo poBuscado = null;
        int i = 0;
        while (i < totalProveedores) {
            if (this.proveedores.get(i).puedeValidar(nameHash, pkHash)) {
                poBuscado = this.proveedores.get(i);
            }
            ++i;
        }
        return poBuscado;
    }

    public String getFecha() {
        return this.fecha;
    }

    public String getVersion() {
        return this.version;
    }

    public Vector<ProveedorInfo> getProveedores() {
        return (Vector)this.proveedores.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ServidorOcsp getServidor(X509Certificate cert) {
        ServidorOcsp servidorOcsp = null;
        try {
            ConfigProveedores config = null;
            if (configCacheado == null) {
                config = new ConfigProveedores();
                if (!config.read()) {
                    return null;
                }
                configCacheado = config;
            } else {
                config = configCacheado;
            }
            ProveedorInfo proveedor = config.buscarProveedor(cert);
            if (proveedor != null) return proveedor.getServidor();
            return null;
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            if (!logger.isDebugEnabled()) return servidorOcsp;
            logger.debug(e);
        }
        return servidorOcsp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector<ServidorOcsp> getServidores(X509Certificate cert) {
        Vector<ServidorOcsp> servidores = null;
        try {
            ConfigProveedores config = null;
            if (configCacheado == null) {
                config = new ConfigProveedores();
                if (!config.read()) {
                    return null;
                }
                configCacheado = config;
            } else {
                config = configCacheado;
            }
            ProveedorInfo proveedor = config.buscarProveedor(cert);
            if (proveedor != null) return proveedor.getServidores();
            return null;
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            if (!logger.isDebugEnabled()) return servidores;
            logger.debug(e);
        }
        return servidores;
    }
}

