/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp.config;

import es.mityc.firmaJava.ocsp.config.ConstantesProveedores;
import es.mityc.javasign.utils.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.digests.SHA1Digest;

public final class UtilidadesX509
implements ConstantesProveedores {
    private static Log logger = LogFactory.getLog(UtilidadesX509.class);
    private static final String STRING_EMPTY = "";

    public static boolean isEmpty(String valor) {
        return valor == null || valor.trim().equals(STRING_EMPTY);
    }

    public static X509Certificate getCertificate(Object certObj) throws CertificateException {
        X509Certificate cert = null;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream certStream = null;
        if (certObj instanceof String) {
            certStream = new ByteArrayInputStream(Base64Coder.decode((String)certObj));
        } else if (certObj instanceof byte[]) {
            certStream = new ByteArrayInputStream((byte[])certObj);
        } else if (certObj instanceof InputStream) {
            certStream = (ByteArrayInputStream)certObj;
        } else {
            throw new CertificateException("Illegal argument type. Can be a String, byte[] or X509Certificate.");
        }
        try {
            cert = (X509Certificate)cf.generateCertificate(certStream);
        }
        catch (CertificateException e) {
            logger.error(e.getMessage());
            throw new CertificateException(e.getMessage());
        }
        return cert;
    }

    public static DERObject convertToDERObject(byte[] data) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ASN1InputStream derInputStream = new ASN1InputStream(inStream);
        return derInputStream.readObject();
    }

    public static ASN1OctetString getIssuerKeyHash(X509Certificate cert) throws IOException {
        ASN1OctetString issuerKeyHash = null;
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = cert.getIssuerX500Principal().getEncoded();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        DERObject derObject = UtilidadesX509.convertToDERObject(cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId()));
        if (derObject instanceof DEROctetString) {
            DEROctetString derOctetString = (DEROctetString)derObject;
            derObject = UtilidadesX509.convertToDERObject(derOctetString.getOctets());
        }
        ASN1Sequence aIs = ASN1Sequence.getInstance(derObject);
        issuerKeyHash = ASN1OctetString.getInstance(aIs.getObjectAt(0));
        return issuerKeyHash;
    }

    public static ASN1OctetString getIssuerNameHash(X509Certificate cert) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = cert.getIssuerX500Principal().getEncoded();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        DEROctetString issuerNameHash = new DEROctetString(resBuf);
        return issuerNameHash;
    }

    public static ASN1OctetString getSubjectNameHash(X509Certificate cert) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = cert.getSubjectX500Principal().getEncoded();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        DEROctetString issuerNameHash = new DEROctetString(resBuf);
        return issuerNameHash;
    }

    public static ASN1OctetString getSubjectKeyHash(X509Certificate cert) throws IOException {
        PublicKey pk = cert.getPublicKey();
        byte[] pkCertBytes = pk.getEncoded();
        DERObject der = UtilidadesX509.convertToDERObject(pkCertBytes);
        ASN1Sequence seq = ASN1Sequence.getInstance(der);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(seq);
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        DEROctetString issuerKeyHash = new DEROctetString(resBuf);
        return issuerKeyHash;
    }
}

