/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.certificate;

import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.utils.Base64Coder;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;

public abstract class OCSPResponderID {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibAPI");
    protected IOCSPCertStatus.TYPE_RESPONDER typeResponderID = null;

    protected OCSPResponderID(IOCSPCertStatus.TYPE_RESPONDER type) {
        this.typeResponderID = type;
    }

    public static OCSPResponderID getOCSPResponderID(X500Principal name) {
        return new OCSPResponderIDName(name);
    }

    public static OCSPResponderID getOCSPResponderID(byte[] data) {
        return new OCSPResponderIDHash((byte[])data.clone());
    }

    public static OCSPResponderID getOCSPresponderID(String id) {
        return new OCSPResponderIDUnknown(id);
    }

    public IOCSPCertStatus.TYPE_RESPONDER getTypeResponderID() {
        return this.typeResponderID;
    }

    public abstract Object getIdentifierData();

    public String toString() {
        String res = null;
        if (this.typeResponderID != null) {
            switch (this.typeResponderID) {
                case BY_NAME: {
                    res = I18N.getLocalMessage("i18n.mityc.api.cert.2");
                    break;
                }
                default: {
                    res = I18N.getLocalMessage("i18n.mityc.api.cert.3");
                    break;
                }
            }
        } else {
            res = I18N.getLocalMessage("i18n.mityc.api.cert.4");
        }
        return I18N.getLocalMessage("i18n.mityc.api.cert.1", res);
    }

    public static class OCSPResponderIDHash
    extends OCSPResponderID {
        private byte[] hashPK = null;

        protected OCSPResponderIDHash(byte[] hash) {
            super(IOCSPCertStatus.TYPE_RESPONDER.BY_KEY);
            this.hashPK = hash;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof OCSPResponderIDHash) {
                return Arrays.equals(this.hashPK, ((OCSPResponderIDHash)arg0).hashPK);
            }
            if (arg0 instanceof OCSPResponderIDUnknown) {
                return arg0.equals(this);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashPK != null) {
                return this.hashPK.hashCode();
            }
            return super.hashCode();
        }

        @Override
        public Object getIdentifierData() {
            return this.hashPK;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + I18N.getLocalMessage("i18n.mityc.api.cert.5", Arrays.toString(this.hashPK));
        }
    }

    public static class OCSPResponderIDName
    extends OCSPResponderID {
        private X500Principal nameResponder = null;

        protected OCSPResponderIDName(X500Principal name) {
            super(IOCSPCertStatus.TYPE_RESPONDER.BY_NAME);
            this.nameResponder = name;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof OCSPResponderIDName) {
                if (this.nameResponder != null) {
                    return this.nameResponder.equals(((OCSPResponderIDName)arg0).nameResponder);
                }
                return ((OCSPResponderIDName)arg0).nameResponder == null;
            }
            if (arg0 instanceof OCSPResponderIDUnknown) {
                return arg0.equals(this);
            }
            return false;
        }

        public int hashCode() {
            return this.nameResponder != null ? this.nameResponder.hashCode() : super.hashCode();
        }

        @Override
        public Object getIdentifierData() {
            return this.nameResponder;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + I18N.getLocalMessage("i18n.mityc.api.cert.5", this.nameResponder != null ? this.nameResponder.getName() : "null");
        }
    }

    public static class OCSPResponderIDUnknown
    extends OCSPResponderID {
        private String identifier = null;

        public OCSPResponderIDUnknown(String id) {
            super(null);
            this.identifier = new String(id);
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof OCSPResponderIDName) {
                if (this.identifier != null) {
                    try {
                        X500Principal prin = new X500Principal(this.identifier);
                        return prin.equals(((OCSPResponderIDName)arg0).nameResponder);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                }
                return ((OCSPResponderIDName)arg0).nameResponder == null;
            }
            if (arg0 instanceof OCSPResponderIDHash) {
                if (this.identifier != null) {
                    try {
                        byte[] hash = Base64Coder.decode(this.identifier);
                        return Arrays.equals(hash, ((OCSPResponderIDHash)arg0).hashPK);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                }
                return ((OCSPResponderIDHash)arg0).hashPK == null;
            }
            if (arg0 instanceof OCSPResponderIDUnknown) {
                if (this.identifier != null) {
                    return this.identifier.equals(((OCSPResponderIDUnknown)arg0).identifier);
                }
                return ((OCSPResponderIDUnknown)arg0).identifier == null;
            }
            return false;
        }

        public int hashCode() {
            return this.identifier != null ? this.identifier.hashCode() : super.hashCode();
        }

        @Override
        public Object getIdentifierData() {
            return this.identifier;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + I18N.getLocalMessage("i18n.mityc.api.cert.5", this.identifier);
        }
    }
}

