/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.certificate.ocsp;

import es.mityc.firmaJava.ocsp.OCSPCliente;
import es.mityc.firmaJava.ocsp.RespuestaOCSP;
import es.mityc.firmaJava.ocsp.exception.OCSPClienteException;
import es.mityc.firmaJava.ocsp.exception.OCSPProxyException;
import es.mityc.javasign.certificate.CertStatusException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.ICertStatusRecoverer;
import es.mityc.javasign.certificate.ocsp.OCSPStatus;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.UnknownTrustException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OCSPLiveConsultant
implements ICertStatusRecoverer {
    static Log logger = LogFactory.getLog(OCSPLiveConsultant.class);
    private static final II18nManager i18n = I18nFactory.getI18nManager("MITyCLibOCSP");
    private String servidorOCSP;
    private TrustAbstract validadorConfianza;
    private OCSPCliente ocspCliente = null;

    public OCSPLiveConsultant(String hostOCSPResponder, TrustAbstract truster) {
        this.servidorOCSP = hostOCSPResponder;
        this.validadorConfianza = truster;
    }

    @Override
    public List<ICertStatus> getCertStatus(List<X509Certificate> certList) throws CertStatusException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public ICertStatus getCertStatus(X509Certificate cert) throws CertStatusException {
        OCSPStatus bloque = null;
        RespuestaOCSP respuesta = null;
        try {
            this.ocspCliente = new OCSPCliente(this.servidorOCSP);
            X509Certificate issuerCertificate = null;
            try {
                CertPath certPath = this.validadorConfianza.getCertPath(cert);
                List<? extends Certificate> certificates = certPath.getCertificates();
                issuerCertificate = certificates.size() > 1 ? (X509Certificate)certificates.get(1) : (X509Certificate)certificates.get(0);
            }
            catch (UnknownTrustException ex) {
                logger.error(i18n.getLocalMessage("i18n.mityc.ocsp.list.1", cert.getIssuerX500Principal()), ex);
                issuerCertificate = cert;
            }
            respuesta = this.ocspCliente.validateCert(cert, issuerCertificate);
        }
        catch (OCSPClienteException ex) {
            throw new CertStatusException(ex.getMessage(), ex);
        }
        catch (OCSPProxyException ex) {
            throw new CertStatusException(ex.getMessage(), ex);
        }
        if (respuesta == null) {
            respuesta = new RespuestaOCSP(9, "Consulta OCSP interrumpida");
            respuesta.setTiempoRespuesta(new Date(System.currentTimeMillis()));
        }
        bloque = new OCSPStatus(respuesta, cert);
        return bloque;
    }

    @Override
    public List<ICertStatus> getCertChainStatus(X509Certificate cert) throws CertStatusException {
        ArrayList<ICertStatus> result = new ArrayList<ICertStatus>();
        try {
            this.ocspCliente = new OCSPCliente(this.servidorOCSP);
            CertPath certPath = this.validadorConfianza.getCertPath(cert);
            List<? extends Certificate> certificates = certPath.getCertificates();
            int certificatesSize = certificates.size();
            int i = 0;
            while (i < certificatesSize) {
                X509Certificate certificateToValidate = (X509Certificate)certificates.get(i);
                X509Certificate issuerCertificate = i == certificatesSize - 1 ? (X509Certificate)certificates.get(i) : (X509Certificate)certificates.get(i + 1);
                RespuestaOCSP respuesta = this.ocspCliente.validateCert(certificateToValidate, issuerCertificate);
                OCSPStatus bloque = new OCSPStatus(respuesta, certificateToValidate);
                result.add(bloque);
                ++i;
            }
        }
        catch (OCSPClienteException ex) {
            throw new CertStatusException(ex.getMessage(), ex);
        }
        catch (OCSPProxyException ex) {
            throw new CertStatusException(ex.getMessage(), ex);
        }
        catch (UnknownTrustException ex) {
            throw new CertStatusException(ex.getMessage(), ex);
        }
        return result;
    }

    @Override
    public List<List<ICertStatus>> getCertChainStatus(List<X509Certificate> certs) throws CertStatusException {
        throw new UnsupportedOperationException("Not Supported Operation");
    }

    public synchronized void abort() {
        if (this.ocspCliente != null) {
            this.ocspCliente.abort();
        }
    }

    public void setTimeOut(int timeOut) {
        if (this.ocspCliente != null) {
            this.ocspCliente.setTimeOut(timeOut);
        }
    }
}

