/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.certificate.ocsp;

import es.mityc.javasign.ssl.ISSLErrorManager;
import es.mityc.javasign.ssl.ISSLManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.X509Name;

public class OwnSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(OwnSSLProtocolSocketFactory.class);
    private ISSLManager sslManager = null;
    private SSLContext sslcontext = null;

    public OwnSSLProtocolSocketFactory(ISSLManager ssl) {
        this.sslManager = ssl;
    }

    public OwnSSLProtocolSocketFactory() {
    }

    private SSLContext createSSLContext() throws IOException {
        try {
            KeyManager[] keymanagers = null;
            TrustManager[] trustmanagers = null;
            if (this.sslManager != null) {
                TrustManager tm;
                KeyManager km = this.sslManager.getKeyManager();
                if (km != null) {
                    keymanagers = new KeyManager[]{km};
                }
                if ((tm = this.sslManager.getTrustManager()) != null) {
                    trustmanagers = new TrustManager[]{tm};
                }
            }
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(keymanagers, trustmanagers, null);
            return sslcontext;
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new IOException(ex.getMessage());
        }
        catch (KeyManagementException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new IOException(ex.getMessage());
        }
    }

    private SSLContext getSSLContext() throws IOException {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        Socket socket = null;
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            socket = socketfactory.createSocket(host, port, localAddress, localPort);
        } else {
            socket = socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
        }
        this.verifyHostname((SSLSocket)socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocketFactory sf = this.getSSLContext().getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(host, port, clientHost, clientPort);
        this.verifyHostname(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory sf = this.getSSLContext().getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(host, port);
        this.verifyHostname(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocketFactory sf = this.getSSLContext().getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(socket, host, port, autoClose);
        this.verifyHostname(sslSocket);
        return sslSocket;
    }

    private void verifyHostname(SSLSocket socket) throws SSLPeerUnverifiedException, UnknownHostException {
        String cn;
        if (this.sslManager == null) {
            return;
        }
        ISSLErrorManager errorMng = this.sslManager.getSSLErrorManager();
        if (errorMng == null) {
            return;
        }
        SSLSession session = socket.getSession();
        String hostname = session.getPeerHost();
        try {
            InetAddress.getByName(hostname);
        }
        catch (UnknownHostException uhe) {
            throw new UnknownHostException("Could not resolve SSL sessions server hostname: " + hostname);
        }
        X509Certificate[] certs = session.getPeerCertificateChain();
        if (certs == null || certs.length == 0) {
            throw new SSLPeerUnverifiedException("No server certificates found!");
        }
        String dn = certs[0].getSubjectDN().getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server certificate chain:");
            int i = 0;
            while (i < certs.length) {
                LOG.debug("X509Certificate[" + i + "]=" + certs[i]);
                ++i;
            }
        }
        if (hostname.equalsIgnoreCase(cn = this.getCN(dn))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Target hostname valid: " + cn);
            }
        } else {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                java.security.cert.X509Certificate servCert = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certs[0].getEncoded()));
                if (!errorMng.continueErrorPeer(hostname, servCert)) {
                    throw new SSLPeerUnverifiedException("HTTPS hostname invalid: expected '" + hostname + "', received '" + cn + "'");
                }
            }
            catch (CertificateException ex) {
                LOG.error(ex.getMessage(), ex);
                throw new SSLPeerUnverifiedException("Unexpected error checking HTTPS hostname: " + ex.getMessage());
            }
            catch (CertificateEncodingException ex) {
                LOG.error(ex.getMessage(), ex);
                throw new SSLPeerUnverifiedException("Unexpected error checking HTTPS hostname: " + ex.getMessage());
            }
        }
    }

    private String getCN(String dn) {
        X509Name name = new X509Name(dn);
        Vector vector = name.getValues(X509Name.CN);
        if (vector != null && vector.size() > 0) {
            return (String)vector.get(0);
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(OwnSSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return OwnSSLProtocolSocketFactory.class.hashCode();
    }
}

