/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.i18n;

import es.mityc.javasign.i18n.DictionaryUnknownException;
import es.mityc.javasign.i18n.I18nDefaultManager;
import es.mityc.javasign.i18n.I18nDumbManager;
import es.mityc.javasign.i18n.II18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.i18n.ManagerCached;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nFactory {
    private static final Log LOG = LogFactory.getLog(I18nFactory.class);
    private static final String PATH_RES_I18N_PROPS = "i18n/i18n.properties";
    private static final String CLASS_FACTORY = "i18n.factory.class";
    private static final String CLASS_MANAGER = "i18n.manager.class";
    private static final String LOCALE_DEFAULT = "i18n.locale.default";
    private static final String METHOD_NEW_INSTANCE = "newInstance";
    private static final String STRING_SPACE = "_";
    private static final String STRING_EMPTY = "";
    private static final String WARN_UNKNOWN_LOCALE = "Locale no reconocido";
    private static final String NOT_CONFIGURATED_LOCALE = "No se ha configurado un Locale espec\u00edfico";
    private static final String ERROR_CONFIGURATION_FACTORY = "No se ha configurado ninguna factor\u00eda propia para la internacionalizaci\u00f3n";
    private static final String ERROR_IMPLEMENTED_CLASS = "Clase indicada no tiene constructor nulo: {0}";
    private static final String ERROR_CASTING_FACTORY = "Clase indicada no es del tipo II18nFactory: {0}";
    private static final String ERROR_NOT_AVALAIBLE_CLASS = "Clase indicada no existe: {0}";
    private static final String ERROR_ACCESING_CLASS = "Clase indicada no es accesible: {0}";
    private static final String ERROR_INSTANTIATION_FACTORY = "Error creando instancia de factor\u00eda de internacionalizaci\u00f3n: {0}";
    private static final String NOT_I18N_MANAGER_CONFIGURATED = "No hay manager de internacionalizaci\u00f3n configurado";
    private static final String NOTAVALAIBLE_FILE_I18N_PROPS = "No hay fichero de configuraci\u00f3n espec\u00edfico";
    private static final String ERROR_INIT_MANAGER = "Error en la inicializaci\u00f3n del manager con el diccionario {0}";
    private static final String ERROR_CASTING_MANAGER = "Clase indicada no es del tipo II18nManager: {0}";
    private static final String ERROR_INSTANTIATION_MANAGER = "Error creando instancia de manager de internacionalizaci\u00f3n: {0}";
    private static Locale locale = null;
    private static II18nFactory factory = null;
    private static Constructor<? extends II18nManager> classManager = null;
    private static HashMap<String, ManagerCached> cache = new HashMap();

    static {
        Properties rb = null;
        try {
            InputStream is = I18nFactory.getClassLoader().getResourceAsStream(PATH_RES_I18N_PROPS);
            if (is != null) {
                rb = new Properties();
                rb.load(is);
            } else {
                LOG.trace(NOTAVALAIBLE_FILE_I18N_PROPS);
            }
        }
        catch (IOException ex) {
            LOG.trace(NOTAVALAIBLE_FILE_I18N_PROPS);
        }
        I18nFactory.loadFactory(rb);
        if (factory == null && rb != null) {
            String classnameManager = rb.getProperty(CLASS_MANAGER);
            if (classnameManager != null) {
                if (STRING_EMPTY.equals(classnameManager.trim())) {
                    classnameManager = null;
                } else {
                    I18nFactory.loadManager(classnameManager);
                }
            }
            if (classManager == null) {
                LOG.trace(NOT_I18N_MANAGER_CONFIGURATED);
            }
            I18nFactory.loadLocale(rb);
        }
    }

    protected I18nFactory() {
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return I18nFactory.class.getClassLoader();
    }

    private static void loadFactory(Properties rb) {
        if (rb != null) {
            String classname = rb.getProperty(CLASS_FACTORY);
            if (classname != null && !STRING_EMPTY.equals(classname.trim())) {
                try {
                    Method method;
                    Class<II18nFactory> returnType;
                    ClassLoader cl = I18nFactory.getClassLoader();
                    Class<?> classFactory = null;
                    classFactory = cl != null ? cl.loadClass(classname) : Class.forName(classname);
                    if (classFactory != null && (returnType = (method = classFactory.getDeclaredMethod(METHOD_NEW_INSTANCE, new Class[0])).getReturnType()) != null && returnType.isAssignableFrom(II18nFactory.class)) {
                        factory = (II18nFactory)method.invoke(null, new Object[0]);
                    }
                }
                catch (IllegalAccessException ex) {
                    LOG.error(I18nFactory.getFormatedMessage(ERROR_ACCESING_CLASS, classname), ex);
                }
                catch (ClassNotFoundException ex) {
                    LOG.error(I18nFactory.getFormatedMessage(ERROR_NOT_AVALAIBLE_CLASS, classname), ex);
                }
                catch (ClassCastException ex) {
                    LOG.error(I18nFactory.getFormatedMessage(ERROR_CASTING_FACTORY, classname), ex);
                }
                catch (SecurityException ex) {
                    LOG.error(I18nFactory.getFormatedMessage(ERROR_ACCESING_CLASS, classname), ex);
                }
                catch (NoSuchMethodException ex) {
                    LOG.error(I18nFactory.getFormatedMessage(ERROR_IMPLEMENTED_CLASS, classname), ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error(I18nFactory.getFormatedMessage(ERROR_IMPLEMENTED_CLASS, classname), ex);
                }
                catch (InvocationTargetException ex) {
                    LOG.error(I18nFactory.getFormatedMessage(ERROR_INSTANTIATION_FACTORY, classname), ex);
                }
            } else {
                LOG.trace(ERROR_CONFIGURATION_FACTORY);
            }
        }
    }

    private static void loadManager(String classname) {
        try {
            ClassLoader cl = I18nFactory.getClassLoader();
            Class<?> classTemp = null;
            classTemp = cl != null ? cl.loadClass(classname) : Class.forName(classname);
            if (classTemp != null) {
                Class<II18nManager> classI18n = classTemp.asSubclass(II18nManager.class);
                classManager = classI18n.getConstructor(null);
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.error(I18nFactory.getFormatedMessage(ERROR_NOT_AVALAIBLE_CLASS, classname), ex);
        }
        catch (ClassCastException ex) {
            LOG.error(I18nFactory.getFormatedMessage(ERROR_CASTING_FACTORY, classname), ex);
        }
        catch (SecurityException ex) {
            LOG.error(I18nFactory.getFormatedMessage(ERROR_ACCESING_CLASS, classname), ex);
        }
        catch (NoSuchMethodException ex) {
            LOG.error(I18nFactory.getFormatedMessage(ERROR_IMPLEMENTED_CLASS, classname), ex);
        }
        catch (IllegalArgumentException ex) {
            LOG.error(I18nFactory.getFormatedMessage(ERROR_IMPLEMENTED_CLASS, classname), ex);
        }
    }

    private static void loadLocale(Properties rb) {
        if (rb != null) {
            String localeStr = rb.getProperty(LOCALE_DEFAULT);
            if (localeStr != null && !STRING_EMPTY.equals(localeStr.trim())) {
                StringTokenizer st = new StringTokenizer(localeStr, STRING_SPACE);
                switch (st.countTokens()) {
                    case 1: {
                        I18nFactory.setLocale(new Locale(st.nextToken()));
                        break;
                    }
                    case 2: {
                        I18nFactory.setLocale(new Locale(st.nextToken(), st.nextToken()));
                        break;
                    }
                    case 3: {
                        I18nFactory.setLocale(new Locale(st.nextToken(), st.nextToken(), st.nextToken()));
                        break;
                    }
                    default: {
                        LOG.warn(WARN_UNKNOWN_LOCALE);
                        I18nFactory.setLocale(null);
                        break;
                    }
                }
            } else {
                I18nFactory.setLocale(null);
                LOG.trace(NOT_CONFIGURATED_LOCALE);
            }
        } else {
            I18nFactory.setLocale(null);
        }
    }

    public static II18nManager getI18nManager(String dictionary) {
        return I18nFactory.getI18nManager(dictionary, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static II18nManager getI18nManager(String dictionary, Locale specificLocale) {
        if (factory != null) {
            return factory.getI18nManager(dictionary, specificLocale);
        }
        HashMap<String, ManagerCached> hashMap = cache;
        synchronized (hashMap) {
            ManagerCached mc = cache.get(dictionary);
            if (mc == null || !mc.isSameLocale(specificLocale)) {
                mc = new ManagerCached(I18nFactory.instantiateManager(dictionary, specificLocale), specificLocale);
                cache.put(dictionary, mc);
            }
            return mc.getI18nCached();
        }
    }

    private static II18nManager instantiateManager(String dictionary, Locale specificLocale) {
        II18nManager manager = null;
        if (classManager != null) {
            try {
                manager = classManager.newInstance(new Object[0]);
            }
            catch (InstantiationException ex) {
                LOG.error(I18nFactory.getFormatedMessage(ERROR_INSTANTIATION_MANAGER, classManager), ex);
                manager = new I18nDumbManager();
            }
            catch (IllegalAccessException ex) {
                LOG.error(I18nFactory.getFormatedMessage(ERROR_ACCESING_CLASS, classManager), ex);
                manager = new I18nDumbManager();
            }
            catch (ClassCastException ex) {
                LOG.error(I18nFactory.getFormatedMessage(ERROR_CASTING_MANAGER, classManager), ex);
                manager = new I18nDumbManager();
            }
            catch (SecurityException ex) {
                LOG.error(I18nFactory.getFormatedMessage(ERROR_ACCESING_CLASS, classManager), ex);
                manager = new I18nDumbManager();
            }
            catch (IllegalArgumentException ex) {
                LOG.error(I18nFactory.getFormatedMessage(ERROR_IMPLEMENTED_CLASS, classManager), ex);
                manager = new I18nDumbManager();
            }
            catch (InvocationTargetException ex) {
                LOG.error(I18nFactory.getFormatedMessage(ERROR_INSTANTIATION_MANAGER, classManager), ex);
                manager = new I18nDumbManager();
            }
        } else {
            manager = new I18nDefaultManager();
        }
        try {
            manager.init(dictionary, specificLocale);
        }
        catch (DictionaryUnknownException ex) {
            LOG.error(I18nFactory.getFormatedMessage(ERROR_INIT_MANAGER, dictionary), ex);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale newLocale) {
        Class<I18nFactory> clazz = I18nFactory.class;
        synchronized (I18nFactory.class) {
            locale = newLocale;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String getFormatedMessage(String message, Object ... varargs) {
        MessageFormat mf = new MessageFormat(message);
        return mf.format(varargs, new StringBuffer(), (FieldPosition)null).toString();
    }
}

