/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pass;

import es.mityc.javasign.pass.IPassSecurity;
import es.mityc.javasign.pass.PassSecurityException;
import es.mityc.javasign.utils.HexUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PBESecurity
implements IPassSecurity {
    private static final Log LOGGER = LogFactory.getLog(PBESecurity.class);
    private static final String CONFIG_SEC_CLIENT = "config/security";
    private static final String PROP_SEC_SALT = "simplePBE.salt";
    private static final String PROP_SEC_ITERATION = "simplePBE.iteration";
    private static final String PROP_SEC_MASTERKEY = "simplePBE.masterkey";
    private byte[] salt = null;
    private int iter = 0;
    private transient String masterPass = null;

    public PBESecurity() throws PassSecurityException {
        this.init();
    }

    public PBESecurity(byte[] saltBase, int iteration, String password) throws PassSecurityException {
        this.salt = saltBase;
        this.iter = iteration;
        this.masterPass = new String(password);
    }

    public PBESecurity(Properties props) throws PassSecurityException {
        this.init(props);
    }

    protected void init() throws PassSecurityException {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(CONFIG_SEC_CLIENT);
            this.init(rb);
        }
        catch (MissingResourceException ex) {
            LOGGER.warn("Fichero de configuraci\u00f3n de seguridad tiene datos err\u00f3neos");
            LOGGER.trace(ex.getMessage(), ex);
            throw new PassSecurityException("Recurso de configuraci\u00f3n no disponible: " + ex.getKey());
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Fichero de configuraci\u00f3n de seguridad tiene datos err\u00f3neos");
            LOGGER.trace(ex.getMessage(), ex);
            throw new PassSecurityException("Formato num\u00e9rico inadecuado: " + ex.getMessage());
        }
    }

    protected void init(ResourceBundle rb) throws PassSecurityException {
        try {
            this.init(rb.getString(PROP_SEC_SALT), rb.getString(PROP_SEC_ITERATION), rb.getString(PROP_SEC_MASTERKEY));
        }
        catch (MissingResourceException ex) {
            LOGGER.warn("Fichero de configuraci\u00f3n de seguridad tiene datos err\u00f3neos");
            LOGGER.trace(ex.getMessage(), ex);
            throw new PassSecurityException("Recurso de configuraci\u00f3n no disponible: " + ex.getKey());
        }
    }

    protected void init(Properties props) throws PassSecurityException {
        try {
            this.init(props.getProperty(PROP_SEC_SALT), props.getProperty(PROP_SEC_ITERATION), props.getProperty(PROP_SEC_MASTERKEY));
        }
        catch (NullPointerException ex) {
            LOGGER.warn("Fichero de configuraci\u00f3n de seguridad tiene datos err\u00f3neos");
            LOGGER.trace(ex.getMessage(), ex);
            throw new PassSecurityException("Recurso de configuraci\u00f3n no disponible");
        }
    }

    protected void init(String saltStr, String iterStr, String passStr) throws PassSecurityException {
        LOGGER.trace("Inicializando objeto de seguridad");
        try {
            this.salt = HexUtils.convert(saltStr);
            this.iter = Integer.parseInt(iterStr);
            this.masterPass = new String(passStr);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Fichero de configuraci\u00f3n de seguridad tiene datos err\u00f3neos");
            LOGGER.trace(ex.getMessage(), ex);
            throw new PassSecurityException("Formato num\u00e9rico inadecuado: " + ex.getMessage());
        }
    }

    @Override
    public String protect(String pass) throws PassSecurityException {
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(this.salt, this.iter);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(this.masterPass.toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] cleartext = pass.getBytes();
            byte[] ciphertext = pbeCipher.doFinal(cleartext);
            return this.hexData(ciphertext);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PassSecurityException(ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new PassSecurityException(ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new PassSecurityException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new PassSecurityException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new PassSecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new PassSecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new PassSecurityException(ex);
        }
    }

    public String hexData(byte[] data) {
        StringBuffer sb = new StringBuffer("{");
        sb.append(HexUtils.convert(data)).append("}");
        return sb.toString();
    }

    @Override
    public String recover(String pass) throws PassSecurityException {
        if (pass.startsWith("{")) {
            String dataStr = pass.substring(1, pass.indexOf("}"));
            byte[] data = HexUtils.convert(dataStr);
            try {
                PBEParameterSpec pbeParamSpec = new PBEParameterSpec(this.salt, this.iter);
                PBEKeySpec pbeKeySpec = new PBEKeySpec(this.masterPass.toCharArray());
                SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
                SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
                Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
                pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
                byte[] ciphertext = pbeCipher.doFinal(data);
                return new String(ciphertext);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new PassSecurityException(ex);
            }
            catch (InvalidKeySpecException ex) {
                throw new PassSecurityException(ex);
            }
            catch (NoSuchPaddingException ex) {
                throw new PassSecurityException(ex);
            }
            catch (InvalidKeyException ex) {
                throw new PassSecurityException(ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new PassSecurityException(ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new PassSecurityException(ex);
            }
            catch (BadPaddingException ex) {
                throw new PassSecurityException(ex);
            }
        }
        return pass;
    }
}

