/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pass;

import es.mityc.javasign.pass.IPassSecurity;
import es.mityc.javasign.pass.PassSecurityException;
import es.mityc.javasign.pass.PassSecurityFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProtectPass {
    private static final Log LOGGER = LogFactory.getLog(ProtectPass.class);

    private ProtectPass() {
    }

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            System.out.println("Recuperando ofuscador " + args[0]);
            try {
                IPassSecurity sec = PassSecurityFactory.getInstance().getPassSecurityManager(args[0], false);
                if (sec == null) {
                    System.out.println("No se encuentra el ofuscador indicado");
                } else {
                    String res = sec.protect(args[0]);
                    System.out.println("Contrase\u00f1a protegida: " + res);
                    String orig = sec.recover(res);
                    if (orig == null || args[0].compareTo(orig) != 0) {
                        LOGGER.fatal("Error en el proceso de seguridad. Contrase\u00f1a protegida no es equivalente a contrase\u00f1a proporcionada.");
                        System.out.println("Error en el proceso de seguridad. Contrase\u00f1a protegida no es equivalente a contrase\u00f1a proporcionada.");
                    }
                }
            }
            catch (PassSecurityException ex) {
                LOGGER.fatal("Error preparando configuraci\u00f3n de seguridad: " + ex.getMessage());
                LOGGER.debug("", ex);
                System.out.println("Error no esperado preparando configuraci\u00f3n de seguridad: " + ex.getMessage());
            }
        } else {
            System.out.println("Ejemplo de uso:");
            System.out.println("   ProtectPass <id_ofuscador> <contrase\u00f1a>");
            System.out.println("         id_ofuscador  identificador del ofuscador");
            System.out.println("         contrase\u00f1a    contrase\u00f1a que se quiere proteger");
        }
    }
}

