/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public final class CertUtil {
    private CertUtil() {
    }

    public static String extractName(X500Principal dname) {
        return CertUtil.extractName(dname.getName());
    }

    public static String extractName(String dname) {
        String res = null;
        String[] col = CertUtil.splitAttributes(dname);
        res = CertUtil.searchAttribute(col, "CN");
        if (res == null) {
            res = CertUtil.searchAttribute(col, "OU");
        }
        if (res == null) {
            res = CertUtil.searchAttribute(col, "O");
        }
        return res;
    }

    private static String searchAttribute(String[] col, String att) {
        String res = null;
        String attmod = String.valueOf(att.toLowerCase()) + "=";
        int i = 0;
        while (i < col.length) {
            if (col[i].trim().toLowerCase().startsWith(attmod)) {
                res = col[i].trim().substring(attmod.length());
                break;
            }
            ++i;
        }
        return res;
    }

    private static String[] splitAttributes(String dname) {
        ArrayList<String> results = new ArrayList<String>();
        String[] col = dname.split(",");
        int i = 0;
        while (i < col.length) {
            String piece = col[i];
            while (i < col.length - 1) {
                if (col[i + 1].contains("=")) break;
                piece = String.valueOf(piece) + "," + col[++i];
            }
            results.add(piece);
            ++i;
        }
        return results.toArray(new String[0]);
    }

    public static String convertDate(Date date) {
        DateFormat formatoFecha = DateFormat.getDateInstance(3);
        String fecha = formatoFecha.format(date);
        return fecha.replace("/", "-");
    }
}

