/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore.PKHandlers;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.DefaultPassStoreKS;
import es.mityc.javasign.pkstore.mitycstore.CertUtil;
import java.security.cert.X509Certificate;

public class CachedPassHandler
extends DefaultPassStoreKS {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private String pinMessage = I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.pin");
    private transient char[] pass = null;

    @Override
    public char[] getPassword(X509Certificate certificate, String alias) {
        if (this.pass == null) {
            this.pass = super.getPassword(certificate, alias);
        }
        return this.pass;
    }

    @Override
    protected void processData(X509Certificate certificate, String alias) {
        if (certificate == null && alias == null) {
            this.setPINMessage(I18N.getLocalMessage("i18n.mityc.cert.mityc.86"));
            this.setCancelBtnVisible(false);
        } else if (alias != null) {
            this.setPINMessage(String.valueOf(this.pinMessage) + " " + alias);
        } else {
            this.setPINMessage(String.valueOf(this.pinMessage) + " " + CertUtil.extractName(certificate.getSubjectX500Principal()));
        }
    }

    public void reset() {
        this.pass = null;
    }
}

