/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.FakedTrustException;
import es.mityc.javasign.trust.NotTrustedException;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustAdapter;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.TrustFactory;
import es.mityc.javasign.trust.UnknownTrustException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.encoders.Base64;

public class PropsTruster
extends TrustAdapter {
    private static final Log LOG = LogFactory.getLog(PropsTruster.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibTrust");
    private static final String CONF_DEFAULT = "trust/myTruster.properties";
    protected Properties externalProps = new Properties();
    protected static TrustAdapter instance;
    private CertStore issuersCerts;
    private CertStore certsCerts;
    private CertStore issuersOCSP;
    private CertStore certsOCSP;
    private CertStore issuersCRL;
    private CertStore issuersTSA;
    private CertStore certsTSA;

    protected PropsTruster(String fileconf) {
        this.loadConf(fileconf, new Properties());
    }

    protected PropsTruster(String fileconf, InputStream extFileConf) {
        this.loadConf(fileconf, extFileConf);
    }

    protected synchronized void loadConf(String fileconf, InputStream extConf) {
        Properties extProps = null;
        if (extConf != null) {
            try {
                extProps = new Properties();
                extProps.load(extConf);
            }
            catch (IOException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.1", extConf));
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ex);
                }
            }
        } else {
            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.1", extConf));
        }
        this.loadConf(fileconf, extProps);
    }

    protected synchronized void loadConf(String fileconf, Properties extProperties) {
        block7: {
            this.externalProps = extProperties;
            Properties internalProps = null;
            try {
                ClassLoader cl = PropsTruster.getClassLoader();
                InputStream is = cl.getResourceAsStream(fileconf);
                if (is != null) {
                    internalProps = new Properties();
                    internalProps.load(is);
                } else {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.1", fileconf));
                }
            }
            catch (IOException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.1", fileconf));
            }
            if (internalProps != null) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    this.issuersCerts = this.loadCerts(cf, internalProps, this.externalProps, TrusterType.TRUSTER_SIGNCERTS_ISSUER);
                    this.certsCerts = this.loadCerts(cf, internalProps, this.externalProps, TrusterType.TRUSTER_SIGNCERTS_CERTS);
                    this.issuersOCSP = this.loadCerts(cf, internalProps, this.externalProps, TrusterType.TRUSTER_OCSP_ISSUER);
                    this.certsOCSP = this.loadCerts(cf, internalProps, this.externalProps, TrusterType.TRUSTER_OCSP_CERTS);
                    this.issuersCRL = this.loadCerts(cf, internalProps, this.externalProps, TrusterType.TRUSTER_CRL_ISSUER);
                    this.issuersTSA = this.loadCerts(cf, internalProps, this.externalProps, TrusterType.TRUSTER_TSA_ISSUER);
                    this.certsTSA = this.loadCerts(cf, internalProps, this.externalProps, TrusterType.TRUSTER_TSA_CERTS);
                }
                catch (CertificateException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.9", ex.getMessage()));
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("", ex);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void isTrusted(X509CRL crl) throws TrustException {
        block15: {
            if (this.issuersCRL == null) break block15;
            faked = false;
            certSelector = new X509CertSelector();
            certSelector.setSubject(crl.getIssuerX500Principal());
            try {
                it = this.issuersCRL.getCertificates(certSelector).iterator();
                if (true) ** GOTO lbl40
            }
            catch (CertStoreException ex) {
                PropsTruster.LOG.error(PropsTruster.I18N.getLocalMessage("i18n.mityc.trust.props.21", new Object[]{ex.getMessage()}));
                if (PropsTruster.LOG.isDebugEnabled()) {
                    PropsTruster.LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            do {
                issuer = (X509Certificate)it.next();
                try {
                    crl.verify(issuer.getPublicKey());
                    return;
                }
                catch (InvalidKeyException ex) {
                    PropsTruster.LOG.error(PropsTruster.I18N.getLocalMessage("i18n.mityc.trust.props.2", new Object[]{ex.getMessage()}));
                    if (PropsTruster.LOG.isDebugEnabled()) {
                        PropsTruster.LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (CRLException ex) {
                    PropsTruster.LOG.error(PropsTruster.I18N.getLocalMessage("i18n.mityc.trust.props.3", new Object[]{ex.getMessage()}));
                    if (PropsTruster.LOG.isDebugEnabled()) {
                        PropsTruster.LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchAlgorithmException ex) {
                    PropsTruster.LOG.error(PropsTruster.I18N.getLocalMessage("i18n.mityc.trust.props.4", new Object[]{ex.getMessage()}));
                    if (PropsTruster.LOG.isDebugEnabled()) {
                        PropsTruster.LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchProviderException ex) {
                    PropsTruster.LOG.error(PropsTruster.I18N.getLocalMessage("i18n.mityc.trust.props.5", new Object[]{ex.getMessage()}));
                    if (PropsTruster.LOG.isDebugEnabled()) {
                        PropsTruster.LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (SignatureException ex) {
                    faked = true;
                }
lbl40:
                // 2 sources

            } while (it.hasNext());
            if (faked) {
                throw new FakedTrustException();
            }
            throw new NotTrustedException();
        }
        throw new UnknownTrustException();
    }

    @Override
    public void isTrusted(OCSPResp ocsp) throws TrustException {
        BasicOCSPResp basicResp = null;
        try {
            basicResp = (BasicOCSPResp)ocsp.getResponseObject();
        }
        catch (OCSPException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.11", ex.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("", ex);
            }
            throw new UnknownTrustException();
        }
        if (this.certsOCSP != null) {
            X509Certificate[] certs;
            X509CertSelector certSelector = null;
            try {
                certs = basicResp.getCerts("SUN");
            }
            catch (NoSuchProviderException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.12", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            catch (OCSPException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.12", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            if (certs != null && certs.length > 0) {
                certSelector = new X509CertSelector();
                certSelector.setSubjectPublicKey(certs[0].getPublicKey());
            } else {
                ResponderID responderId = basicResp.getResponderId().toASN1Object();
                if (responderId != null) {
                    ASN1TaggedObject tagged = (ASN1TaggedObject)responderId.toASN1Object();
                    switch (tagged.getTagNo()) {
                        case 1: {
                            X509Principal cerX509Principal = new X509Principal(X509Name.getInstance(tagged.getObject()).toString());
                            X500Principal cerX500Principal = new X500Principal(cerX509Principal.getDEREncoded());
                            certSelector = new X509CertSelector();
                            certSelector.setSubject(cerX500Principal);
                            break;
                        }
                        case 2: {
                            ASN1OctetString octect = (ASN1OctetString)tagged.getObject();
                            certSelector = new X509CertSelector();
                            try {
                                certSelector.setSubjectPublicKey(octect.getOctets());
                                break;
                            }
                            catch (IOException ex) {
                                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.13", ex.getMessage()));
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("", ex);
                                }
                                throw new UnknownTrustException();
                            }
                        }
                        default: {
                            throw new UnknownTrustException();
                        }
                    }
                }
            }
            if (certSelector != null) {
                Iterator<? extends Certificate> it;
                try {
                    it = this.certsOCSP.getCertificates(certSelector).iterator();
                }
                catch (CertStoreException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.22", ex.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                if (it.hasNext()) {
                    X509Certificate cert = (X509Certificate)it.next();
                    try {
                        if (basicResp.verify(cert.getPublicKey(), "SunRsaSign")) {
                            return;
                        }
                        throw new FakedTrustException();
                    }
                    catch (OCSPException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.15", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (NoSuchProviderException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.14", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                }
            }
        }
        if (this.issuersOCSP != null) {
            X509Certificate[] certs;
            try {
                certs = basicResp.getCerts("SUN");
            }
            catch (NoSuchProviderException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.12", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            catch (OCSPException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.12", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            if (certs == null || certs.length == 0) {
                throw new UnknownTrustException();
            }
            this.validateIssuer(certs, this.issuersOCSP);
            try {
                if (basicResp.verify(certs[0].getPublicKey(), "SunRsaSign")) {
                    return;
                }
                throw new FakedTrustException();
            }
            catch (OCSPException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.15", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            catch (NoSuchProviderException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.14", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
        }
        throw new NotTrustedException();
    }

    private void validateIssuer(X509Certificate[] certs, CertStore store) throws UnknownTrustException, NotTrustedException {
        int i = 0;
        while (i < certs.length) {
            Collection<? extends Certificate> certsCollection;
            X509CertSelector certSelector = new X509CertSelector();
            if (certs.length > i + 1) {
                certSelector.setSubjectPublicKey(certs[i + 1].getPublicKey());
            } else {
                certSelector.setSubject(certs[i].getIssuerX500Principal());
            }
            try {
                certsCollection = store.getCertificates(certSelector);
            }
            catch (CertStoreException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.22", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            if (certsCollection.size() > 0) {
                for (X509Certificate x509Certificate : certsCollection) {
                    try {
                        certs[i].verify(x509Certificate.getPublicKey());
                        return;
                    }
                    catch (InvalidKeyException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (CertificateException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (NoSuchAlgorithmException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (NoSuchProviderException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (SignatureException signatureException) {
                        // empty catch block
                    }
                }
                throw new FakedTrustException();
            }
            if (i + 1 < certs.length) {
                try {
                    certs[i].verify(certs[i + 1].getPublicKey());
                }
                catch (InvalidKeyException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (CertificateException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchProviderException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.23", ex.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (SignatureException ex) {
                    throw new FakedTrustException();
                }
            } else {
                throw new NotTrustedException();
            }
            ++i;
        }
        throw new NotTrustedException();
    }

    @Override
    public void isTrusted(CertPath certs) throws TrustException {
        if (certs == null || certs.getCertificates().size() == 0) {
            throw new UnknownTrustException();
        }
        if (this.certsCerts != null) {
            X509Certificate cert = (X509Certificate)certs.getCertificates().get(0);
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setCertificate(cert);
            Collection<? extends Certificate> certsCollection = null;
            try {
                certsCollection = this.certsCerts.getCertificates(certSelector);
            }
            catch (CertStoreException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.24", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            if (certsCollection.size() > 0) {
                return;
            }
        }
        if (this.issuersCerts != null) {
            X509Certificate[] list = certs.getCertificates().toArray(new X509Certificate[0]);
            this.validateIssuer(list, this.issuersCerts);
            return;
        }
        throw new NotTrustedException();
    }

    @Override
    public void isTrusted(TimeStampToken tst) throws TrustException {
        if (this.certsTSA != null) {
            SignerId sid = tst.getSID();
            if (sid != null) {
                Iterator<? extends Certificate> it;
                Collection<? extends Certificate> certsColl;
                try {
                    certsColl = this.certsTSA.getCertificates(sid);
                }
                catch (CertStoreException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.25", ex.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", ex);
                    }
                    throw new UnknownTrustException();
                }
                if (certsColl.size() > 0 && (it = certsColl.iterator()).hasNext()) {
                    X509Certificate cert = (X509Certificate)it.next();
                    try {
                        tst.validate(cert, "SunRsaSign");
                        return;
                    }
                    catch (CertificateExpiredException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.26"), ex);
                        throw new NotTrustedException(I18N.getLocalMessage("i18n.mityc.trust.props.26"));
                    }
                    catch (CertificateNotYetValidException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.26"), ex);
                        throw new NotTrustedException(I18N.getLocalMessage("i18n.mityc.trust.props.26"));
                    }
                    catch (TSPValidationException ex) {
                        throw new FakedTrustException();
                    }
                    catch (NoSuchProviderException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.6", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (TSPException ex) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.7", ex.getMessage()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", ex);
                        }
                        throw new UnknownTrustException();
                    }
                }
            } else {
                throw new UnknownTrustException();
            }
        }
        if (this.issuersTSA != null) {
            X509Certificate[] certs;
            try {
                certs = tst.getCertificatesAndCRLs("Collection", null).getCertificates(null).toArray(new X509Certificate[0]);
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.19", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            catch (NoSuchProviderException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.19", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            catch (CMSException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.19", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            catch (CertStoreException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.25", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            if (certs == null || certs.length == 0) {
                throw new UnknownTrustException();
            }
            this.validateIssuer(certs, this.issuersTSA);
            try {
                tst.validate(certs[0], "SunRsaSign");
                return;
            }
            catch (CertificateExpiredException ex) {
            }
            catch (CertificateNotYetValidException ex) {
            }
            catch (TSPValidationException ex) {
                throw new FakedTrustException();
            }
            catch (NoSuchProviderException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.6", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
            catch (TSPException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.7", ex.getMessage()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", ex);
                }
                throw new UnknownTrustException();
            }
        }
        throw new NotTrustedException();
    }

    public static TrustAdapter getInstance() {
        if (instance == null) {
            instance = new PropsTruster(CONF_DEFAULT, null);
        }
        return instance;
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TrustFactory.class.getClassLoader();
    }

    private CertStore loadCerts(CertificateFactory cf, Properties internalProps, Properties externalProps, TrusterType trusterType) {
        CertStore cs;
        block42: {
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            if (internalProps != null) {
                ClassLoader cl = PropsTruster.getClassLoader();
                Enumeration<?> en = internalProps.propertyNames();
                while (en.hasMoreElements()) {
                    String propName = (String)en.nextElement();
                    if (!propName.startsWith(trusterType.toString())) continue;
                    try {
                        String value = internalProps.getProperty(propName);
                        StringTokenizer st = new StringTokenizer(value, ",");
                        while (st.hasMoreTokens()) {
                            String res = st.nextToken();
                            InputStream is = cl.getResourceAsStream(res);
                            if (is != null) {
                                try {
                                    list.add((X509Certificate)cf.generateCertificate(is));
                                }
                                catch (CertificateException ex) {
                                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.10", ex.getMessage()));
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug("", ex);
                                }
                                continue;
                            }
                            LOG.warn(I18N.getLocalMessage("i18n.mityc.trust.props.8", res));
                        }
                    }
                    catch (MissingResourceException value) {
                        // empty catch block
                    }
                }
            }
            if (externalProps != null) {
                Enumeration<?> en = externalProps.propertyNames();
                while (en.hasMoreElements()) {
                    String propName = (String)en.nextElement();
                    if (!propName.startsWith(trusterType.toString())) continue;
                    try {
                        String value = externalProps.getProperty(propName);
                        StringTokenizer st = new StringTokenizer(value, ",");
                        String res = null;
                        FileInputStream fis = null;
                        while (st.hasMoreTokens()) {
                            res = st.nextToken();
                            fis = new FileInputStream(res);
                            try {
                                ByteArrayOutputStream baos;
                                try {
                                    list.add((X509Certificate)cf.generateCertificate(fis));
                                    continue;
                                }
                                catch (CertificateException ex) {
                                    baos = null;
                                    try {
                                        try {
                                            fis.reset();
                                            baos = new ByteArrayOutputStream(fis.available());
                                            byte[] array = new byte[1000];
                                            int leidos = fis.read(array);
                                            while (leidos > 0) {
                                                baos.write(array, 0, leidos);
                                                leidos = fis.read(array);
                                            }
                                            ByteArrayInputStream b64 = new ByteArrayInputStream(Base64.encode(baos.toByteArray()));
                                            list.add((X509Certificate)cf.generateCertificate(b64));
                                        }
                                        catch (Exception ex2) {
                                            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.10", ex.getMessage()));
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug("", ex);
                                                LOG.debug("", ex2);
                                            }
                                            try {
                                                baos.close();
                                            }
                                            catch (Exception exception) {}
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            baos.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        throw throwable;
                                    }
                                }
                                try {
                                    baos.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            finally {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    catch (MissingResourceException ex) {
                        LOG.warn(I18N.getLocalMessage("i18n.mityc.trust.props.8", ex.getMessage()));
                    }
                    catch (FileNotFoundException e) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.10", e.getMessage()));
                    }
                }
            }
            cs = null;
            if (list.size() > 0) {
                try {
                    cs = CertStore.getInstance("Collection", new CollectionCertStoreParameters(list));
                }
                catch (InvalidAlgorithmParameterException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.20", ex.getMessage()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", ex);
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.trust.props.20", ex.getMessage()));
                    if (!LOG.isDebugEnabled()) break block42;
                    LOG.debug("", ex);
                }
            }
        }
        return cs;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CertPath getCertPath(X509Certificate cert) throws UnknownTrustException {
        certsChain = new Vector<X509Certificate>();
        certsChain.add(cert);
        arrayStores = new ArrayList<CertStore>();
        arrayStores.add(this.issuersCerts);
        arrayStores.add(this.certsCerts);
        arrayStores.add(this.issuersOCSP);
        arrayStores.add(this.certsOCSP);
        arrayStores.add(this.issuersCRL);
        arrayStores.add(this.issuersTSA);
        arrayStores.add(this.certsTSA);
        certSelector = new X509CertSelector();
        cs = null;
        certToValidate = cert;
        issuer = null;
        it = null;
        chainCompleted = false;
        i = 0;
        while (i < arrayStores.size() && !chainCompleted) {
            cs = (CertStore)arrayStores.get(i);
            chainLenght = 0;
            block9: while (chainLenght != certsChain.size() && cs != null) {
                chainLenght = certsChain.size();
                try {
                    certToValidate.verify(certToValidate.getPublicKey());
                    chainCompleted = true;
                    break;
                }
                catch (Exception var12_16) {
                    certSelector.setSubject(certToValidate.getIssuerX500Principal());
                    try {
                        preselCerts = cs.getCertificates(certSelector);
                        if (preselCerts == null) continue;
                        it = preselCerts.iterator();
                        if (true) ** GOTO lbl54
                    }
                    catch (CertStoreException ex) {
                        throw new UnknownTrustException();
                    }
                }
                do {
                    issuer = (X509Certificate)it.next();
                    try {
                        certToValidate.verify(issuer.getPublicKey());
                        certsChain.add(issuer);
                        certToValidate = issuer;
                        continue block9;
                    }
                    catch (Exception var12_18) {
                        // empty catch block
                    }
lbl54:
                    // 2 sources

                } while (it.hasNext());
            }
            ++i;
        }
        if (!chainCompleted) {
            throw new UnknownTrustException(PropsTruster.I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{String.valueOf(cert.getSubjectX500Principal().getName()) + " -issuer:  " + cert.getIssuerDN()}));
        }
        cp = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            cp = cf.generateCertPath(certsChain);
        }
        catch (CertificateException ex) {
            throw new UnknownTrustException();
        }
        return cp;
    }

    public Vector<X509Certificate> getTrustedCAs(TrusterType type) {
        Vector<X509Certificate> trustedCerts = new Vector<X509Certificate>();
        if (type == null) {
            trustedCerts.addAll(this.extractAllCerts(this.certsCerts));
            trustedCerts.addAll(this.extractAllCerts(this.issuersCerts));
            trustedCerts.addAll(this.extractAllCerts(this.certsOCSP));
            trustedCerts.addAll(this.extractAllCerts(this.issuersOCSP));
            trustedCerts.addAll(this.extractAllCerts(this.certsTSA));
            trustedCerts.addAll(this.extractAllCerts(this.issuersTSA));
            trustedCerts.addAll(this.extractAllCerts(this.issuersCRL));
        } else if (TrusterType.TRUSTER_SIGNCERTS_CERTS.equals((Object)type)) {
            trustedCerts.addAll(this.extractAllCerts(this.certsCerts));
        } else if (TrusterType.TRUSTER_SIGNCERTS_ISSUER.equals((Object)type)) {
            trustedCerts.addAll(this.extractAllCerts(this.issuersCerts));
        } else if (TrusterType.TRUSTER_OCSP_CERTS.equals((Object)type)) {
            trustedCerts.addAll(this.extractAllCerts(this.certsOCSP));
        } else if (TrusterType.TRUSTER_OCSP_ISSUER.equals((Object)type)) {
            trustedCerts.addAll(this.extractAllCerts(this.issuersOCSP));
        } else if (TrusterType.TRUSTER_TSA_CERTS.equals((Object)type)) {
            trustedCerts.addAll(this.extractAllCerts(this.certsTSA));
        } else if (TrusterType.TRUSTER_TSA_ISSUER.equals((Object)type)) {
            trustedCerts.addAll(this.extractAllCerts(this.issuersTSA));
        } else if (TrusterType.TRUSTER_CRL_ISSUER.equals((Object)type)) {
            trustedCerts.addAll(this.extractAllCerts(this.issuersCRL));
        } else {
            LOG.debug("No se reconoci\u00f3 el tipo indicado: " + (Object)((Object)type));
        }
        return trustedCerts;
    }

    private Vector<X509Certificate> extractAllCerts(CertStore cs) {
        Vector<X509Certificate> trustedCerts = new Vector<X509Certificate>();
        if (cs != null) {
            Collection<? extends Certificate> certs = null;
            try {
                certs = cs.getCertificates(null);
            }
            catch (CertStoreException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("", e);
                }
                return trustedCerts;
            }
            if (certs != null) {
                Iterator<? extends Certificate> it2 = certs.iterator();
                while (it2.hasNext()) {
                    try {
                        trustedCerts.add((X509Certificate)it2.next());
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("", e);
                    }
                }
            }
        }
        return trustedCerts;
    }

    public static /* bridge */ /* synthetic */ TrustAbstract getInstance() {
        return PropsTruster.getInstance();
    }

    public static enum TrusterType {
        TRUSTER_SIGNCERTS_ISSUER("signcerts.issuers"),
        TRUSTER_SIGNCERTS_CERTS("signcerts.certs"),
        TRUSTER_OCSP_ISSUER("ocsp.issuers"),
        TRUSTER_OCSP_CERTS("ocsp.certs"),
        TRUSTER_CRL_ISSUER("crl.issuers"),
        TRUSTER_TSA_ISSUER("tsa.issuers"),
        TRUSTER_TSA_CERTS("tsa.certs");

        private String id;

        private TrusterType(String key) {
            this.id = key;
        }

        public String toString() {
            return this.id;
        }
    }
}

