/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.ITrustCRLEmisor;
import es.mityc.javasign.trust.ITrustOCSPProducer;
import es.mityc.javasign.trust.ITrustSignCerts;
import es.mityc.javasign.trust.ITrustTSProducer;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustAdapter;
import es.mityc.javasign.trust.TrustFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrustExtendFactory
extends TrustFactory {
    private static final Log LOG = LogFactory.getLog(TrustExtendFactory.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibTrust");
    private static final String TRUSTER_PROPS_SIGNCERTS = ".SignCerts";
    private static final String TRUSTER_PROPS_CRLS = ".CRLEmisor";
    private static final String TRUSTER_PROPS_OCSP = ".OCSPProducer";
    private static final String TRUSTER_PROPS_TSA = ".TSProducer";
    private static final String TRUSTER_PROPS_ALL = ".All";

    protected TrustExtendFactory() {
    }

    protected static TrustFactory newInstance() {
        return new TrustExtendFactory();
    }

    public ITrustSignCerts getSignCertsTruster(String prefix) {
        String clave = prefix != null ? String.valueOf(prefix) + TRUSTER_PROPS_SIGNCERTS : TRUSTER_PROPS_SIGNCERTS;
        TrustAbstract res = this.getTrusterSuper(clave);
        if (res != null) {
            if (res instanceof ITrustSignCerts) {
                return (ITrustSignCerts)((Object)res);
            }
            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.1"));
        }
        return null;
    }

    public ITrustCRLEmisor getCRLTruster(String prefix) {
        String clave = prefix != null ? String.valueOf(prefix) + TRUSTER_PROPS_CRLS : TRUSTER_PROPS_CRLS;
        TrustAbstract res = this.getTrusterSuper(clave);
        if (res != null) {
            if (res instanceof ITrustCRLEmisor) {
                return (ITrustCRLEmisor)((Object)res);
            }
            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.2"));
        }
        return null;
    }

    public ITrustOCSPProducer getOCSPTruster(String prefix) {
        String clave = prefix != null ? String.valueOf(prefix) + TRUSTER_PROPS_OCSP : TRUSTER_PROPS_OCSP;
        TrustAbstract res = this.getTrusterSuper(clave);
        if (res != null) {
            if (res instanceof ITrustOCSPProducer) {
                return (ITrustOCSPProducer)((Object)res);
            }
            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.3"));
        }
        return null;
    }

    public ITrustTSProducer getTSATruster(String prefix) {
        String clave = prefix != null ? String.valueOf(prefix) + TRUSTER_PROPS_TSA : TRUSTER_PROPS_TSA;
        TrustAbstract res = this.getTrusterSuper(clave);
        if (res != null) {
            if (res instanceof ITrustTSProducer) {
                return (ITrustTSProducer)((Object)res);
            }
            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.4"));
        }
        return null;
    }

    public TrustAbstract getTrusterSuper(String key) {
        return super.getTruster(key);
    }

    @Override
    public TrustAbstract getTruster(String key) {
        String clave = key != null ? String.valueOf(key) + TRUSTER_PROPS_ALL : TRUSTER_PROPS_ALL;
        TrustAbstract res = this.getTrusterSuper(clave);
        if (res != null) {
            if (res instanceof TrustAdapter) {
                return (TrustAdapter)res;
            }
            LOG.error(I18N.getLocalMessage("i18n.mityc.trust.4"));
        }
        return null;
    }
}

