/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.ts;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.ts.TimeStampValidator;
import es.mityc.javasign.tsa.TSValidationResult;
import es.mityc.javasign.tsa.TimeStampException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampToken;

public final class ExtractSigner {
    private static final II18nManager i18n = I18nFactory.getI18nManager("MITyCLibTSA");
    private static final int BUFFER_SIZE = 32000;
    private static final String CERT_FILE_NAME = "tsasigner.cer";

    private ExtractSigner() {
    }

    public static void main(String[] args) {
        block17: {
            if (args == null || args.length < 1) {
                System.out.println("Modo de uso:");
                System.out.println("       ExtractSigner  <ts-file>");
                System.out.println("            <ts-file>     Fichero donde se encuentra en sello de tiempo en binario");
            } else {
                try {
                    File file = new File(args[0]);
                    if (file.exists()) {
                        if (file.length() > 32000L) {
                            System.out.println("El fichero indicado es demasiado grande");
                            break block17;
                        }
                        FileInputStream fis = new FileInputStream(file);
                        byte[] ts = new byte[(int)file.length()];
                        fis.read(ts);
                        fis.close();
                        Certificate cert = null;
                        try {
                            Certificate cer;
                            TimeStampValidator tsValidator = new TimeStampValidator();
                            TSValidationResult data = tsValidator.validateTimeStamp(ts, ts);
                            TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(data.getTimeStampRawToken()));
                            CertStore cs = timeStampToken.getCertificatesAndCRLs("Collection", null);
                            Collection<? extends Certificate> certs = cs.getCertificates(null);
                            if (certs.size() > 0 && (cer = certs.iterator().next()) instanceof X509Certificate) {
                                cert = (X509Certificate)cer;
                            }
                        }
                        catch (NoSuchAlgorithmException ex) {
                            System.out.println(i18n.getLocalMessage("i18n.mityc.ts.validate.8", ex.getMessage()));
                        }
                        catch (NoSuchProviderException ex) {
                            System.out.println(i18n.getLocalMessage("i18n.mityc.ts.validate.8", ex.getMessage()));
                        }
                        catch (CertStoreException ex) {
                            System.out.println(i18n.getLocalMessage("i18n.mityc.ts.validate.8", ex.getMessage()));
                        }
                        catch (TimeStampException ex) {
                            System.out.println("Error procesando el sello de tiempo: " + ex.getMessage());
                        }
                        catch (Exception ex) {
                            System.out.println(i18n.getLocalMessage("i18n.mityc.ts.validate.8", ex.getMessage()));
                        }
                        if (cert != null) {
                            FileOutputStream fos = new FileOutputStream(CERT_FILE_NAME, false);
                            fos.write(cert.getEncoded());
                            fos.flush();
                            fos.close();
                            System.out.println("Certificado extraido y disponible en tsasigner.cer");
                        } else {
                            System.out.println("El sello de tiempo no incluye el certificado firmante");
                        }
                        break block17;
                    }
                    System.out.println("El fichero indicado no existe");
                }
                catch (FileNotFoundException ex) {
                    System.out.println("El fichero indicado no existe");
                }
                catch (IOException ex) {
                    System.out.println("Error leyendo el fichero con el sello de tiempo: " + ex.getMessage());
                }
                catch (CertificateEncodingException ex) {
                    System.out.println("Error procesando formato de certificado firmante: " + ex.getMessage());
                }
            }
        }
    }
}

