/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.ts;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.ssl.ISSLManager;
import es.mityc.javasign.ts.AuthenticatorProxyCredentials;
import es.mityc.javasign.ts.OwnSSLProtocolSocketFactory;
import es.mityc.javasign.ts.TSPAlgoritmos;
import es.mityc.javasign.tsa.ITimeStampGenerator;
import es.mityc.javasign.tsa.TimeStampException;
import es.mityc.javasign.utils.ProxyUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;

public class HTTPTimeStampGenerator
implements ITimeStampGenerator {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibTSA");
    private String servidorTSA = null;
    private String algoritmoHash = null;
    private static final Integer INT10000 = new Integer(10000);
    private Integer timeOut = INT10000;
    static Log log = LogFactory.getLog(HTTPTimeStampGenerator.class.getName());

    public HTTPTimeStampGenerator(String nombreServidor, String algoritmoHash) {
        this.servidorTSA = nombreServidor;
        this.algoritmoHash = "SHA-1";
        if (algoritmoHash != null) {
            String temp = algoritmoHash.trim().toUpperCase();
            if (TSPAlgoritmos.getPermitidos().contains(algoritmoHash)) {
                this.algoritmoHash = temp;
            } else {
                log.warn("No se ha encontrado un algoritmo hash v\u00e1lido para el Sello de Tiempo. Se va a utilizar el algoritmo SHA1 por defecto");
            }
        }
    }

    public static void setSSLManager(ISSLManager sslmanager) {
        OwnSSLProtocolSocketFactory ospsf = new OwnSSLProtocolSocketFactory(sslmanager);
        Protocol authhttps = new Protocol("https", ospsf, 443);
        Protocol.registerProtocol("https", authhttps);
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(ospsf.getSSLContext().getSocketFactory());
        }
        catch (IOException e) {
            log.error("Error estableciendo socket factory: " + e.getMessage(), e);
        }
    }

    @Override
    public byte[] generateTimeStamp(byte[] dataToSeal) throws TimeStampException {
        return this.generateTimeStamp(dataToSeal, null);
    }

    /*
     * Loose catch block
     */
    public byte[] generateTimeStamp(byte[] dataToSeal, String idApplication) throws TimeStampException {
        if (dataToSeal == null) {
            log.error("No se han especificado los datos sobre los que generar el sello de tiempo");
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error1"));
        }
        log.info("Se va a generar el sello de tiempo ...");
        HttpClient CLIENTE = new HttpClient();
        TimeStampRequestGenerator generadorPeticion = new TimeStampRequestGenerator();
        generadorPeticion.setCertReq(true);
        if (idApplication != null && idApplication.length() > 0) {
            generadorPeticion.addExtension("1.3.4.6.1.3.4.6", false, idApplication.getBytes());
        }
        TimeStampRequest peticion = null;
        TimeStampResponse respuesta = null;
        CLIENTE.getHttpConnectionManager().closeIdleConnections(100L);
        try {
            MessageDigest resumen = MessageDigest.getInstance(this.algoritmoHash);
            resumen.update(dataToSeal);
            peticion = generadorPeticion.generate(TSPAlgoritmos.getOID(this.algoritmoHash), resumen.digest());
            log.info("Petici\u00f3n TSA generada");
        }
        catch (Exception e) {
            log.error("Ha ocurrido un error al generar la petici\u00f3n TSA", e);
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error10", e.getMessage()));
        }
        CLIENTE.getParams().setParameter("http.socket.timeout", this.timeOut);
        String servidorProxy = System.getProperty("http.proxyHost");
        if (servidorProxy != null) {
            int puertoProxy = 80;
            try {
                puertoProxy = Integer.parseInt(System.getProperty("http.proxyPort"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            CLIENTE.getHostConfiguration().setProxy(servidorProxy, puertoProxy);
            AuthenticatorProxyCredentials defaultcreds = new AuthenticatorProxyCredentials(servidorProxy, "");
            CLIENTE.getState().setProxyCredentials(AuthScope.ANY, defaultcreds);
        }
        PostMethod metodo = new PostMethod(this.servidorTSA);
        metodo.addRequestHeader("Content-Type", "application/timestamp-query");
        ByteArrayInputStream datos = null;
        try {
            datos = new ByteArrayInputStream(peticion.getEncoded());
        }
        catch (IOException e) {
            log.error("Error al leer la petici\u00f3n: " + e.getMessage(), e);
            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error11", e.getMessage()));
        }
        InputStreamRequestEntity rq = new InputStreamRequestEntity(datos);
        metodo.setRequestEntity(rq);
        metodo.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(3, false));
        byte[] cuerpoRespuesta = null;
        try {
            DEREncodable enc;
            block52: {
                block50: {
                    int estadoCodigo = 0;
                    try {
                        estadoCodigo = CLIENTE.executeMethod(metodo);
                        log.info("Petici\u00f3n TSA enviada.");
                    }
                    catch (IOException e) {
                        log.error("Error en la conexi\u00f3n con el servidor TSA: " + e.getMessage());
                        estadoCodigo = 408;
                    }
                    if (estadoCodigo != 200) {
                        log.info("Fallo en consulta TimeStamp: Reintentando v\u00eda HttpPOST");
                        HttpURLConnection conn = null;
                        BufferedReader brr = null;
                        try {
                            try {
                                conn = ProxyUtil.getConnection(this.servidorTSA);
                                conn.setConnectTimeout(5000);
                                conn.setRequestMethod("POST");
                                conn.setRequestProperty("Content-Type", "application/timestamp-query");
                                conn.setRequestProperty("Accept", "application/timestamp-reply");
                                conn.setRequestProperty("Content-Length", String.valueOf(peticion.getEncoded().length));
                                conn.setUseCaches(false);
                                conn.setDoOutput(true);
                                DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                                wr.write(peticion.getEncoded());
                                wr.flush();
                                wr.close();
                                if (conn.getResponseCode() == 200) {
                                    Object response;
                                    if (log.isDebugEnabled()) {
                                        log.debug("Utilizando proxy: " + conn.usingProxy());
                                    }
                                    if ((response = conn.getContent()) != null) {
                                        if (response instanceof InputStream) {
                                            InputStream in = (InputStream)response;
                                            if (in != null && in.available() > 0) {
                                                int b = 0;
                                                cuerpoRespuesta = new byte[in.available()];
                                                int i = 0;
                                                while (b >= 0 && i < cuerpoRespuesta.length) {
                                                    b = in.read();
                                                    cuerpoRespuesta[i] = (byte)b;
                                                    ++i;
                                                }
                                            }
                                        } else {
                                            throw new Exception("Tipo de respuesta inesperada: " + conn.getContentType());
                                        }
                                        if (log.isDebugEnabled()) {
                                            log.debug("Conexi\u00f3n satisfactoria v\u00eda HttpURLConnection");
                                        }
                                        log.info("Respuesta TSA obtenida.");
                                        break block50;
                                    }
                                    throw new Exception("No se obtubo respuesta o se obtuvo una respuesta inesperada: " + conn.getResponseCode());
                                }
                                throw new Exception("Respuesta de error: " + conn.getResponseCode() + " - " + conn.getResponseMessage());
                            }
                            catch (Exception e1) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Conexi\u00f3n fallida v\u00eda HttpURLConnection", e1);
                                }
                                log.error("Fallo la ejecuci\u00f3n del m\u00e9todo: " + metodo.getStatusLine());
                                if (metodo.getStatusLine() != null) {
                                    String m = metodo.getStatusLine().getReasonPhrase();
                                    if (m.contains("\ufffd\ufffd")) {
                                        m = m.replaceAll("\ufffd\ufffd", "\u00f3");
                                    }
                                    throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error12", EncodingUtil.getString(m.getBytes("UTF8"), "UTF8")));
                                }
                                throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error12", metodo.getStatusCode()));
                            }
                        }
                        finally {
                            block51: {
                                if (conn != null) {
                                    conn.disconnect();
                                }
                                if (brr != null) {
                                    try {
                                        brr.close();
                                    }
                                    catch (IOException e1) {
                                        if (!log.isDebugEnabled()) break block51;
                                        log.debug("No se pudo cerrar el canal de escritura", e1);
                                    }
                                }
                            }
                        }
                    }
                    cuerpoRespuesta = metodo.getResponseBody();
                    new String(cuerpoRespuesta);
                    log.info("Respuesta TSA obtenida.");
                }
                respuesta = new TimeStampResponse(cuerpoRespuesta);
                respuesta.validate(peticion);
                log.info("Respuesta TSA validada OK");
                ASN1InputStream is = new ASN1InputStream(cuerpoRespuesta);
                ASN1Sequence seq = ASN1Sequence.getInstance(is.readObject());
                enc = null;
                if (seq.size() > 1) {
                    enc = seq.getObjectAt(1);
                }
                if (enc != null) break block52;
                return null;
            }
            byte[] byArray = enc.getDERObject().getEncoded();
            return byArray;
            {
                catch (TSPException e) {
                    try {
                        try {
                            log.error("La respuesta no es v\u00e1lida para la petici\u00f3n enviada: " + e.getMessage(), e);
                            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error9", e.getMessage()));
                        }
                        catch (TSPException e2) {
                            log.error("La respuesta est\u00e1 mal formada: " + e2.getMessage(), e2);
                            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error8", e2.getMessage()));
                        }
                        catch (IOException e3) {
                            log.error("La secuencia de bytes de respuesta no est\u00e1 codificada en ASN.1: " + e3.getMessage(), e3);
                            throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error7", e3.getMessage()));
                        }
                    }
                    catch (HttpException e4) {
                        log.error("Violaci\u00f3n del protocolo HTTP: " + e4.getMessage(), e4);
                        throw new TimeStampException(I18N.getLocalMessage("i18n.mityc.ts.error6", e4.getMessage()));
                    }
                    catch (IOException e5) {
                        String mensajeError = I18N.getLocalMessage("i18n.mityc.ts.error4", this.servidorTSA, e5);
                        log.error("Error en la conexi\u00f3n con el servidor TSA: " + e5.getMessage());
                        throw new TimeStampException(mensajeError);
                    }
                }
            }
        }
        finally {
            HostConfiguration hostConf = new HostConfiguration();
            hostConf.setHost(this.servidorTSA);
            HttpConnection conn = CLIENTE.getHttpConnectionManager().getConnection(hostConf);
            if (conn != null) {
                CLIENTE.getHttpConnectionManager().releaseConnection(conn);
                conn.close();
                conn.releaseConnection();
            }
            metodo.releaseConnection();
        }
    }

    public void setTimeOut(Integer timeMilis) {
        if (timeMilis != null && timeMilis > 0) {
            log.debug("Se establece el tiempo m\u00e1ximo de espera a " + timeMilis);
            this.timeOut = timeMilis;
        } else {
            log.error("No se pudo establecer el valor de TimeOut a " + timeMilis + ". Se toma el valor por defecto.");
            this.timeOut = INT10000;
        }
    }
}

