/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy;

import es.mityc.firmaJava.libreria.xades.DatosNodosFirmados;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.xml.xades.TransformProxy;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import es.mityc.javasign.xml.xades.policy.PolicyResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.w3c.dom.Element;

public class NoTransformsPolicy
implements IValidacionPolicy {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibPolicy");
    private static final String POLICY_URI = "self:policy/general/notransforms";

    @Override
    public String getIdentidadPolicy() {
        return I18N.getLocalMessage("i18n.mityc.policy.notransforms.2");
    }

    @Override
    public PolicyResult validaPolicy(Element nodoFirma, ResultadoValidacion resultadoValidacion) {
        PolicyResult pr = new PolicyResult();
        try {
            pr.setPolicyID(new URI(POLICY_URI));
            this.checkNoTransforms(nodoFirma, resultadoValidacion);
            pr.setResult(PolicyResult.StatusValidation.valid);
        }
        catch (PolicyException ex) {
            pr.setResult(PolicyResult.StatusValidation.invalid);
            pr.setDescriptionResult(ex.getMessage());
        }
        catch (URISyntaxException ex) {
            pr.setResult(PolicyResult.StatusValidation.unknown);
            pr.setDescriptionResult(ex.getMessage());
        }
        return pr;
    }

    protected void checkNoTransforms(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        List<DatosNodosFirmados> nodos = rs.getDatosFirma().getDatosNodosFirmados();
        for (DatosNodosFirmados nodo : nodos) {
            List<TransformProxy> trans = nodo.getTransforms();
            for (TransformProxy transform : trans) {
                String uri = transform.getURI();
                if (TransformProxy.isCanonicalization(transform) || uri.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature") || uri.equals("http://www.w3.org/2000/09/xmldsig#base64")) continue;
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.notransforms.1"));
            }
        }
    }

    @Override
    public void setTruster(TrustAbstract truster) {
    }
}

