/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy.age;

import es.mityc.firmaJava.libreria.utilidades.URIEncoder;
import es.mityc.firmaJava.libreria.xades.DatosFirma;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.xml.xades.policy.PolicyResult;
import es.mityc.javasign.xml.xades.policy.UnknownPolicyException;
import es.mityc.javasign.xml.xades.policy.age.AgeManager;
import es.mityc.javasign.xml.xades.policy.age.ConfigAGE;
import es.mityc.javasign.xml.xades.policy.age.ConfigAgeException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Age18Manager
extends AgeManager {
    private static final Log LOG = LogFactory.getLog(Age18Manager.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibPolicy");
    private static final String PREFIX_POLICY_PROP = "age18";
    private static ConfigAGE config = null;

    static {
        try {
            config = AgeManager.loadConfig(PREFIX_POLICY_PROP);
        }
        catch (ConfigAgeException ex) {
            LOG.fatal(I18N.getLocalMessage("i18n.mityc.policy.general.7"), ex);
        }
    }

    public Age18Manager() throws InstantiationException {
        if (config == null) {
            throw new InstantiationException(I18N.getLocalMessage("i18n.mityc.policy.general.8"));
        }
    }

    @Override
    protected ConfigAGE getConfig() {
        return config;
    }

    @Override
    public String getIdentidadPolicy() {
        return config.getPolicyIdValidador();
    }

    @Override
    public PolicyResult validaPolicy(Element nodoFirma, ResultadoValidacion resultadoValidacion) {
        PolicyResult pr = new PolicyResult();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validando pol\u00edtica de AGE");
        }
        try {
            URI id = config.getPolicyIdXades();
            try {
                id = new URI(Age18Manager.getFormatedMessage(PREFIX_POLICY_PROP, URIEncoder.encode(config.getPolicyIdValidador(), "UTF-8")));
            }
            catch (URISyntaxException ex) {
                LOG.warn(I18N.getLocalMessage("i18n.mityc.policy.general.9"), ex);
            }
            catch (UnsupportedEncodingException ex) {
                LOG.warn(I18N.getLocalMessage("i18n.mityc.policy.general.9"), ex);
            }
            pr.setPolicyID(id);
            pr.setDownloable(new PolicyResult.DownloadPolicy[]{pr.newDownloadPolicy(config.getSpUri(), PolicyResult.StatusValidation.unknown)});
            this.checkSchema(nodoFirma, resultadoValidacion);
            this.checkPolicyHash(nodoFirma, resultadoValidacion);
            this.checkNodes(nodoFirma, resultadoValidacion);
            this.checkCertificateInKeyInfoNode(nodoFirma, resultadoValidacion);
            this.checkRoles(nodoFirma, resultadoValidacion);
            this.checkTimestamp(nodoFirma, resultadoValidacion);
            this.checkStatusCertificate(nodoFirma, resultadoValidacion);
            this.checkTrustSigningCertificate(nodoFirma, resultadoValidacion);
            this.checkTrustTsa(nodoFirma, resultadoValidacion);
            pr.setResult(PolicyResult.StatusValidation.valid);
        }
        catch (UnknownPolicyException ex) {
            pr.setResult(PolicyResult.StatusValidation.unknown);
            pr.setDescriptionResult(ex.getMessage());
        }
        catch (PolicyException ex) {
            pr.setResult(PolicyResult.StatusValidation.invalid);
            pr.setDescriptionResult(ex.getMessage());
        }
        return pr;
    }

    protected void checkSchema(Element nodoFirma, ResultadoValidacion rs) throws PolicyException {
        DatosFirma df = rs.getDatosFirma();
        if (df != null) {
            XAdESSchemas schema = df.getEsquema();
            if (XAdESSchemas.XAdES_111.equals(schema) || XAdESSchemas.XMLDSIG.equals(schema)) {
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.24"));
            }
        } else {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.23"));
        }
    }

    @Override
    public void writePolicyNode(Element signNode, String namespaceDS, String namespaceXAdES, XAdESSchemas schema) throws PolicyException {
        this.escribePolicy(signNode, namespaceDS, namespaceXAdES, schema);
    }

    @Override
    public void setTruster(TrustAbstract truster) {
        if (truster != null) {
            this.truster = truster;
        }
    }
}

