/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy.facturae;

import es.mityc.firmaJava.libreria.xades.elementos.xades.DigestAlgAndValueType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyHash;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.xml.xades.policy.facturae.ConfigFacturaeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigFacturae {
    private static final Log LOG = LogFactory.getLog(ConfigFacturae.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibPolicy");
    private static final String STRING_POINT = ".";
    private static final String STRING_EMPTY = "";
    private URI policyIdXades;
    private String policyIdValidador;
    private String policyDescription;
    private ArrayList<DigestAlgAndValueType> huellas;
    private int policyWriterId;

    public ConfigFacturae(Properties props, String prefix) throws ConfigFacturaeException {
        String prep;
        block14: {
            this.policyIdXades = null;
            this.policyIdValidador = null;
            this.policyDescription = null;
            this.huellas = null;
            this.policyWriterId = -1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Se carga la configuraci\u00f3n de pol\u00edticas de factura: " + prefix);
            }
            prep = STRING_EMPTY;
            if (prefix != null && !STRING_EMPTY.equals(prefix.trim())) {
                prep = String.valueOf(prefix) + STRING_POINT;
            }
            try {
                String policyIdXadesStr = props.getProperty(String.valueOf(prep) + "policy.id");
                this.policyIdValidador = props.getProperty(String.valueOf(prep) + "policy.idValidator");
                if (policyIdXadesStr == null || this.policyIdValidador == null) {
                    LOG.fatal(I18N.getLocalMessage("i18n.mityc.policy.general.1"));
                    throw new ConfigFacturaeException(I18N.getLocalMessage("i18n.mityc.policy.general.2"));
                }
                this.policyIdXades = new URI(policyIdXadesStr);
            }
            catch (URISyntaxException ex) {
                LOG.fatal(I18N.getLocalMessage("i18n.mityc.policy.general.3"));
                throw new ConfigFacturaeException(I18N.getLocalMessage("i18n.mityc.policy.general.2"), ex);
            }
            try {
                this.policyDescription = props.getProperty(String.valueOf(prep) + "policy.idValidator");
            }
            catch (MissingResourceException ex) {
                if (!LOG.isTraceEnabled()) break block14;
                LOG.trace(I18N.getLocalMessage("i18n.mityc.policy.general.4", prep));
            }
        }
        this.huellas = new ArrayList();
        int i = 0;
        while (true) {
            String hashId = props.getProperty(String.valueOf(prep) + "policy.digest.id." + i);
            String hashValue = props.getProperty(String.valueOf(prep) + "policy.digest.value." + i);
            if (hashId == null || hashValue == null) break;
            this.huellas.add(new SigPolicyHash(null, hashId, hashValue));
            ++i;
        }
        try {
            String policyWriterIdStr = props.getProperty(String.valueOf(prep) + "policy.writer.digest");
            if (policyWriterIdStr == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(I18N.getLocalMessage("i18n.mityc.policy.general.6", prep));
                }
            } else {
                this.policyWriterId = Integer.parseInt(policyWriterIdStr);
                if (this.policyWriterId >= this.huellas.size()) {
                    this.policyWriterId = -1;
                    LOG.error(I18N.getLocalMessage("i18n.mityc.policy.general.5"));
                }
            }
        }
        catch (NumberFormatException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.policy.general.5"), ex);
        }
    }

    public URI getPolicyIdXades() {
        return this.policyIdXades;
    }

    public String getPolicyIdValidador() {
        return this.policyIdValidador;
    }

    public String getPolicyDescription() {
        return this.policyDescription;
    }

    public int getPolicyWriterId() {
        return this.policyWriterId;
    }

    public ArrayList<DigestAlgAndValueType> getHuellas() {
        return this.huellas;
    }
}

