/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy.facturae;

import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.DatosFirma;
import es.mityc.firmaJava.libreria.xades.DatosNodosFirmados;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DigestAlgAndValueType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyHash;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyId;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyIdentifier;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.TrustFactory;
import es.mityc.javasign.xml.xades.TransformProxy;
import es.mityc.javasign.xml.xades.policy.IFirmaPolicy;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import es.mityc.javasign.xml.xades.policy.PoliciesTool;
import es.mityc.javasign.xml.xades.policy.UnknownPolicyException;
import es.mityc.javasign.xml.xades.policy.facturae.ConfigFacturae;
import es.mityc.javasign.xml.xades.policy.facturae.ConfigFacturaeException;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class FacturaeManager
implements IValidacionPolicy,
IFirmaPolicy {
    private static final Log LOG = LogFactory.getLog(FacturaeManager.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibPolicy");
    private static final String CONFIG_FILENAME = "facturae.properties";
    protected static final String URI_ID_POLICY = "text:{0}";
    protected static final String UTF_8 = "UTF-8";
    private static final String MATCH_ROLES = "[eE][mM][iI][sS][oO][rR]|[sS][uU][pP][pP][lL][iI][eE][rR]|[rR][eE][cC][eE][pP][tT][oO][rR]|[cC][uU][sS][tT][oO][mM][eE][rR]|[tT][eE][rR][cC][eE][rR][oO]|[tT][hH][iI][rR][dD] [pP][aA][rR][tT][yY]";
    private static Properties rb = null;
    protected TrustAbstract truster = TrustFactory.getInstance().getTruster("mityc");

    static {
        try {
            InputStream is = FacturaeManager.class.getResourceAsStream(CONFIG_FILENAME);
            if (is != null) {
                rb = new Properties();
                rb.load(is);
            } else {
                LOG.error("No se encontr\u00f3 configuraci\u00f3n sobre pol\u00edticas");
            }
        }
        catch (IOException ex) {
            LOG.fatal(I18N.getLocalMessage("i18n.mityc.policy.general.12"), ex);
        }
    }

    protected FacturaeManager() throws InstantiationException {
        if (this.truster == null) {
            throw new InstantiationException(I18N.getLocalMessage("i18n.mityc.policy.general.29"));
        }
    }

    protected static ConfigFacturae loadConfig(String prefix) throws ConfigFacturaeException {
        if (rb == null) {
            throw new ConfigFacturaeException(I18N.getLocalMessage("i18n.mityc.policy.general.13"));
        }
        return new ConfigFacturae(rb, prefix);
    }

    private DigestAlgAndValueType getDigestRelated(String algorithm) {
        DigestAlgAndValueType daavt = null;
        for (DigestAlgAndValueType temp : this.getConfig().getHuellas()) {
            if (!temp.getDigestMethod().getAlgorithm().equals(algorithm)) continue;
            daavt = temp;
            break;
        }
        return daavt;
    }

    protected void checkPolicyHash(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        XAdESSchemas schema = rs.getDatosFirma().getEsquema();
        if (schema == null) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.25"));
        }
        String esquema = schema.getSchemaUri();
        NodeList signaturePolicyList = signatureNode.getElementsByTagNameNS(esquema, "SignaturePolicyIdentifier");
        if (signaturePolicyList.getLength() != 1) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.26"));
        }
        if (signaturePolicyList.item(0).getNodeType() != 1) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.26"));
        }
        try {
            SignaturePolicyIdentifier signaturePolicyIdentifier = new SignaturePolicyIdentifier(schema);
            if (!signaturePolicyIdentifier.isThisNode(signaturePolicyList.item(0))) {
                throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.14"));
            }
            signaturePolicyIdentifier.load((Element)signaturePolicyList.item(0));
            if (signaturePolicyIdentifier.isImplied()) {
                throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.15"));
            }
            DigestAlgAndValueType value = this.getDigestRelated(signaturePolicyIdentifier.getSignaturePolicyId().getSigPolicyHash().getDigestMethod().getAlgorithm());
            SignaturePolicyIdentifier comp = this.createPolicy(schema, value);
            if (!signaturePolicyIdentifier.equals(comp)) {
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.27"));
            }
        }
        catch (InvalidInfoNodeException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18N.getLocalMessage("i18n.mityc.policy.general.16"), ex);
            }
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.28", ex.getMessage()));
        }
    }

    protected void checkEnveloped(Element signatureNode, ResultadoValidacion rs) throws UnknownPolicyException, PolicyException {
        List<DatosNodosFirmados> nodos = rs.getDatosFirma().getDatosNodosFirmados();
        for (DatosNodosFirmados nodo : nodos) {
            if (!"".equals(nodo.getURI())) continue;
            boolean isEnveloped = false;
            List<TransformProxy> trans = nodo.getTransforms();
            for (TransformProxy transform : trans) {
                String uri = transform.getURI();
                if (TransformProxy.isCanonicalization(transform)) continue;
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                    isEnveloped = true;
                    continue;
                }
                throw new UnknownPolicyException(I18N.getLocalMessage("i18n.mityc.policy.facturae.3"));
            }
            if (!isEnveloped) continue;
            return;
        }
        throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.facturae.2"));
    }

    protected void checkCertificateInKeyInfoNode(Element signatureNode, ResultadoValidacion rs) throws UnknownPolicyException, PolicyException {
        List<DatosNodosFirmados> nodos = rs.getDatosFirma().getDatosNodosFirmados();
        for (DatosNodosFirmados nodo : nodos) {
            Element el;
            String id = nodo.getId();
            if (id == null || (el = UtilidadTratarNodo.getElementById(signatureNode.getOwnerDocument(), id)) == null || !"http://www.w3.org/2000/09/xmldsig#".equals(el.getNamespaceURI()) || !"KeyInfo".equals(el.getLocalName()) || !el.getParentNode().equals(signatureNode)) continue;
            List<TransformProxy> trans = nodo.getTransforms();
            for (TransformProxy transform : trans) {
                if (TransformProxy.isCanonicalization(transform)) continue;
                throw new UnknownPolicyException(I18N.getLocalMessage("i18n.mityc.policy.facturae.4"));
            }
            return;
        }
        throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.30"));
    }

    protected void checkRoles(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        DatosFirma df = rs.getDatosFirma();
        if (df != null) {
            ArrayList<String> roles = df.getRoles();
            if (roles != null && roles.size() > 0) {
                for (String role : roles) {
                    if (role.matches(MATCH_ROLES)) continue;
                    throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.22"));
                }
            }
        } else {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.21"));
        }
    }

    protected void checkTimestamp(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
    }

    protected void checkStatusCertificate(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
    }

    protected void checkTrustSigningCertificate(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        DatosFirma df = rs.getDatosFirma();
        if (df != null) {
            try {
                this.truster.isTrusted(df.getCadenaFirma());
            }
            catch (TrustException ex) {
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.facturae.1"));
            }
        } else {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.20"));
        }
    }

    protected void checkTrustTsa(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
    }

    protected SignaturePolicyIdentifier createPolicy(XAdESSchemas schema, DigestAlgAndValueType value) throws InvalidInfoNodeException {
        if (value == null) {
            throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.17"));
        }
        ConfigFacturae config = this.getConfig();
        SignaturePolicyIdentifier resultado = new SignaturePolicyIdentifier(schema, false);
        resultado.getSignaturePolicyId().setSigPolicyId(new SigPolicyId(schema, config.getPolicyIdXades(), config.getPolicyDescription()));
        resultado.getSignaturePolicyId().setSigPolicyHash(new SigPolicyHash(schema, value));
        return resultado;
    }

    public void escribePolicy(Element signatureNode, String namespaceDS, String namespaceXAdES, XAdESSchemas schema) throws PolicyException {
        SignaturePolicyIdentifier spi;
        ConfigFacturae config = this.getConfig();
        try {
            if (config.getPolicyWriterId() < 0 || config.getPolicyWriterId() >= config.getHuellas().size()) {
                throw new InvalidInfoNodeException(I18N.getLocalMessage("i18n.mityc.policy.general.18"));
            }
            DigestAlgAndValueType hash = config.getHuellas().get(config.getPolicyWriterId());
            spi = this.createPolicy(schema, hash);
        }
        catch (InvalidInfoNodeException ex) {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.general.19"));
        }
        PoliciesTool.insertPolicyNode(signatureNode, namespaceDS, namespaceXAdES, schema, spi);
    }

    protected static String getFormatedMessage(String message, Object ... varargs) {
        MessageFormat mf = new MessageFormat(message);
        return mf.format(varargs, new StringBuffer(), (FieldPosition)null).toString();
    }

    protected abstract ConfigFacturae getConfig();
}

