/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(RetrievalMethodResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            String type = rm.getType();
            XMLSignatureInput resource = RetrievalMethodResolver.resolveInput(rm, BaseURI);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(type)) {
                X509Certificate cert = RetrievalMethodResolver.getRawCertificate(resource);
                if (cert != null) {
                    return cert.getPublicKey();
                }
                return null;
            }
            Element e = RetrievalMethodResolver.obtainRefrenceElement(resource);
            return RetrievalMethodResolver.resolveKey(e, BaseURI, storage);
        }
        catch (XMLSecurityException ex) {
            log.debug("XMLSecurityException", ex);
        }
        catch (CertificateException ex) {
            log.debug("CertificateException", ex);
        }
        catch (IOException ex) {
            log.debug("IOException", ex);
        }
        catch (ParserConfigurationException e) {
            log.debug("ParserConfigurationException", e);
        }
        catch (SAXException e) {
            log.debug("SAXException", e);
        }
        return null;
    }

    private static Element obtainRefrenceElement(XMLSignatureInput resource) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element e;
        if (resource.isElement()) {
            e = (Element)resource.getSubNode();
        } else if (resource.isNodeSet()) {
            e = RetrievalMethodResolver.getDocumentElement(resource.getNodeSet());
        } else {
            byte[] inputBytes = resource.getBytes();
            e = RetrievalMethodResolver.getDocFromBytes(inputBytes);
            if (log.isDebugEnabled()) {
                log.debug("we have to parse " + inputBytes.length + " bytes");
            }
        }
        return e;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            String type = rm.getType();
            XMLSignatureInput resource = RetrievalMethodResolver.resolveInput(rm, BaseURI);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(type)) {
                X509Certificate cert = RetrievalMethodResolver.getRawCertificate(resource);
                return cert;
            }
            Element e = RetrievalMethodResolver.obtainRefrenceElement(resource);
            return RetrievalMethodResolver.resolveCertificate(e, BaseURI, storage);
        }
        catch (XMLSecurityException ex) {
            log.debug("XMLSecurityException", ex);
        }
        catch (CertificateException ex) {
            log.debug("CertificateException", ex);
        }
        catch (IOException ex) {
            log.debug("IOException", ex);
        }
        catch (ParserConfigurationException e) {
            log.debug("ParserConfigurationException", e);
        }
        catch (SAXException e) {
            log.debug("SAXException", e);
        }
        return null;
    }

    private static X509Certificate resolveCertificate(Element e, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element");
        }
        if (e != null) {
            return KeyResolver.getX509Certificate(e, BaseURI, storage);
        }
        return null;
    }

    private static PublicKey resolveKey(Element e, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element");
        }
        if (e != null) {
            return KeyResolver.getPublicKey(e, BaseURI, storage);
        }
        return null;
    }

    private static X509Certificate getRawCertificate(XMLSignatureInput resource) throws CanonicalizationException, IOException, CertificateException {
        byte[] inputBytes = resource.getBytes();
        CertificateFactory certFact = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
        return cert;
    }

    private static XMLSignatureInput resolveInput(RetrievalMethod rm, String BaseURI) throws XMLSecurityException {
        Attr uri = rm.getURIAttr();
        Transforms transforms = rm.getTransforms();
        ResourceResolver resRes = ResourceResolver.getInstance(uri, BaseURI);
        if (resRes != null) {
            XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
            if (transforms != null) {
                log.debug("We have Transforms");
                resource = transforms.performTransforms(resource);
            }
            return resource;
        }
        return null;
    }

    static Element getDocFromBytes(byte[] bytes) throws KeyResolverException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (SAXException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (IOException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new KeyResolverException("empty", ex);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    static Element getDocumentElement(Set set) {
        Node n;
        Iterator it = set.iterator();
        Element e = null;
        while (it.hasNext()) {
            Node currentNode = (Node)it.next();
            if (!(currentNode instanceof Element)) continue;
            e = (Element)currentNode;
            break;
        }
        ArrayList<Element> parents = new ArrayList<Element>(10);
        do {
            parents.add(e);
        } while ((n = e.getParentNode()) instanceof Element && (e = (Element)n) != null);
        ListIterator it2 = parents.listIterator(parents.size() - 1);
        Element ele = null;
        while (it2.hasPrevious()) {
            ele = (Element)it2.previous();
            if (!set.contains(ele)) continue;
            return ele;
        }
        return null;
    }
}

