/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;

public abstract class ResourceResolverSpi {
    static Log log = LogFactory.getLog(ResourceResolverSpi.class.getName());
    protected Map _properties = null;

    public abstract XMLSignatureInput engineResolve(Attr var1, String var2) throws ResourceResolverException;

    public void engineSetProperty(String key, String value) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(key, value);
    }

    public String engineGetProperty(String key) {
        if (this._properties == null) {
            return null;
        }
        return (String)this._properties.get(key);
    }

    public void engineAddProperies(Map properties) {
        if (properties != null) {
            if (this._properties == null) {
                this._properties = new HashMap();
            }
            this._properties.putAll(properties);
        }
    }

    public boolean engineIsThreadSafe() {
        return false;
    }

    public boolean engineIsPrivateData() {
        return false;
    }

    public abstract boolean engineCanResolve(Attr var1, String var2);

    public String[] engineGetPropertyKeys() {
        return new String[0];
    }

    public boolean understandsProperty(String propertyToTest) {
        String[] understood = this.engineGetPropertyKeys();
        if (understood != null) {
            for (int i = 0; i < understood.length; ++i) {
                if (!understood[i].equals(propertyToTest)) continue;
                return true;
            }
        }
        return false;
    }

    public static String fixURI(String str) {
        char ch0;
        char ch1;
        if ((str = str.replace(File.separatorChar, '/')).length() >= 4) {
            boolean isDosFilename;
            char ch02 = Character.toUpperCase(str.charAt(0));
            char ch12 = str.charAt(1);
            char ch2 = str.charAt(2);
            char ch3 = str.charAt(3);
            boolean bl = isDosFilename = 'A' <= ch02 && ch02 <= 'Z' && ch12 == ':' && ch2 == '/' && ch3 != '/';
            if (isDosFilename && log.isDebugEnabled()) {
                log.debug("Found DOS filename: " + str);
            }
        }
        if (str.length() >= 2 && (ch1 = str.charAt(1)) == ':' && 'A' <= (ch0 = Character.toUpperCase(str.charAt(0))) && ch0 <= 'Z') {
            str = "/" + str;
        }
        return str;
    }
}

