/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.RecipientInfoGenerator;

class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private SecretKey wrapKey;
    private KEKIdentifier secKeyId;
    private AlgorithmIdentifier keyEncAlg;

    KEKRecipientInfoGenerator() {
    }

    void setWrapKey(SecretKey secretKey) {
        this.wrapKey = secretKey;
        this.keyEncAlg = KEKRecipientInfoGenerator.determineKeyEncAlg(secretKey);
    }

    void setKEKIdentifier(KEKIdentifier kEKIdentifier) {
        this.secKeyId = kEKIdentifier;
    }

    @Override
    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        Cipher cipher = CMSEnvelopedHelper.INSTANCE.createAsymmetricCipher(this.keyEncAlg.getObjectId().getId(), provider);
        cipher.init(3, (Key)this.wrapKey, secureRandom);
        DEROctetString dEROctetString = new DEROctetString(cipher.wrap(secretKey));
        return new RecipientInfo(new KEKRecipientInfo(this.secKeyId, this.keyEncAlg, dEROctetString));
    }

    private static AlgorithmIdentifier determineKeyEncAlg(SecretKey secretKey) {
        String string = secretKey.getAlgorithm();
        if (string.startsWith("DES")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), new DERNull());
        }
        if (string.startsWith("RC2")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), new DERInteger(58));
        }
        if (string.startsWith("AES")) {
            DERObjectIdentifier dERObjectIdentifier;
            int n = secretKey.getEncoded().length * 8;
            if (n == 128) {
                dERObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
            } else if (n == 192) {
                dERObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
            } else if (n == 256) {
                dERObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in AES");
            }
            return new AlgorithmIdentifier(dERObjectIdentifier);
        }
        if (string.startsWith("SEED")) {
            return new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        }
        if (string.startsWith("Camellia")) {
            DERObjectIdentifier dERObjectIdentifier;
            int n = secretKey.getEncoded().length * 8;
            if (n == 128) {
                dERObjectIdentifier = NTTObjectIdentifiers.id_camellia128_wrap;
            } else if (n == 192) {
                dERObjectIdentifier = NTTObjectIdentifiers.id_camellia192_wrap;
            } else if (n == 256) {
                dERObjectIdentifier = NTTObjectIdentifiers.id_camellia256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in Camellia");
            }
            return new AlgorithmIdentifier(dERObjectIdentifier);
        }
        throw new IllegalArgumentException("unknown algorithm");
    }
}

